/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.lang.Modifiable;
import rma.lang.ModifiedEventControl;
import rma.swing.tree.RmaMutableTreeNode;
import rma.swing.tree.RmaTreeModel;
import rma.util.RMAUtil;

public class RmaJTree
extends JTree
implements Modifiable,
ModifiedEventControl {
    private boolean _forwardModifiedEvents = true;
    private boolean _modified;
    private boolean _ignoreModifiedEvents;

    public RmaJTree() {
    }

    public RmaJTree(RmaTreeModel model) {
        super(model);
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        Object o = path.getLastPathComponent();
        if (o instanceof RmaMutableTreeNode) {
            return ((RmaMutableTreeNode)o).isEditable();
        }
        return super.isPathEditable(path);
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    public void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    @Override
    public void setIgnoreModifiedEvents(boolean ignore) {
        this._ignoreModifiedEvents = ignore;
    }

    public boolean isIgnoringModifiedEvents() {
        return this.getIgnoreModifiedEvents();
    }

    @Override
    public boolean getIgnoreModifiedEvents() {
        return this._ignoreModifiedEvents;
    }

    @Override
    public boolean isModified() {
        return this._modified;
    }

    @Override
    public void setModified(boolean b) {
        if (this._ignoreModifiedEvents) {
            return;
        }
        this._modified = b;
        if (b && this.forwardModifiedEvents()) {
            RMAUtil.setParentModified(this);
        }
    }

    public boolean forwardModifiedEvents() {
        return this.getForwardModifiedEvents();
    }

    @Override
    public boolean getForwardModifiedEvents() {
        return this._forwardModifiedEvents;
    }

    @Override
    public void setFowardModifiedEvents(boolean b) {
        this._forwardModifiedEvents = b;
    }
}

