/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.tree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import rma.swing.tree.LabelIconObject;

public class RmaTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof Icon) {
            if (isSelected) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            this.setIcon((Icon)userObj);
            this.setText("");
            this.setEnabled(tree.isEnabled());
            this.setComponentOrientation(tree.getComponentOrientation());
            this.selected = isSelected;
        } else if (userObj instanceof LabelIconObject) {
            LabelIconObject labelIcon = (LabelIconObject)userObj;
            if (isSelected) {
                this.setForeground(this.getTextSelectionColor());
            } else {
                this.setForeground(this.getTextNonSelectionColor());
            }
            this.setIcon(labelIcon.getIcon());
            this.setText(labelIcon.getLabel());
            this.setEnabled(tree.isEnabled());
            this.setComponentOrientation(tree.getComponentOrientation());
            this.selected = isSelected;
        } else {
            if (userObj instanceof JPanel) {
                return (JPanel)userObj;
            }
            return super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
        return this;
    }
}

