/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.treeTable;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import rma.swing.RmaJTextField;

public class PathCellEditor
implements TableCellEditor {
    protected Map<TreeNode, TableCellEditor> _editors = new Hashtable<TreeNode, TableCellEditor>();
    protected TableCellEditor _editor;
    protected TableCellEditor defaultEditor;
    protected int _clickCountToStart = 1;
    private JXTreeTable _treeTable;

    public PathCellEditor(TableCellEditor tce, JXTreeTable treeTable) {
        this.defaultEditor = tce;
        this._treeTable = treeTable;
    }

    public PathCellEditor(JXTreeTable treeTable) {
        this(new RmaJTextField(), treeTable);
    }

    protected PathCellEditor(RmaJTextField field, JXTreeTable treeTable) {
        this(new DefaultCellEditor(field), treeTable);
        field.setBorder(new LineBorder(Color.black));
    }

    public void add(TreeNode node, TableCellEditor cellEditor) {
        this._editors.put(node, cellEditor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        TreePath treePath = ((JXTreeTable)table).getPathForRow(row);
        TreeNode node = (TreeNode)treePath.getLastPathComponent();
        this._editor = this._editors.get(node);
        if (this._editor == null) {
            this._editor = this.defaultEditor;
        }
        return this._editor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public void setClickCountToStart(int clickCount) {
        this._clickCountToStart = clickCount;
    }

    @Override
    public Object getCellEditorValue() {
        return this._editor.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return this._editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this._editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (this._editor != null) {
            return this._editor.isCellEditable(anEvent);
        }
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this._clickCountToStart;
        }
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this._editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this._editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this._editor.shouldSelectCell(anEvent);
    }

    public TableCellEditor getCellEditor(int row) {
        TreePath treePath = this._treeTable.getPathForRow(row);
        return this._editors.get(treePath);
    }

    public Map<TreeNode, TableCellEditor> getCellEditorTable() {
        return this._editors;
    }

    public int getNumberRowEditors() {
        return this._editors.size();
    }
}

