/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.treeTable;

import java.awt.Component;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import rma.swing.table.RmaCellRenderer;

public class PathCellRenderer
implements TableCellRenderer {
    protected Map<TreeNode, TableCellRenderer> _renderers = new Hashtable<TreeNode, TableCellRenderer>();
    protected TableCellRenderer _defaultRenderer;

    public PathCellRenderer() {
        this(new RmaCellRenderer());
    }

    public PathCellRenderer(TableCellRenderer tce) {
        if (tce == null) {
            tce = new RmaCellRenderer();
        }
        this._defaultRenderer = tce;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TreePath path = ((JXTreeTable)table).getPathForRow(row);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        TableCellRenderer renderer = this._renderers.get(node);
        if (renderer == null) {
            renderer = this._defaultRenderer;
        }
        return renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void add(TreeNode node, TableCellRenderer renderer) {
        this._renderers.put(node, renderer);
    }
}

