/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.wheel;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class ClassDirFinder {
    public static String find(String className) {
        try {
            String classPath = System.getProperty("java.class.path");
            String classFile = className.replace('.', File.separatorChar) + ".class";
            String classEntry = className.replace('.', '/') + ".class";
            StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dirFile;
                String dirName = st.nextToken();
                if (dirName.endsWith(File.separator)) {
                    dirName = dirName.substring(0, dirName.lastIndexOf(File.separator));
                }
                if ((dirFile = new File(dirName)).isDirectory()) {
                    String filename = dirName + File.separatorChar + classFile;
                    if (!new File(filename).exists()) continue;
                    return dirName;
                }
                if (!dirFile.isFile()) continue;
                ZipFile zf = new ZipFile(dirFile);
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    String entryName = e.nextElement().getName();
                    if (!entryName.equals(classEntry)) continue;
                    int index = dirName.lastIndexOf(File.separator);
                    if (index != -1) {
                        return dirName.substring(0, dirName.lastIndexOf(File.separator));
                    }
                    return ".";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return ".";
    }
}

