/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.wheel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class Config {
    public static final int MK_LBUTTON = 1;
    public static final int MK_RBUTTON = 2;
    public static final int MK_SHIFT = 4;
    public static final int MK_CONTROL = 8;
    public static final int MK_MBUTTON = 16;
    public static final int MK_ALT = 32768;
    public static final int MODE_EDITORONLY = 1;
    public static final int MODE_FOCUSED = 2;
    public static final int MODE_UNDERCURSOR = 3;
    private static final String KEY_SENSITIVITY = "scroll.sensitivity";
    private static final String KEY_MODE = "scroll.mode";
    private static final String KEY_FOLLOWBAR = "scroll.followscrollbar";
    private static final String KEY_REVERSE = "reverse";
    private static final String KEY_ACTION = "action";
    private static final String KEY_DEBUG = "debug";
    private static final String FNAME = "javaMouseWheel.properties";
    private static final int DEF_SENSITIVITY = 30;
    private static final int DEF_MODE = 3;
    private static final boolean DEF_REVERSE = false;
    private static final boolean DEF_FOLLOWBAR = true;
    private static final boolean DEF_DEBUG = false;
    public int sensitivity = 30;
    public int mode = 3;
    public boolean reverse = false;
    public boolean followBar = true;
    public HashMap actions = new HashMap();
    public boolean debug = false;
    private Properties props = new Properties();

    public Config(Config c2) {
        this.sensitivity = c2.sensitivity;
        this.mode = c2.mode;
        this.reverse = c2.reverse;
        this.followBar = c2.followBar;
        this.actions = c2.actions;
        this.debug = c2.debug;
    }

    public Config() {
        this.read();
        if (this.actions.isEmpty()) {
            this.actions.put(new Integer(0), Action.VSCROLL);
            this.actions.put(new Integer(8), Action.PGVSCROLL);
            this.actions.put(new Integer(4), Action.NEXTNODE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        try (BufferedInputStream in = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(FNAME));){
            this.props.load(in);
            this.sensitivity = Integer.parseInt(this.props.getProperty(KEY_SENSITIVITY, String.valueOf(30)));
            this.mode = Integer.parseInt(this.props.getProperty(KEY_MODE, String.valueOf(3)));
            this.reverse = Boolean.valueOf(this.props.getProperty(KEY_REVERSE, String.valueOf(false)));
            this.followBar = Boolean.valueOf(this.props.getProperty(KEY_FOLLOWBAR, String.valueOf(true)));
            this.debug = Boolean.valueOf(this.props.getProperty(KEY_DEBUG, String.valueOf(false)));
            Enumeration<Object> en = this.props.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.startsWith(KEY_ACTION)) continue;
                String a = this.props.getProperty(key);
                key = key.substring(KEY_ACTION.length() + 1);
                this.actions.put(Integer.decode(key), Integer.decode(a));
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FNAME));){
            this.props.clear();
            this.props.setProperty(KEY_SENSITIVITY, String.valueOf(this.sensitivity));
            this.props.setProperty(KEY_MODE, String.valueOf(this.mode));
            this.props.setProperty(KEY_REVERSE, String.valueOf(this.reverse));
            this.props.setProperty(KEY_FOLLOWBAR, String.valueOf(this.followBar));
            this.props.setProperty(KEY_DEBUG, String.valueOf(this.debug));
            for (Object key : this.actions.keySet()) {
                Object a = this.actions.get(key);
                this.props.setProperty("action." + key.toString(), a.toString());
            }
            this.props.store(out, "jbWheel settings");
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static interface Action {
        public static final int none = 0;
        public static final int vscroll = 1;
        public static final int hscroll = 2;
        public static final int pgvscroll = 3;
        public static final int pghscroll = 5;
        public static final int nextnode = 4;
        public static final Integer NONE = new Integer(0);
        public static final Integer VSCROLL = new Integer(1);
        public static final Integer HSCROLL = new Integer(2);
        public static final Integer PGVSCROLL = new Integer(3);
        public static final Integer PGHSCROLL = new Integer(5);
        public static final Integer NEXTNODE = new Integer(4);
        public static final String[] names = new String[]{"None", "Scroll up/down", "Scroll left/right", "Page up/down", "Go to next/previous file", "Page left/right"};
    }
}

