/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.wheel;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import rma.swing.RmaJDialog;
import rma.swing.wheel.Config;

public class WheelTool {
    private static final int NOTCH_MOVE = 120;
    private Config conf = new Config();
    private int reminder;
    private JScrollBar scrollFound;
    private WheelNotifier notifier;
    private static final String DLL_NAME = "rmaUtil";
    private static WheelTool I;
    private int action;

    public static void initWheelTool() {
        if (Boolean.getBoolean("use.mousewheel") && I == null) {
            I = new WheelTool();
        }
    }

    private WheelTool() {
        this.trace("Starting jbWheel");
        try {
            if (System.getProperty("java.vm.version", "").indexOf("1.2") == -1) {
                this.notifier = new WheelNotifier();
                this.trace(" ...running on JVM 1.3+");
            }
            System.loadLibrary(DLL_NAME);
            this.startCaptureWheelMessages(this.conf.debug);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString());
            ex.printStackTrace();
        }
    }

    private native void startCaptureWheelMessages(boolean var1);

    private native void stopCaptureWheelMessages();

    public synchronized void onWheelMoved(int move, int x, int y, int mask) {
        this.trace("wheel move notification");
        try {
            if (this.notifier == null) {
                this.wheelMoved(move, x, y, mask);
            } else {
                this.notifier.move += move;
                this.notifier.x = x;
                this.notifier.y = y;
                this.notifier.mask = mask;
                SwingUtilities.invokeLater(this.notifier);
            }
        }
        catch (Exception ex) {
            this.trace("E X C E P T I O N");
            ex.printStackTrace();
        }
    }

    public void wheelMoved(int move, int x, int y, int mask) {
        if (this.conf.reverse) {
            move = -move;
        }
        if (move * this.reminder >= 0) {
            move += this.reminder;
        }
        this.reminder = this.conf.sensitivity * move % 1200;
        this.trace(" ...amount to scroll: " + move);
        if (move == 0) {
            return;
        }
        Integer i = (Integer)this.conf.actions.get(new Integer(mask));
        if (i == null) {
            return;
        }
        this.action = i;
        switch (this.action) {
            default: 
        }
        this.actionScroll(move, x, y);
    }

    private void actionScroll(int move, int x, int y) {
        this.scrollFound = null;
        JComponent c2 = null;
        if (this.conf.mode != 1) {
            if (this.conf.mode == 3) {
                c2 = this.findComponentAt(x, y);
            } else if (this.conf.mode == 2) {
                c2 = this.findFocused();
            }
        }
        if (c2 instanceof Scrollable) {
            this.scrollScrollable(c2, move);
        } else if (c2 instanceof JScrollPane) {
            this.scrollPanel((JScrollPane)c2, move);
        } else if (c2 instanceof JSlider) {
            this.scrollSlider((JSlider)c2, move);
        } else if (c2 instanceof JComboBox) {
            this.scrollCombo((JComboBox)c2, move);
        } else if (this.scrollFound != null) {
            this.scrollScrollBar(move);
        } else if (this.conf.debug) {
            this.trace("nothing suitable to scroll: " + (c2 == null ? "null" : c2.getClass().getName()));
        }
    }

    private void scrollScrollable(JComponent comp, int move) {
        int orient;
        Rectangle r = new Rectangle();
        comp.computeVisibleRect(r);
        int i = 0;
        int n = this.scrollFound != null && this.conf.followBar ? this.scrollFound.getOrientation() : (orient = this.action == 1 || this.action == 3 ? 1 : 0);
        if (this.action == 3 || this.action == 5) {
            i = ((Scrollable)((Object)comp)).getScrollableBlockIncrement(r, orient, -move);
            if (move < 0) {
                i = -i;
            }
        } else {
            int incr = ((Scrollable)((Object)comp)).getScrollableUnitIncrement(r, orient, -move);
            i = this.conf.sensitivity * move / 1200 * incr;
        }
        if (orient == 1) {
            r.y -= i;
            r.y = r.y < 0 ? Math.max(0, r.y) : Math.min(comp.getHeight() - r.height, r.y);
        } else {
            r.x -= i;
            r.x = r.x < 0 ? Math.max(0, r.x) : Math.min(comp.getWidth() - r.width, r.x);
        }
        comp.scrollRectToVisible(r);
    }

    private void scrollPanel(JScrollPane comp, int move) {
        JScrollBar sb;
        JViewport vp = comp.getViewport();
        if (vp.getView() instanceof Scrollable) {
            this.scrollScrollable((JComponent)vp.getView(), move);
            return;
        }
        JScrollBar jScrollBar = this.scrollFound != null && this.conf.followBar ? this.scrollFound : (sb = this.action == 1 || this.action == 3 ? comp.getVerticalScrollBar() : comp.getHorizontalScrollBar());
        if (sb != null) {
            Rectangle r = vp.getViewRect();
            int i = 0;
            if (this.action == 3 || this.action == 5) {
                i = sb.getBlockIncrement(move > 0 ? -1 : 1);
                if (move < 0) {
                    i = -i;
                }
            } else {
                int incr = sb.getUnitIncrement(move > 0 ? -1 : 1);
                i = this.conf.sensitivity * move / 1200 * incr;
            }
            if (this.action == 2 || this.action == 5) {
                r.x -= i;
                r.x = r.x < 0 ? Math.max(0, r.x) : Math.min(comp.getWidth() - r.width, r.x);
            } else {
                r.y -= i;
                r.y = r.y < 0 ? Math.max(0, r.y) : Math.min(comp.getHeight() - r.height, r.y);
            }
            vp.scrollRectToVisible(r);
        }
    }

    private JComponent findFocused() {
        Window w = this.findTopWindow();
        if (w == null) {
            return null;
        }
        JComponent c2 = null;
        Component c1 = w.getFocusOwner();
        while (true) {
            if (c1 instanceof Scrollable || c1 instanceof JScrollPane) {
                c2 = (JComponent)c1;
                break;
            }
            if (c1 == null) break;
            c1 = c1.getParent();
        }
        return c2;
    }

    private JComponent findComponentAt(int x, int y) {
        Point p = new Point(x, y);
        try {
            Container cp = this.findTopWindow();
            this.trace("top window: " + cp);
            if (cp == null) {
                return null;
            }
            Rectangle r = new Rectangle();
            Insets i = null;
            cp.getBounds(r);
            i = cp.getInsets();
            p.translate(-r.x - i.left, -r.y - i.top);
            cp = cp instanceof JDialog ? ((JDialog)cp).getContentPane() : ((JFrame)cp).getContentPane();
            cp.getBounds(r);
            i = cp.getInsets();
            p.translate(-r.x - i.left, -r.y - i.top);
            Component c2 = cp;
            Component c1 = null;
            while (true) {
                if ((c1 = c2 instanceof JTabbedPane ? ((JTabbedPane)c2).getSelectedComponent() : c2.getComponentAt(p)) instanceof JScrollBar) {
                    this.scrollFound = (JScrollBar)c1;
                }
                if (c1 == c2) break;
                c2 = c1;
                if (c1 == null) {
                    return null;
                }
                c1.getBounds(r);
                i = ((Container)c2).getInsets();
                p.translate(-r.x - i.left, -r.y - i.top);
            }
            while (true) {
                if (c1 instanceof Scrollable || c1 instanceof JScrollPane || c1 instanceof JSlider || c1 instanceof JComboBox) {
                    c2 = (JComponent)c1;
                    break;
                }
                if (c1 == null) break;
                if (c1 instanceof Container) {
                    Component[] allComp = ((Container)c1).getComponents();
                    JScrollBar bar = null;
                    for (int n = 0; n < allComp.length; ++n) {
                        int orientation;
                        if (!(allComp[n] instanceof JScrollBar)) continue;
                        bar = (JScrollBar)allComp[n];
                        int n2 = orientation = this.action == 2 || this.action == 5 ? 0 : 1;
                        if (bar.getOrientation() != orientation) continue;
                        this.scrollFound = bar;
                        this.trace("JScrollbar (brother) - orientation OK");
                        return bar;
                    }
                    if (bar != null) {
                        this.scrollFound = bar;
                        this.trace("JScrollbar (brother) - wrong orientation");
                        return bar;
                    }
                }
                c1 = c1.getParent();
            }
            return (JComponent)c2;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Component getComponentAt(Container c2, Point p) {
        Component[] children = c2.getComponents();
        Rectangle compRect = new Rectangle();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (!child.isVisible()) continue;
            child.getBounds(compRect);
            if (!compRect.contains(p)) continue;
            return child;
        }
        return c2;
    }

    private Window findTopWindow() {
        Vector<RmaJDialog> windows = RmaJDialog.getOpenWindows();
        int size = windows.size();
        for (int i = 0; i < size; ++i) {
            Window window = windows.get(i);
            if (window.getFocusOwner() == null) continue;
            return window;
        }
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            for (Frame frame : frames) {
                if (frame == null || frame.getFocusOwner() == null) continue;
                return frame;
            }
        }
        return null;
    }

    private void scrollScrollBar(int move) {
        int i = 0;
        if (this.action == 3 || this.action == 5) {
            i = this.scrollFound.getBlockIncrement(move > 0 ? -1 : 1);
        } else {
            i = this.scrollFound.getUnitIncrement(move > 0 ? -1 : 1);
            i *= this.conf.sensitivity * move / 1200;
        }
        i = this.scrollFound.getValue() - i;
        i = Math.min(i, this.scrollFound.getMaximum());
        i = Math.max(i, this.scrollFound.getMinimum());
        this.scrollFound.setValue(i);
    }

    private void scrollSlider(JSlider comp, int move) {
        int dv;
        int n = dv = this.action == 2 || this.action == 1 ? comp.getMinorTickSpacing() : comp.getMajorTickSpacing();
        if (move < 0) {
            dv = -dv;
        }
        int v = comp.getValue() + dv;
        v = Math.min(v, comp.getMaximum());
        v = Math.max(v, comp.getMinimum());
        comp.setValue(v);
    }

    private void scrollCombo(JComboBox comp, int move) {
        int idx = comp.getSelectedIndex() + (move < 0 ? 1 : -1);
        idx = Math.min(idx, comp.getItemCount() - 1);
        idx = Math.max(idx, 0);
        comp.setSelectedIndex(idx);
    }

    protected void finalize() throws Throwable {
        this.stopCaptureWheelMessages();
    }

    private void trace(String msg) {
        if (this.conf.debug) {
            System.out.println(msg);
        }
    }

    private class WheelNotifier
    implements Runnable {
        int move;
        int x;
        int y;
        int mask;
        long time;

        private WheelNotifier() {
        }

        @Override
        public void run() {
            WheelTool.this.wheelMoved(this.move, this.x, this.y, this.mask);
            this.move = 0;
        }
    }
}

