/*
 * Decompiled with CFR 0.152.
 */
package rma.swing.wheel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import rma.swing.wheel.Config;

public class WheelToolDialog
extends JDialog {
    private JPanel panelCenter = new JPanel();
    private JPanel panelOptions = new JPanel();
    private JPanel panelButtons = new JPanel();
    private JPanel panelWhat = new JPanel();
    private JPanel panelHow = new JPanel();
    private JLabel labelSensitivity = new JLabel("Sensitivity:");
    private JSlider sliderSensitivity = new JSlider(0, 100);
    private JCheckBox checkReverse = new JCheckBox("Reverse scrolling direction");
    private JCheckBox checkFollowBar = new JCheckBox("Orientation according to scrollbar under cursor");
    private JRadioButton radioScrollCursor = new JRadioButton("Component under cursor");
    private JRadioButton radioScrollFocused = new JRadioButton("Focused component");
    private JRadioButton radioScrollEditor = new JRadioButton("Editor");
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancel = new JButton("Cancel");
    private JTable tableActions;
    private JButton buttonAdd = new JButton("Add");
    private JButton buttonDelete = new JButton("Delete");
    private ButtonGroup group = new ButtonGroup();
    private ActionsTableModel model = new ActionsTableModel();
    private Config conf;

    public WheelToolDialog(Frame parent, Config conf) {
        super(parent);
        try {
            this.conf = conf;
            this.sliderSensitivity.setValue(conf.sensitivity);
            this.checkReverse.setSelected(conf.reverse);
            this.checkFollowBar.setSelected(conf.followBar);
            switch (conf.mode) {
                case 1: {
                    this.radioScrollEditor.setSelected(true);
                    break;
                }
                case 3: {
                    this.radioScrollCursor.setSelected(true);
                    break;
                }
                case 2: {
                    this.radioScrollFocused.setSelected(true);
                }
            }
            this.group.add(this.radioScrollCursor);
            this.group.add(this.radioScrollEditor);
            this.group.add(this.radioScrollFocused);
            this.model.setActions(conf.actions);
            this.initUI();
            this.initListeners();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initUI() {
        this.sliderSensitivity.setMinorTickSpacing(10);
        this.sliderSensitivity.setPaintTicks(true);
        this.panelOptions.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.panelOptions.add((Component)this.labelSensitivity, gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        this.panelOptions.add((Component)this.sliderSensitivity, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        this.panelOptions.add((Component)this.checkReverse, gbc);
        ++gbc.gridy;
        this.panelOptions.add((Component)this.checkFollowBar, gbc);
        this.panelWhat.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "What to scroll"));
        this.panelWhat.setLayout(new FlowLayout());
        this.panelWhat.add((Component)this.radioScrollCursor, null);
        this.panelWhat.add((Component)this.radioScrollFocused, null);
        this.panelWhat.add((Component)this.radioScrollEditor, null);
        this.panelHow.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "How to scroll"));
        this.panelHow.setLayout(new BorderLayout());
        this.tableActions = new JTable(this.model);
        JComboBox<String> cb = new JComboBox<String>();
        for (int i = 0; i < Config.Action.names.length; ++i) {
            cb.addItem(Config.Action.names[i]);
        }
        this.tableActions.getColumn("Action").setCellEditor(new DefaultCellEditor(cb));
        JScrollPane sp = new JScrollPane(this.tableActions);
        JPanel p = new JPanel(new GridLayout(5, 1));
        p.add(this.buttonAdd);
        p.add(this.buttonDelete);
        this.panelHow.add((Component)p, "East");
        this.panelButtons.setLayout(new GridLayout(1, 2));
        this.panelButtons.add((Component)this.buttonOK, null);
        this.panelButtons.add((Component)this.buttonCancel, null);
        this.panelCenter.setLayout(new BorderLayout());
        this.panelCenter.add((Component)this.panelWhat, "North");
        this.panelCenter.add((Component)this.panelHow, "Center");
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        this.panelCenter.setBorder(border);
        this.panelOptions.setBorder(border);
        this.panelButtons.setBorder(border);
        JComponent cp = (JComponent)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.panelOptions, "North");
        cp.add((Component)this.panelCenter, "Center");
        cp.add((Component)this.panelButtons, "South");
        StringBuffer sb = new StringBuffer("Wheel");
        sb.append(" (");
        sb.append("0.85");
        sb.append(")");
        this.setTitle(sb.toString());
        this.pack();
        this.panelHow.add((Component)sp, "Center");
    }

    private void initListeners() {
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WheelToolDialog.this.conf.sensitivity = WheelToolDialog.this.sliderSensitivity.getValue();
                WheelToolDialog.this.conf.reverse = WheelToolDialog.this.checkReverse.isSelected();
                WheelToolDialog.this.conf.followBar = WheelToolDialog.this.checkFollowBar.isSelected();
                if (WheelToolDialog.this.radioScrollCursor.isSelected()) {
                    WheelToolDialog.this.conf.mode = 3;
                } else if (WheelToolDialog.this.radioScrollEditor.isSelected()) {
                    WheelToolDialog.this.conf.mode = 1;
                } else if (WheelToolDialog.this.radioScrollFocused.isSelected()) {
                    WheelToolDialog.this.conf.mode = 2;
                }
                WheelToolDialog.this.conf.actions = WheelToolDialog.this.model.getActions();
                WheelToolDialog.this.conf.save();
                WheelToolDialog.this.dispose();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WheelToolDialog.this.dispose();
            }
        });
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WheelToolDialog.this.model.createRow();
            }
        });
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WheelToolDialog.this.model.deleteRows(WheelToolDialog.this.tableActions.getSelectedRows());
            }
        });
    }

    public static void main(String[] args) {
        new WheelToolDialog(new Frame(), new Config()).setVisible(true);
    }

    class ActionsTableModel
    extends AbstractTableModel {
        private String c2 = "Ctrl";
        private String c3 = "Shift";
        private String c4 = "Action";
        private String[] columnNames = new String[]{this.c2, this.c3, this.c4};
        private Vector data = new Vector();

        ActionsTableModel() {
        }

        void setActions(HashMap a) {
            Iterator i = a.keySet().iterator();
            while (i.hasNext()) {
                RowData row = new RowData();
                Integer key = (Integer)i.next();
                Integer v = (Integer)WheelToolDialog.this.conf.actions.get(key);
                int k = key;
                row.ctrl = (k & 8) != 0;
                row.shift = (k & 4) != 0;
                row.action = v;
                this.data.add(row);
            }
        }

        HashMap getActions() {
            HashMap<Integer, Integer> hm = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.data.size(); ++i) {
                RowData row = (RowData)this.data.get(i);
                int key = 0;
                if (row.ctrl) {
                    key += 8;
                }
                if (row.shift) {
                    key += 4;
                }
                hm.put(new Integer(key), new Integer(row.action));
            }
            return hm;
        }

        void createRow() {
            this.data.add(new RowData());
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        }

        void deleteRows(int[] rows) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.data.remove(rows[i]);
            }
            this.fireTableRowsDeleted(0, this.data.size());
        }

        @Override
        public String getColumnName(int i) {
            return this.columnNames[i];
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class getColumnClass(int c2) {
            return this.getValueAt(0, c2).getClass();
        }

        @Override
        public boolean isCellEditable(int r, int c2) {
            return true;
        }

        @Override
        public Object getValueAt(int r, int c2) {
            RowData row = (RowData)this.data.get(r);
            switch (c2) {
                case 0: {
                    return row.ctrl;
                }
                case 1: {
                    return row.shift;
                }
                case 2: {
                    return Config.Action.names[row.action];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object v, int r, int c2) {
            RowData row = (RowData)this.data.get(r);
            switch (c2) {
                case 0: {
                    row.ctrl = (Boolean)v;
                    break;
                }
                case 1: {
                    row.shift = (Boolean)v;
                    break;
                }
                case 2: {
                    for (int i = 0; i < Config.Action.names.length; ++i) {
                        if (!Config.Action.names[i].equals(v)) continue;
                        row.action = i;
                    }
                    break;
                }
            }
        }

        class RowData {
            public boolean ctrl;
            public boolean shift;
            public int action;

            RowData() {
            }
        }
    }
}

