/*
 * Decompiled with CFR 0.152.
 */
package rma.text;

import java.awt.Color;
import rma.swing.RmaColor;
import rma.text.ParsingException;

public class ColorFormatter {
    public static final String[] colorNames = new String[]{"darkred", "red", "lightred", "darkpink", "pink", "lightpink", "darkorange", "orange", "lightorange", "darkyellow", "yellow", "lightyellow", "lightgreen", "green", "darkgreen", "lightcyan", "cyan", "darkcyan", "lightblue", "blue", "dark blue", "lightmagenta", "magenta", "darkmagenta", "lightpurple", "purple", "darkpurple", "lightgray", "gray", "darkgray", "black", "white"};
    public static final Color[] colors = new Color[]{RmaColor.darkred, RmaColor.red, RmaColor.lightred, RmaColor.darkpink, RmaColor.pink, RmaColor.lightpink, RmaColor.darkorange, RmaColor.orange, RmaColor.lightorange, RmaColor.darkyellow, RmaColor.yellow, RmaColor.lightyellow, RmaColor.lightgreen, RmaColor.green, RmaColor.darkgreen, RmaColor.lightcyan, RmaColor.cyan, RmaColor.darkcyan, RmaColor.lightblue, RmaColor.blue, RmaColor.darkblue, RmaColor.lightmagenta, RmaColor.magenta, RmaColor.darkmagenta, RmaColor.lightpurple, RmaColor.purple, RmaColor.darkpurple, RmaColor.lightGray, RmaColor.gray, RmaColor.darkGray, RmaColor.black, RmaColor.white};

    private ColorFormatter() {
    }

    public static String nameForColor(Color c2) {
        for (int i = 0; i < colors.length; ++i) {
            if (!c2.equals(colors[i])) continue;
            return colorNames[i];
        }
        return null;
    }

    public static Color colorForName(String name) {
        for (int i = 0; i < colors.length; ++i) {
            if (!name.equalsIgnoreCase(colorNames[i])) continue;
            return colors[i];
        }
        return null;
    }

    public static String format(Color color) {
        String s = ColorFormatter.nameForColor(color);
        if (s != null) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('#');
        s = Integer.toHexString(color.getRGB() & 0x1FFFFFF);
        sb.append(s.substring(1));
        return sb.toString();
    }

    public static Color parse(String name) throws ParsingException {
        if (name.charAt(0) == '#') {
            try {
                Integer rgb = Integer.valueOf(name.substring(1), 16);
                return new Color(rgb);
            }
            catch (NumberFormatException e) {
                throw new ParsingException("Invalid RGB color syntax: " + name);
            }
        }
        Color r = ColorFormatter.colorForName(name);
        if (r == null) {
            throw new ParsingException("Unknown color name: " + name);
        }
        return r;
    }
}

