/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rma.util.IllegalTimeIntervalLengthException;
import rma.util.IllegalTimeIntervalTypeException;
import rma.util.RMAIO;
import rma.util.TimeIntervals;

public abstract class AbstractTimeInterval
implements TimeIntervals,
Serializable {
    String _timeInterval = null;
    int _length = 1;
    boolean localTime = true;
    TimeZone tz;

    public AbstractTimeInterval() {
    }

    public AbstractTimeInterval(TimeZone tz, String timeInterval, int length) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        this(timeInterval, length);
        this.tz = tz;
    }

    public AbstractTimeInterval(String timeInterval, int length) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        this.setIntervalType(timeInterval);
        this.setLength(length);
    }

    public AbstractTimeInterval(String lengthAndInterval) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        Pattern p = Pattern.compile("\\d*");
        Matcher m = p.matcher(lengthAndInterval);
        m.find();
        int l = RMAIO.parseInt(m.group(), 1);
        this.setLength(l);
        p = Pattern.compile("[a-zA-Z][a-zA-Z]");
        m = p.matcher(lengthAndInterval);
        m.find();
        this.setIntervalType(m.group());
    }

    public String getIntervalType() {
        return this._timeInterval;
    }

    public String getIntervalTypeDesc() {
        int idx = Arrays.asList(TimeIntervals.TIME_INTERVALS).indexOf(this._timeInterval);
        Object desc = TimeIntervals.TIME_INTERVALS_DESC[idx];
        if (this.getLength() > 1) {
            desc = (String)desc + "s";
        }
        return desc;
    }

    public void setIntervalType(String str) throws IllegalTimeIntervalTypeException {
        if (!AbstractTimeInterval.isValidIntervalType(str)) {
            throw new IllegalTimeIntervalTypeException(str);
        }
        this._timeInterval = str;
    }

    public static boolean isValidIntervalType(String s) {
        for (int ii = 0; ii < TIME_INTERVALS.length; ++ii) {
            if (!s.equalsIgnoreCase(TIME_INTERVALS[ii])) continue;
            return true;
        }
        return false;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int num) throws IllegalTimeIntervalLengthException {
        if (num < 0) {
            throw new IllegalTimeIntervalLengthException();
        }
        this._length = num;
    }

    public long getInterval() {
        return this.getInterval(this._length);
    }

    public long getInterval(int length) {
        if (this._timeInterval == null) {
            return Long.MIN_VALUE;
        }
        long interval = Long.MIN_VALUE;
        if (this._timeInterval.equalsIgnoreCase("mi")) {
            interval = (long)length * 60L * 1000L;
        } else if (this._timeInterval.equalsIgnoreCase("hr")) {
            interval = (long)length * 60L * 60L * 1000L;
        } else if (this._timeInterval.equalsIgnoreCase("dy")) {
            interval = (long)length * 24L * 60L * 60L * 1000L;
        } else if (this._timeInterval.equalsIgnoreCase("wk")) {
            interval = (long)length * 7L * 24L * 60L * 60L * 1000L;
        } else if (this._timeInterval.equalsIgnoreCase("mo")) {
            GregorianCalendar gc = new GregorianCalendar();
            if (this.tz != null) {
                gc.setTimeZone(this.tz);
            }
            int month = gc.get(2);
            int year = gc.get(1);
            gc.clear();
            gc.set(year, month, 1);
            long startOfThisMonth = gc.getTime().getTime();
            gc.add(2, length);
            long startOfNextMonth = gc.getTime().getTime();
            interval = startOfNextMonth - startOfThisMonth;
        } else if (this._timeInterval.equalsIgnoreCase("yr")) {
            GregorianCalendar gc = new GregorianCalendar();
            if (this.tz != null) {
                gc.setTimeZone(this.tz);
            }
            int year = gc.get(1);
            gc.clear();
            gc.set(year, 0, 1);
            long startOfThisYear = gc.getTime().getTime();
            gc.add(1, length);
            long startOfNextYear = gc.getTime().getTime();
            interval = startOfNextYear - startOfThisYear;
        }
        return interval;
    }

    public abstract long getNextInterval(long var1);

    public abstract long getPreviousInterval(long var1);

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._length);
        buf.append(this._timeInterval);
        return buf.toString();
    }
}

