/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.HashMap;
import java.util.StringTokenizer;

public class ArgsParser {
    HashMap _argsTable = new HashMap();

    public ArgsParser(String[] args) {
        if (args == null || args.length < 1) {
            return;
        }
        String arg = null;
        String val = null;
        boolean haveArg = false;
        if (args.length == 1) {
            StringTokenizer tokenizer = new StringTokenizer(args[0], "-");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                int idx = token.indexOf(" ");
                if (idx == -1) {
                    this._argsTable.put(token, Boolean.TRUE);
                    continue;
                }
                arg = token.substring(0, idx);
                val = token.substring(idx + 1);
                this._argsTable.put(arg, val);
            }
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-") && !haveArg) {
                    arg = args[i].substring(1);
                    haveArg = true;
                    continue;
                }
                if (!haveArg) continue;
                haveArg = false;
                val = args[i];
                System.out.println("got val='" + val + "' for arg '" + arg + "'");
                this._argsTable.put(arg, val);
            }
        }
    }

    public String get(String argName) {
        Object obj = this._argsTable.get(argName);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public static void main(String[] args) {
        String[] s = new String[]{"-a foo   -b foo -c -d help"};
        ArgsParser parser = new ArgsParser(s);
        System.out.println("a=" + parser.get("a"));
        System.out.println("b=" + parser.get("b"));
        System.out.println("c=" + parser.get("c"));
        System.out.println("d=" + parser.get("d"));
    }
}

