/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.lang.Modifiable;
import rma.swing.RmaColor;
import rma.util.ColorContour;
import rma.util.RMAUtil;
import rma.util.SingleColorContour;

public class AspectShadingColorContour
extends ColorContour
implements Cloneable,
Serializable,
AsciiSerializable,
SingleColorContour {
    protected Color _color = Color.white;
    protected double[] _rgb = new double[]{this._color.getRed(), this._color.getGreen(), this._color.getBlue()};

    @Override
    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
            AspectShadingColorContour cc = (AspectShadingColorContour)clone;
            cc._rgb = new double[3];
            cc._rgb[0] = this._rgb[0];
            cc._rgb[1] = this._rgb[1];
            cc._rgb[2] = this._rgb[2];
            cc._color = new Color(this._color.getRed(), this._color.getGreen(), this._color.getBlue());
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return clone;
    }

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.compareTo("AspectShadingColor") == 0) {
            Color color;
            block3: {
                color = null;
                try {
                    int rgb = Integer.parseInt(param);
                    color = new Color(rgb);
                }
                catch (Exception e) {
                    color = RmaColor.parseColorString(param);
                    if (color != null) break block3;
                    color = Color.gray;
                }
            }
            this.setColor(color);
        }
    }

    @Override
    public void write(BufferedWriter output) throws IOException {
        super.write(output);
        output.write("AspectShadingColor=" + this.getColor().getRGB());
        output.newLine();
    }

    @Override
    public Map getAttributes(Map map) {
        super.getAttributes(map);
        map.put("AspectShadingColor=", RmaColor.color2String(this.getColor(), true));
        return map;
    }

    @Override
    protected void setAttributes(Map attributes) {
        super.setAttributes(attributes);
        Object obj = attributes.get("AspectShadingColor");
        Color clr = RmaColor.parseColorString((String)obj);
        if (clr != null) {
            this.setColor(clr);
        }
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void setColor(Color c2) {
        this._color = c2;
        this._rgb[0] = this._color.getRed();
        this._rgb[1] = this._color.getGreen();
        this._rgb[2] = this._color.getBlue();
    }

    @Override
    protected double[] getRGB0(double val, double min, double max) {
        double[] rgb = new double[]{this._color.getRed(), this._color.getGreen(), this._color.getBlue()};
        return rgb;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double min, double max) {
        System.arraycopy(this._rgb, 0, rgb, 0, rgb.length);
    }

    @Override
    public void addExtras(JPanel panel, Observer observer) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        JLabel jLabelColor = new JLabel();
        jLabelColor.setText("Color");
        jLabelColor.setHorizontalAlignment(4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)panel.getLayout()).setConstraints(jLabelColor, gbc);
        panel.add(jLabelColor);
        JButton jButtonColor = new JButton();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        ((GridBagLayout)panel.getLayout()).setConstraints(jButtonColor, gbc);
        panel.add(jButtonColor);
        if (this._color != null) {
            jButtonColor.setIcon(this.getColorIcon(this._color));
        }
        ColorContourObserverableListener alobs = new ColorContourObserverableListener(jButtonColor, panel);
        if (observer instanceof Modifiable) {
            alobs.setModifiableParent((Modifiable)((Object)observer));
        }
        jButtonColor.addActionListener(alobs);
        alobs.addObserver(observer);
    }

    protected ImageIcon getColorIcon(Color c2) {
        int w = 12;
        int h = 12;
        int rgb = c2.getRGB();
        int[] pix = new int[h * w];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        ImageIcon imgIcon = new ImageIcon(img);
        return imgIcon;
    }

    public class ColorContourObserverableListener
    extends Observable
    implements ActionListener {
        JButton _jButtonColor;
        JPanel _panel;
        Modifiable _modifiableParent;

        public ColorContourObserverableListener(JButton jButtonColor, JPanel panel) {
            this._jButtonColor = jButtonColor;
            this._panel = panel;
        }

        public void setModifiableParent(Modifiable modifiableParent) {
            this._modifiableParent = modifiableParent;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Color oldColor = AspectShadingColorContour.this.getColor();
            Color newColor = RMAUtil.colorChooser(this._panel, oldColor);
            this._jButtonColor.setIcon(AspectShadingColorContour.this.getColorIcon(newColor));
            AspectShadingColorContour.this.setColor(newColor);
            if (this._modifiableParent != null) {
                this._modifiableParent.setModified(true);
            }
            this.setChanged();
            this.notifyObservers(AspectShadingColorContour.this);
        }
    }
}

