/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import rma.util.ColorContour;
import rma.xml.adapters.XmlColorAdapter;
import rma.xml.adapters.XmlDoubleColorNavMapAdapter;

@XmlRootElement(name="BandedColorContour")
@XmlAccessorType(value=XmlAccessType.NONE)
public class BandedColorContour
extends ColorContour {
    private static final long serialVersionUID = 8386257662262005414L;
    @XmlElement(name="bandedColors")
    @XmlJavaTypeAdapter(value=XmlDoubleColorNavMapAdapter.class)
    private NavigableMap<Double, Color> _colorMap;
    @XmlElement(name="defaultColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _defaultColor = Color.WHITE;

    public BandedColorContour() {
        this._colorMap = new TreeMap<Double, Color>();
    }

    public static BandedColorContour buildSwtBandedColor() {
        BandedColorContour contour = new BandedColorContour();
        contour.setColorAtIndex(150.0, new Color(0xFF0000));
        contour.setColorAtIndex(125.0, new Color(0xAE0000));
        contour.setColorAtIndex(100.0, new Color(0xEE8C8C));
        contour.setColorAtIndex(75.0, new Color(0xFFFF00));
        contour.setColorAtIndex(50.0, new Color(11894016));
        contour.setColorAtIndex(25.0, new Color(0x559696));
        contour.setColorAtIndex(10.0, new Color(65280));
        contour.setColorAtIndex(0.0, new Color(32768));
        contour.setMinValue(0.0);
        contour.setMaxValue(100.0);
        return contour;
    }

    public NavigableSet<Double> getIndexes() {
        return this._colorMap.descendingKeySet();
    }

    public Color setColorAtIndex(double index, Color color) {
        return this._colorMap.put(index, color);
    }

    public Color getColorAtIndex(double index) {
        Color returnColor = null;
        Map.Entry<Double, Color> floor = this._colorMap.floorEntry(index);
        if (floor != null) {
            returnColor = floor.getValue();
        }
        return returnColor;
    }

    public Map.Entry<Double, Color> removeColorAtIndex(double colorIndex) {
        Map.Entry<Double, Color> returnEntry = this._colorMap.floorEntry(colorIndex);
        if (returnEntry != null) {
            this._colorMap.remove(returnEntry.getKey());
        }
        return returnEntry;
    }

    public void clearColors() {
        this._colorMap.clear();
    }

    public void setDefaultColor(Color color) {
        this._defaultColor = color;
    }

    @Override
    protected double[] getRGB0(double val, double minValue, double maxValue) {
        double[] rgb = new double[3];
        this.getRGB0(rgb, val, minValue, maxValue);
        return rgb;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double minValue, double maxValue) {
        Color color = this.getColorAtIndex(val);
        if (color == null) {
            color = this._defaultColor;
        }
        rgb[0] = color.getRed();
        rgb[1] = color.getGreen();
        rgb[2] = color.getBlue();
    }
}

