/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Color;

public class ByteConversion {
    public static void color2bytes(Color color, byte[] dataOut, int offset) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        ByteConversion.int2bytes(r, dataOut, offset);
        ByteConversion.int2bytes(g, dataOut, offset + 4);
        ByteConversion.int2bytes(b, dataOut, offset + 8);
    }

    public static Color bytes2color(byte[] dataIn, int offset) {
        int r = ByteConversion.bytes2int(dataIn, offset);
        int g = ByteConversion.bytes2int(dataIn, offset + 4);
        int b = ByteConversion.bytes2int(dataIn, offset + 8);
        return new Color(r, g, b);
    }

    public static void short2bytes(short shortIn, byte[] bytesOut, int offset) {
        bytesOut[offset] = (byte)(shortIn >>> 8 & 0xFF);
        bytesOut[++offset] = (byte)(shortIn >>> 0 & 0xFF);
    }

    public static short bytes2short(byte[] dataIn, int offset) {
        return (short)((ByteConversion.unsignedByte(dataIn[offset]) << 8) + (ByteConversion.unsignedByte(dataIn[++offset]) << 0));
    }

    public static void int2bytes(int intIn, byte[] bytesOut, int offset) {
        bytesOut[offset] = (byte)(intIn >>> 24 & 0xFF);
        bytesOut[++offset] = (byte)(intIn >>> 16 & 0xFF);
        bytesOut[++offset] = (byte)(intIn >>> 8 & 0xFF);
        bytesOut[++offset] = (byte)(intIn >>> 0 & 0xFF);
    }

    public static int bytes2int(byte[] dataIn, int offset) {
        int x = 0;
        x = (int)((long)x + (ByteConversion.unsignedByte(dataIn[offset]) << 24));
        x = (int)((long)x + (ByteConversion.unsignedByte(dataIn[++offset]) << 16));
        x = (int)((long)x + (ByteConversion.unsignedByte(dataIn[++offset]) << 8));
        x = (int)((long)x + (ByteConversion.unsignedByte(dataIn[++offset]) << 0));
        return x;
    }

    public static void long2bytes(long longIn, byte[] bytesOut, int offset) {
        bytesOut[offset] = (byte)(longIn >>> 56 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 48 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 40 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 32 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 24 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 16 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 8 & 0xFFL);
        bytesOut[++offset] = (byte)(longIn >>> 0 & 0xFFL);
    }

    public static long bytes2long(byte[] dataIn, int offset) {
        long x = 0L;
        x += ByteConversion.unsignedByte(dataIn[offset]) << 56;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 48;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 40;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 32;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 24;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 16;
        x += ByteConversion.unsignedByte(dataIn[++offset]) << 8;
        return x += ByteConversion.unsignedByte(dataIn[++offset]) << 0;
    }

    public static long unsignedByte(byte x) {
        return x < 0 ? (long)(x + 256) : (long)x;
    }
}

