/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.PrintStream;

public class CJFormat {
    private int width = 0;
    private int precision = -1;
    private String pre = "";
    private String post = "";
    private boolean leading_zeroes = false;
    private boolean show_plus = false;
    private boolean alternate = false;
    private boolean show_space = false;
    private boolean left_align = false;
    private char fmt = (char)32;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CJFormat(String s) {
        boolean state = false;
        int length = s.length();
        int parse_state = 0;
        int i = 0;
        while (parse_state == 0) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == '%') {
                if (i >= length - 1) throw new IllegalArgumentException();
                if (s.charAt(i + 1) == '%') {
                    this.pre = this.pre + "%";
                    ++i;
                } else {
                    parse_state = 1;
                }
            } else {
                this.pre = this.pre + s.charAt(i);
            }
            ++i;
        }
        while (parse_state == 1) {
            if (i >= length) {
                parse_state = 5;
            } else if (s.charAt(i) == ' ') {
                this.show_space = true;
            } else if (s.charAt(i) == '-') {
                this.left_align = true;
            } else if (s.charAt(i) == '+') {
                this.show_plus = true;
            } else if (s.charAt(i) == '0') {
                this.leading_zeroes = true;
            } else if (s.charAt(i) == '#') {
                this.alternate = true;
            } else {
                parse_state = 2;
                --i;
            }
            ++i;
        }
        while (parse_state == 2) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.width = this.width * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            if (s.charAt(i) == '.') {
                parse_state = 3;
                this.precision = 0;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        while (parse_state == 3) {
            if (i >= length) {
                parse_state = 5;
                continue;
            }
            if ('0' <= s.charAt(i) && s.charAt(i) <= '9') {
                this.precision = this.precision * 10 + s.charAt(i) - 48;
                ++i;
                continue;
            }
            parse_state = 4;
        }
        if (parse_state == 4) {
            if (i >= length) {
                parse_state = 5;
            } else {
                this.fmt = s.charAt(i);
            }
            ++i;
        }
        if (i >= length) return;
        this.post = s.substring(i, length);
    }

    public static void print(PrintStream s, String fmt, double x) {
        s.print(new CJFormat(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, long x) {
        s.print(new CJFormat(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, char x) {
        s.print(new CJFormat(fmt).form(x));
    }

    public static void print(PrintStream s, String fmt, String x) {
        s.print(new CJFormat(fmt).form(x));
    }

    public static int atoi(String s) {
        return (int)CJFormat.atol(s);
    }

    public static long atol(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '0') {
            if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                return CJFormat.parseLong(s.substring(i + 2), 16);
            }
            return CJFormat.parseLong(s, 8);
        }
        return CJFormat.parseLong(s, 10);
    }

    private static long parseLong(String s, int base) {
        int i;
        int sign = 1;
        long r = 0L;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch < 48 + base) {
                r = r * (long)base + (long)ch - 48L;
            } else if ('A' <= ch && ch < 65 + base - 10) {
                r = r * (long)base + (long)ch - 65L + 10L;
            } else if ('a' <= ch && ch < 97 + base - 10) {
                r = r * (long)base + (long)ch - 97L + 10L;
            } else {
                return r * (long)sign;
            }
            ++i;
        }
        return r * (long)sign;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(String s) {
        int i;
        int sign = 1;
        double r = 0.0;
        double f = 0.0;
        double p = 1.0;
        boolean state = false;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        if (i < s.length() && s.charAt(i) == '-') {
            sign = -1;
            ++i;
        } else if (i < s.length() && s.charAt(i) == '+') {
            ++i;
        }
        while (i < s.length()) {
            char ch = s.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (!state) {
                    r = r * 10.0 + (double)ch - 48.0;
                } else if (state) {
                    r += (p /= 10.0) * (double)(ch - 48);
                }
            } else if (ch == '.') {
                if (state) return (double)sign * r;
                state = true;
            } else {
                if (ch != 'e' && ch != 'E') return (double)sign * r;
                long e = (int)CJFormat.parseLong(s.substring(i + 1), 10);
                return (double)sign * r * Math.pow(10.0, e);
            }
            ++i;
        }
        return (double)sign * r;
    }

    public String form(double x) {
        String r;
        if (this.precision < 0) {
            this.precision = 6;
        }
        int s = 1;
        if (x < 0.0) {
            x = -x;
            s = -1;
        }
        if (this.fmt == 'f') {
            r = this.fixed_format(x);
        } else if (this.fmt == 'e' || this.fmt == 'E' || this.fmt == 'g' || this.fmt == 'G') {
            r = this.exp_format(x);
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, r));
    }

    public String form(long x) {
        Object r;
        int s = 0;
        if (this.fmt == 'd' || this.fmt == 'i') {
            s = 1;
            if (x < 0L) {
                x = -x;
                s = -1;
            }
            r = "" + x;
        } else if (this.fmt == 'o') {
            r = CJFormat.convert(x, 3, 7, "01234567");
        } else if (this.fmt == 'x') {
            r = CJFormat.convert(x, 4, 15, "0123456789abcdef");
        } else if (this.fmt == 'X') {
            r = CJFormat.convert(x, 4, 15, "0123456789ABCDEF");
        } else {
            throw new IllegalArgumentException();
        }
        return this.pad(this.sign(s, (String)r));
    }

    public String form(char c2) {
        if (this.fmt != 'c') {
            throw new IllegalArgumentException();
        }
        String r = "" + c2;
        return this.pad(r);
    }

    public String form(String s) {
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    public String form(boolean b) {
        String bstr = b ? "T" : "F";
        String s = bstr;
        if (this.fmt != 's') {
            throw new IllegalArgumentException();
        }
        if (this.precision >= 0) {
            s = s.substring(0, this.precision);
        }
        return this.pad(s);
    }

    public static void main(String[] a) {
        double x = 1.23456789012;
        double y = 123.0;
        double z = 1.2345E30;
        double w = 1.02;
        double u = 1.234E-5;
        int d = 51966;
        CJFormat.print(System.out, "x = |%f|\n", x);
        CJFormat.print(System.out, "u = |%20f|\n", u);
        CJFormat.print(System.out, "x = |% .5f|\n", x);
        CJFormat.print(System.out, "w = |%20.5f|\n", w);
        CJFormat.print(System.out, "x = |%020.5f|\n", x);
        CJFormat.print(System.out, "x = |%+20.5f|\n", x);
        CJFormat.print(System.out, "x = |%+020.5f|\n", x);
        CJFormat.print(System.out, "x = |% 020.5f|\n", x);
        CJFormat.print(System.out, "y = |%#+20.5f|\n", y);
        CJFormat.print(System.out, "y = |%-+20.5f|\n", y);
        CJFormat.print(System.out, "z = |%20.5f|\n", z);
        CJFormat.print(System.out, "x = |%e|\n", x);
        CJFormat.print(System.out, "u = |%20e|\n", u);
        CJFormat.print(System.out, "x = |% .5e|\n", x);
        CJFormat.print(System.out, "w = |%20.5e|\n", w);
        CJFormat.print(System.out, "x = |%020.5e|\n", x);
        CJFormat.print(System.out, "x = |%+20.5e|\n", x);
        CJFormat.print(System.out, "x = |%+020.5e|\n", x);
        CJFormat.print(System.out, "x = |% 020.5e|\n", x);
        CJFormat.print(System.out, "y = |%#+20.5e|\n", y);
        CJFormat.print(System.out, "y = |%-+20.5e|\n", y);
        CJFormat.print(System.out, "x = |%g|\n", x);
        CJFormat.print(System.out, "z = |%g|\n", z);
        CJFormat.print(System.out, "w = |%g|\n", w);
        CJFormat.print(System.out, "u = |%g|\n", u);
        CJFormat.print(System.out, "y = |%.2g|\n", y);
        CJFormat.print(System.out, "y = |%#.2g|\n", y);
        CJFormat.print(System.out, "d = |%d|\n", d);
        CJFormat.print(System.out, "d = |%20d|\n", d);
        CJFormat.print(System.out, "d = |%020d|\n", d);
        CJFormat.print(System.out, "d = |%+20d|\n", d);
        CJFormat.print(System.out, "d = |% 020d|\n", d);
        CJFormat.print(System.out, "d = |%-20d|\n", d);
        CJFormat.print(System.out, "d = |%20.8d|\n", d);
        CJFormat.print(System.out, "d = |%x|\n", d);
        CJFormat.print(System.out, "d = |%20X|\n", d);
        CJFormat.print(System.out, "d = |%#20x|\n", d);
        CJFormat.print(System.out, "d = |%020X|\n", d);
        CJFormat.print(System.out, "d = |%20.8x|\n", d);
        CJFormat.print(System.out, "d = |%o|\n", d);
        CJFormat.print(System.out, "d = |%020o|\n", d);
        CJFormat.print(System.out, "d = |%#20o|\n", d);
        CJFormat.print(System.out, "d = |%#020o|\n", d);
        CJFormat.print(System.out, "d = |%20.12o|\n", d);
        CJFormat.print(System.out, "s = |%-20s|\n", "Hello");
        CJFormat.print(System.out, "s = |%-20c|\n", '!');
    }

    private static String repeat(char c2, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer s = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            s.append(c2);
        }
        return s.toString();
    }

    private static String convert(long x, int n, int m, String d) {
        if (x == 0L) {
            return "0";
        }
        Object r = "";
        while (x != 0L) {
            r = d.charAt((int)(x & (long)m)) + (String)r;
            x >>>= n;
        }
        return r;
    }

    private String pad(String r) {
        String p = CJFormat.repeat(' ', this.width - r.length());
        if (this.left_align) {
            return this.pre + r + p + this.post;
        }
        return this.pre + p + r + this.post;
    }

    private String sign(int s, String r) {
        String p = "";
        if (s < 0) {
            p = "-";
        } else if (s > 0) {
            if (this.show_plus) {
                p = "+";
            } else if (this.show_space) {
                p = " ";
            }
        } else if (this.fmt == 'o' && this.alternate && r.length() > 0 && r.charAt(0) != '0') {
            p = "0";
        } else if (this.fmt == 'x' && this.alternate) {
            p = "0x";
        } else if (this.fmt == 'X' && this.alternate) {
            p = "0X";
        }
        int w = 0;
        if (this.leading_zeroes) {
            w = this.width;
        } else if ((this.fmt == 'd' || this.fmt == 'i' || this.fmt == 'x' || this.fmt == 'X' || this.fmt == 'o') && this.precision > 0) {
            w = this.precision;
        }
        return p + CJFormat.repeat('0', w - p.length() - r.length()) + r;
    }

    private String fixed_format(double d) {
        Object f = "";
        if (d > 9.223372036854776E18) {
            return this.exp_format(d);
        }
        long l = (long)(this.precision == 0 ? d + 0.5 : d);
        long ll = 0L;
        if (this.precision > 0) {
            double fac = 0.5 / Math.pow(10.0, this.precision);
            double dd = d + fac;
            ll = (long)dd;
        }
        f = (String)f + l;
        if (this.precision == 0) {
            return f;
        }
        double fr = d - (double)l;
        if (fr >= 1.0 || fr < 0.0) {
            return this.exp_format(d);
        }
        if (this.precision > 0) {
            f = "";
            f = (String)f + ll;
        }
        return (String)f + this.frac_part(fr);
    }

    private String frac_part(double fr) {
        Object z = "";
        if (this.precision > 0) {
            double factor = 1.0;
            Object leading_zeroes = "";
            for (int i = 1; i <= this.precision && factor <= 9.223372036854776E18; factor *= 10.0, ++i) {
                leading_zeroes = (String)leading_zeroes + "0";
            }
            long l = (long)(factor * fr + 0.5);
            z = (String)leading_zeroes + l;
            z = ((String)z).substring(((String)z).length() - this.precision, ((String)z).length());
        }
        if (this.precision > 0 || this.alternate) {
            z = "." + (String)z;
        }
        if (!(this.fmt != 'G' && this.fmt != 'g' || this.alternate)) {
            int t;
            for (t = ((String)z).length() - 1; t >= 0 && ((String)z).charAt(t) == '0'; --t) {
            }
            if (t >= 0 && ((String)z).charAt(t) == '.') {
                --t;
            }
            z = ((String)z).substring(0, t + 1);
        }
        return z;
    }

    private String exp_format(double d) {
        double dd;
        Object f = "";
        int e = 0;
        double factor = 1.0;
        for (dd = d; dd > 10.0; dd /= 10.0) {
            ++e;
            factor /= 10.0;
        }
        while (dd < 1.0) {
            --e;
            factor *= 10.0;
            dd *= 10.0;
        }
        if ((this.fmt == 'g' || this.fmt == 'G') && e >= -4 && e < this.precision) {
            return this.fixed_format(d);
        }
        f = (String)f + this.fixed_format(d *= factor);
        f = this.fmt == 'e' || this.fmt == 'g' ? (String)f + "e" : (String)f + "E";
        Object p = "000";
        if (e >= 0) {
            p = (String)p + e;
        } else {
            f = (String)f + "-";
            p = (String)p + -e;
        }
        if (e > -99 && e < 99) {
            return (String)f + ((String)p).substring(((String)p).length() - 2, ((String)p).length());
        }
        return (String)f + ((String)p).substring(((String)p).length() - 3, ((String)p).length());
    }
}

