/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import rma.util.Clipping;
import rma.util.ColorContour;
import rma.xml.adapters.XmlColorAdapter;

@XmlRootElement
public class CategoricalColorContour
extends ColorContour {
    @XmlElement(name="Categories")
    private final TreeSet<Category<?>> _categories = new TreeSet();
    @XmlElement(name="DefaultColor")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    private Color _defaultColor = new Color(0, true);

    public CategoricalColorContour() {
        Color[] colors = new Color[]{new Color(244, 217, 102), new Color(38, 192, 163), new Color(77, 237, 69), new Color(66, 91, 214), new Color(11, 170, 227), new Color(255, 192, 0), new Color(29, 131, 151), new Color(197, 92, 230), new Color(234, 152, 4), new Color(52, 248, 239), new Color(184, 72, 115), new Color(137, 59, 195)};
        int i = 0;
        for (Color color : colors) {
            this._categories.add(new Category<Integer>(i, color));
            ++i;
        }
    }

    @Override
    public Clipping getMaxClipping() {
        Clipping output = new Clipping();
        output.setValue(this.getMaxValue());
        output.setEnabled(false);
        return output;
    }

    @Override
    public Clipping getMinClipping() {
        Clipping output = new Clipping();
        output.setValue(this.getMinValue());
        output.setEnabled(false);
        return output;
    }

    @Override
    public double getMaxValue() {
        return this._categories.size();
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    public List<Category<?>> getCategories() {
        return new ArrayList(this._categories);
    }

    public void addCategories(Category<?> ... categories) {
        this.addCategories(Arrays.asList(categories));
    }

    public void setCategories(Category<?> ... categories) {
        this.setCategories(Arrays.asList(categories));
    }

    public void setCategories(List<Category<?>> categories) {
        this.clearCategories();
        this.addCategories(categories);
    }

    public void addCategories(List<Category<?>> categories) {
        this._categories.addAll(categories);
    }

    public <T> void addCategory(T category, Color color) {
        Category<T> realCategory = new Category<T>(category, color);
        this.addCategory(realCategory);
    }

    public void addCategory(Category<?> category) {
        this._categories.add(category);
    }

    public <T> Category<T> removeCategory(T category) {
        Category<?> removedValue = null;
        for (Category<?> _category : this._categories) {
            Object value = _category.getValue();
            if (!Objects.equals(value, category)) continue;
            removedValue = _category;
            break;
        }
        if (removedValue != null) {
            this.removeCategory(removedValue);
        }
        return removedValue;
    }

    public void removeCategory(Category<?> category) {
        this._categories.remove(category);
    }

    public Color getDefaultColor() {
        return this._defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        Objects.requireNonNull(defaultColor, "Default color for contour is required to be non-null");
        this._defaultColor = defaultColor;
    }

    public Color getColorForCategory(Object category) {
        Color output = this.getDefaultColor();
        for (Category<?> cat : this.getCategories()) {
            if (!Objects.equals(cat.getValue(), category)) continue;
            output = cat.getColor();
            break;
        }
        return output;
    }

    private Color getColorAtIndex(Double val) {
        int intValue = val.intValue();
        int realValue = intValue % this.getCategories().size();
        int index = 0;
        Color output = this.getDefaultColor();
        for (Category<?> _category : this.getCategories()) {
            if (index == realValue) {
                output = _category.getColor();
            }
            ++index;
        }
        return output;
    }

    @Override
    protected double[] getRGB0(double val, double minValue, double maxValue) {
        double[] rgb = new double[3];
        this.getRGB0(rgb, val, minValue, maxValue);
        return rgb;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double minValue, double maxValue) {
        Color color = this.getColorAtIndex(val);
        rgb[0] = color.getRed();
        rgb[1] = color.getGreen();
        rgb[2] = color.getBlue();
    }

    public void clearCategories() {
        this._categories.clear();
    }

    @XmlRootElement
    public static class Category<T>
    implements Comparable<Category<?>> {
        @XmlElement
        private final T _value;
        @XmlElement
        @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
        private final Color _color;

        public Category() {
            this._value = null;
            this._color = null;
        }

        public Category(T _value, Color _color) {
            this._value = _value;
            this._color = _color;
        }

        public T getValue() {
            return this._value;
        }

        public Color getColor() {
            return this._color;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this._value);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Category other = (Category)obj;
            return Objects.equals(this._value, other._value);
        }

        @Override
        public int compareTo(Category<?> o) {
            int output = 0;
            if (o != null) {
                Object value = o.getValue();
                T myValue = this.getValue();
                if (myValue instanceof Comparable && value != null) {
                    output = ((Comparable)myValue).compareTo(value);
                } else if (myValue != null && value == null) {
                    output = -1;
                } else if (myValue == null && value != null) {
                    output = 1;
                }
            } else {
                output = -1;
            }
            return output;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Value: ").append(this.getValue());
            sb.append("Color: ").append(this.getColor());
            return sb.toString();
        }
    }
}

