/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class CodeReport {
    public static final String INITIAL_VERSION = "Initial Version";
    public static final String[] JARS = new String[]{"fia", "ras", "rss", "sid", "heclib", "data", "msgsystem", "hec", "cavi", "hfp", "mfp", "dbi", "decode", "goesit", "wcds", "admin"};
    File rfFile;
    Hashtable comments = new Hashtable();
    Hashtable commentsByJar = new Hashtable();
    BufferedReader reader;
    String lastFileName = "";
    GregorianCalendar date = null;
    GregorianCalendar lineDate = new GregorianCalendar();

    public CodeReport(String filename) {
        if (filename == null || filename.length() == 0) {
            System.out.println("Empty File Name");
            System.exit(2);
        }
        this.rfFile = new File(filename);
        try {
            this.reader = new BufferedReader(new FileReader(this.rfFile));
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found " + this.rfFile.getAbsolutePath() + " " + e);
            System.exit(3);
        }
    }

    public CodeReport(String filename, String dt) {
        this(filename);
        this.date = this.parseDate(null, dt);
    }

    private GregorianCalendar parseDate(GregorianCalendar cal, String dt) {
        try {
            StringTokenizer token;
            int idx = dt.indexOf("/");
            if (idx < -1) {
                return null;
            }
            idx = dt.indexOf(" ");
            if (idx > -1) {
                dt = dt.substring(0, idx);
            }
            if (!(token = new StringTokenizer(dt, "/")).hasMoreTokens()) {
                return null;
            }
            int m = Integer.parseInt(token.nextToken());
            int d = Integer.parseInt(token.nextToken());
            int y = Integer.parseInt(token.nextToken());
            if (y < 1900) {
                y = y > 90 ? (y += 1900) : (y += 2000);
            }
            if (cal == null) {
                cal = new GregorianCalendar(y, m, d);
            } else {
                cal.set(y, m, d);
            }
            return cal;
        }
        catch (Exception e) {
            System.err.println("Error parsing date " + dt + " " + e);
            return null;
        }
    }

    String getPackage(String path) {
        if (path == null) {
            return path;
        }
        int idx = path.indexOf(":");
        if (idx < 0) {
            return path;
        }
        try {
            String s1;
            StringTokenizer token = new StringTokenizer(path.substring(idx + 2), "\\");
            if (!token.hasMoreTokens()) {
                return path;
            }
            token.nextToken();
            String ret = s1 = token.nextToken();
            while (token.hasMoreTokens()) {
                String s2 = token.nextToken();
                for (int i = 0; i < JARS.length; ++i) {
                    if (!s2.equals(JARS[i])) continue;
                    ret = JARS[i];
                }
            }
            return ret;
        }
        catch (Exception e) {
            System.err.println("Error finding package from path " + path);
            return path;
        }
    }

    public void filter() {
        String developer = null;
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                Vector<String> v;
                String comment;
                String fileName;
                StringTokenizer token = new StringTokenizer(line = line.trim(), "|");
                if (!token.hasMoreTokens()) continue;
                String path = token.nextToken();
                if (token.hasMoreTokens()) {
                    fileName = token.nextToken();
                    if (!fileName.endsWith(".java")) {
                        continue;
                    }
                } else {
                    fileName = "";
                }
                String dt = token.hasMoreTokens() ? token.nextToken() : "";
                if (!token.hasMoreTokens() || (comment = token.nextToken()).equals(INITIAL_VERSION)) continue;
                if (token.hasMoreTokens() && comment.length() > 0) {
                    developer = token.nextToken();
                }
                if ((this.lineDate = this.parseDate(null, dt)) == null || !this.lineDate.after(this.date)) continue;
                Object o = this.comments.get(comment);
                if (!(fileName.equals(this.lastFileName) || o != null && ((Vector)o).contains(developer))) {
                    this.lastFileName = fileName;
                }
                if (o == null || !((Vector)o).contains(developer)) {
                    v = o == null ? new Vector<String>() : (Vector<String>)o;
                    if (developer != null) {
                        v.addElement(developer);
                    }
                    if (o == null) {
                        this.comments.put(comment, v);
                    }
                }
                CommentInfo ci = null;
                v = (Vector<String>)this.commentsByJar.get(developer);
                if (v == null) {
                    v = new Vector<String>();
                    ci = new CommentInfo();
                    ci.comment = comment;
                    ci.files.addElement(fileName);
                    v.addElement((String)((Object)ci));
                    this.commentsByJar.put(developer, v);
                    continue;
                }
                boolean found = false;
                for (int c2 = 0; c2 < v.size(); ++c2) {
                    ci = (CommentInfo)v.elementAt(c2);
                    if (!ci.comment.equals(comment)) continue;
                    found = true;
                    ci.files.addElement(fileName);
                    break;
                }
                if (found) continue;
                ci = new CommentInfo();
                ci.comment = comment;
                ci.files.addElement(fileName);
                v.addElement((String)((Object)ci));
            }
            this.reader.close();
        }
        catch (IOException ie) {
            System.err.println("IO Error reading " + this.rfFile.getAbsolutePath());
        }
        Enumeration e = this.commentsByJar.keys();
        while (e.hasMoreElements()) {
            String j = (String)e.nextElement();
            Vector list = (Vector)this.commentsByJar.get(j);
            if (list == null) continue;
            System.out.println("\n************ Developer: " + j + " *************");
            for (int k = 0; k < list.size(); ++k) {
                Object obj = list.elementAt(k);
                if (obj instanceof CommentInfo) {
                    CommentInfo ci = (CommentInfo)list.elementAt(k);
                    this.printComment(ci.comment);
                    for (int f = 0; f < ci.files.size(); ++f) {
                        System.out.print("\t");
                        if (f == 0) {
                            System.out.print("File:");
                        } else {
                            System.out.print("     ");
                        }
                        System.out.println(ci.files.elementAt(f));
                    }
                    continue;
                }
                System.err.println("Unknown object in ci list " + obj);
            }
        }
    }

    void printComment(String comment) {
        int space = 0;
        System.out.print(" -");
        boolean first = true;
        if (comment.length() > 75) {
            int start = 75;
            while (comment.length() > 75) {
                if (comment.charAt(75) == ' ') {
                    space = 75;
                } else {
                    while (start > 0 && comment.charAt(start) != ' ') {
                        --start;
                    }
                }
                System.out.println((first ? "" : "  ") + comment.substring(0, start));
                first = false;
                comment = comment.substring(start);
            }
            System.out.println("  " + comment);
        } else {
            System.out.println(comment);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.out.println("USAGE: CodeReport filename mm/dd/ccyy");
            System.exit(1);
        }
        CodeReport cf = new CodeReport(args[0], args[1]);
        cf.filter();
        System.exit(0);
    }

    public class CommentInfo {
        String comment;
        Vector files = new Vector();
    }
}

