/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;
import rma.swing.RmaColor;
import rma.util.Clipping;
import rma.util.RMAIO;

@XmlRootElement(name="ColorContour")
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class ColorContour
implements Cloneable,
Serializable,
AsciiSerializable {
    public static final String ASPECT_SHADING_TYPE = "Aspect Shading";
    public static final String PRECIPITATION_TYPE = "Precipitation";
    public static final String GRAYSCALE_TYPE = "Grayscale";
    public static final String RED_GREEN_BLUE_TYPE = "Red-Green-Blue";
    public static final String TERRAIN_TYPE = "Terrain";
    public static final String LINEAR_TYPE = "Linear";
    public static final String WATER_DEPTH_TYPE = "Water Depth";
    @XmlElement(name="saturation")
    protected double _sat = 1.0;
    @XmlElement(name="brightness")
    protected double _bright = 1.0;
    @XmlElement(name="minimum")
    protected double _min = Double.NEGATIVE_INFINITY;
    @XmlElement(name="maximum")
    protected double _max = Double.NEGATIVE_INFINITY;
    protected double _maxMinusMin = Double.NEGATIVE_INFINITY;
    @XmlElement(name="maxClipping")
    protected Clipping _maxClip = new Clipping();
    @XmlElement(name="minClipping")
    protected Clipping _minClip = new Clipping();
    @XmlElement(name="scaleToClipping")
    protected boolean _scaleToClipping = false;
    protected static Map _typeToClass = new TreeMap();
    protected transient PropertyChangeSupport mPropertyChangeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeSupport(PropertyChangeListener listener) {
        this.mPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addExtras(JPanel panel, Observer observer) {
    }

    public static Object getType(ColorContour cc) {
        String classname = cc.getClass().getName();
        for (Object key : _typeToClass.keySet()) {
            Object val = _typeToClass.get(key);
            if (!val.equals(classname)) continue;
            return key;
        }
        return null;
    }

    public void setScaleToClipping(boolean b) {
        this._scaleToClipping = b;
    }

    public boolean getScaleToClipping() {
        return this._scaleToClipping;
    }

    public static Object[] getTypes() {
        Set keys = _typeToClass.keySet();
        if (keys.size() < 1) {
            return null;
        }
        Object[] keyarray = keys.toArray();
        return keyarray;
    }

    public static ColorContour getInstanceForType(Object type) {
        if (type == null) {
            return null;
        }
        Object o = _typeToClass.get(type);
        if (o == null) {
            return null;
        }
        Class<?> c2 = null;
        try {
            c2 = Class.forName(o.toString());
            ColorContour cc = (ColorContour)c2.newInstance();
            return cc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
            ColorContour cc = (ColorContour)clone;
            this.copyInto(cc);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return clone;
    }

    public void copyInto(ColorContour cc) {
        cc.setSaturation(this._sat);
        cc.setBrightness(this._bright);
        cc.setMinValue(this._min);
        cc.setMaxValue(this._max);
        cc.setMaxClipping((Clipping)this._maxClip.clone());
        cc.setMinClipping((Clipping)this._minClip.clone());
        cc.setScaleToClipping(this._scaleToClipping);
    }

    public double getMinValue() {
        return this._min;
    }

    public void setMinValue(double d) {
        this._min = d;
        this._maxMinusMin = this._max - this._min;
    }

    public double getMaxValue() {
        return this._max;
    }

    public void setMaxValue(double d) {
        this._max = d;
        this._maxMinusMin = this._max - this._min;
    }

    public double getSaturation() {
        return this._sat;
    }

    public void setSaturation(double d) {
        this._sat = d;
    }

    public double getBrightness() {
        return this._bright;
    }

    public void setBrightness(double d) {
        this._bright = d;
    }

    public Clipping getMaxClipping() {
        return this._maxClip;
    }

    public void setMaxClipping(Clipping c2) {
        this._maxClip = c2;
    }

    public Clipping getMinClipping() {
        return this._minClip;
    }

    public void setMinClipping(Clipping c2) {
        this._minClip = c2;
    }

    protected abstract double[] getRGB0(double var1, double var3, double var5);

    protected abstract void getRGB0(double[] var1, double var2, double var4, double var6);

    public Color getColor(double val) {
        return this.getColor(val, 1.0);
    }

    public Color getColor(double val, double lafc) {
        Color color = new Color(this.getRGB(val, lafc), true);
        return color;
    }

    public int getRGB(double val, double lafc) {
        double[] rgb = new double[3];
        return this.getRGB(rgb, val, lafc);
    }

    public int getRGB(double[] rgb, double val, double lafc) {
        int alpha = 255;
        if (this._minClip._enabled && val < this._minClip.getValue()) {
            rgb[0] = this._minClip.getColor().getRed();
            rgb[1] = this._minClip.getColor().getGreen();
            rgb[2] = this._minClip.getColor().getBlue();
            alpha = this._minClip.getColor().getAlpha();
        } else if (this._maxClip._enabled && val > this._maxClip.getValue()) {
            rgb[0] = this._maxClip.getColor().getRed();
            rgb[1] = this._maxClip.getColor().getGreen();
            rgb[2] = this._maxClip.getColor().getBlue();
            alpha = this._maxClip.getColor().getAlpha();
        } else {
            double min = this._minClip.getEnabled() && this._scaleToClipping ? this._minClip.getValue() : this._min;
            double max = this._maxClip.getEnabled() && this._scaleToClipping ? this._maxClip.getValue() : this._max;
            this.getRGB0(rgb, val, min, max);
            if (rgb[0] == 2.147483647E9 && rgb[1] == 2.147483647E9 && rgb[2] == 2.147483647E9) {
                return 0;
            }
        }
        rgb[0] = rgb[0] * lafc;
        rgb[1] = rgb[1] * lafc;
        rgb[2] = rgb[2] * lafc;
        double sat = 1.0 - this._sat;
        double dr = (255.0 - rgb[0]) * sat;
        double dg = (255.0 - rgb[1]) * sat;
        double db = (255.0 - rgb[2]) * sat;
        int ir = (int)((rgb[0] + dr) * this._bright);
        if (ir < 0) {
            ir = 0;
        } else if (ir > 255) {
            ir = 255;
        }
        int ig = (int)((rgb[1] + dg) * this._bright);
        if (ig < 0) {
            ig = 0;
        } else if (ig > 255) {
            ig = 255;
        }
        int ib = (int)((rgb[2] + db) * this._bright);
        if (ib < 0) {
            ib = 0;
        } else if (ib > 255) {
            ib = 255;
        }
        int intrgb = (alpha & 0xFF) << 24 | ((ir & 0xFF) << 16 | (ig & 0xFF) << 8 | (ib & 0xFF) << 0);
        return intrgb;
    }

    public void read(BufferedReader input) throws IOException {
        String line = input.readLine();
        while (line != null && line.indexOf("ColorContourEnd") < 0) {
            int rgb;
            Color color;
            String type = RMAIO.getType(line, "=");
            String param = RMAIO.getParam(line, "=");
            if (type.compareTo("MinValue") == 0) {
                this.setMinValue(RMAIO.parseDouble(param));
            } else if (type.compareTo("MaxValue") == 0) {
                this.setMaxValue(RMAIO.parseDouble(param));
            } else if (type.compareTo("Saturation") == 0) {
                this.setSaturation(RMAIO.parseDouble(param));
            } else if (type.compareTo("Brightness") == 0) {
                this.setBrightness(RMAIO.parseDouble(param));
            } else if (type.compareTo("MaxClippingColor") == 0) {
                block27: {
                    color = null;
                    try {
                        rgb = Integer.parseInt(param);
                        color = new Color(rgb, true);
                    }
                    catch (Exception e) {
                        color = RmaColor.parseColorString(param);
                        if (color != null) break block27;
                        color = Color.gray;
                    }
                }
                this.getMaxClipping().setColor(color);
            } else if (type.compareTo("MaxClippingValue") == 0) {
                this.getMaxClipping().setValue(RMAIO.parseDouble(param));
            } else if (type.compareTo("MaxClippingEnabled") == 0) {
                this.getMaxClipping().setEnabled(Boolean.valueOf(param));
            } else if (type.compareTo("MinClippingColor") == 0) {
                block28: {
                    color = null;
                    try {
                        rgb = Integer.parseInt(param);
                        color = new Color(rgb, true);
                    }
                    catch (Exception e) {
                        color = RmaColor.parseColorString(param);
                        if (color != null) break block28;
                        color = Color.gray;
                    }
                }
                this.getMinClipping().setColor(color);
            } else if (type.compareTo("MinClippingValue") == 0) {
                this.getMinClipping().setValue(RMAIO.parseDouble(param));
            } else if (type.compareTo("MinClippingEnabled") == 0) {
                this.getMinClipping().setEnabled(Boolean.valueOf(param));
            } else if (type.compareTo("ScaleToClipping") == 0) {
                this._scaleToClipping = Boolean.valueOf(param);
            } else {
                this.read0(type, param, input);
            }
            line = input.readLine();
        }
    }

    protected void read0(String type, String param, BufferedReader input) throws IOException {
    }

    public void write(BufferedWriter output) throws IOException {
        output.write("ColorContour=" + this.getClass().getName());
        output.newLine();
        output.write("MinValue=" + Double.toString(this.getMinValue()));
        output.newLine();
        output.write("MaxValue=" + Double.toString(this.getMaxValue()));
        output.newLine();
        output.write("Saturation=" + Double.toString(this.getSaturation()));
        output.newLine();
        output.write("Brightness=" + Double.toString(this.getBrightness()));
        output.newLine();
        output.write("MaxClippingColor=" + this.getMaxClipping().getColor().getRGB());
        output.newLine();
        output.write("MaxClippingValue=" + Double.toString(this.getMaxClipping().getValue()));
        output.newLine();
        output.write("MaxClippingEnabled=" + this.getMaxClipping().getEnabled());
        output.newLine();
        output.write("MinClippingColor=" + this.getMinClipping().getColor().getRGB());
        output.newLine();
        output.write("MinClippingValue=" + Double.toString(this.getMinClipping().getValue()));
        output.newLine();
        output.write("MinClippingEnabled=" + this.getMinClipping().getEnabled());
        output.write("ScaleToClipping=" + this._scaleToClipping);
        output.newLine();
    }

    public static ColorContour createContourFromAttributes(Map attributes) {
        ColorContour cc = null;
        if (attributes == null) {
            return cc;
        }
        Object obj = attributes.get("ColorContourType");
        if (obj == null) {
            return cc;
        }
        cc = ColorContour.getInstanceForType(obj);
        if (cc == null) {
            return cc;
        }
        cc.setAttributes(attributes);
        return cc;
    }

    protected void setAttributes(Map attributes) {
        Object obj = attributes.get("MinValue");
        this._min = RMAIO.parseDouble(obj, this.getMinValue());
        obj = attributes.get("MaxValue");
        this._max = RMAIO.parseDouble(obj, this.getMaxValue());
        obj = attributes.get("Saturation");
        this._sat = RMAIO.parseDouble(obj, this.getSaturation());
        obj = attributes.get("Brightness");
        this._bright = RMAIO.parseDouble(obj, this.getBrightness());
        obj = attributes.get("MaxClippingColor");
        Color clr = RmaColor.parseColorString((String)obj);
        if (clr != null) {
            this.getMaxClipping().setColor(clr);
        }
        obj = attributes.get("MaxClippingValue");
        this.getMaxClipping().setValue(RMAIO.parseDouble(obj, this.getMaxClipping().getValue()));
        obj = attributes.get("MaxClippingEnabled");
        this.getMaxClipping().setEnabled("true".equals(obj));
        obj = attributes.get("MinClippingColor");
        clr = RmaColor.parseColorString((String)obj);
        if (clr != null) {
            this.getMinClipping().setColor(clr);
        }
        obj = attributes.get("MinClippingValue");
        this.getMinClipping().setValue(RMAIO.parseDouble(obj, this.getMinClipping().getValue()));
        obj = attributes.get("MinClippingEnabled");
        this.getMinClipping().setEnabled("true".equals(obj));
        obj = attributes.get("ScaleToClipping");
        if (obj != null) {
            this._scaleToClipping = Boolean.valueOf(obj.toString());
        }
        this._maxMinusMin = this._max - this._min;
    }

    public Map getAttributes() {
        LinkedHashMap map = new LinkedHashMap();
        return this.getAttributes(map);
    }

    protected Map getAttributes(Map map) {
        map.put("ColorContourType", ColorContour.getType(this));
        map.put("MinValue", Double.toString(this.getMinValue()));
        map.put("MaxValue", Double.toString(this.getMaxValue()));
        map.put("Saturation", Double.toString(this.getSaturation()));
        map.put("Brightness", Double.toString(this.getBrightness()));
        map.put("MaxClippingColor", RmaColor.color2String(this.getMaxClipping().getColor(), true));
        map.put("MaxClippingValue", Double.toString(this.getMaxClipping().getValue()));
        map.put("MaxClippingEnabled", String.valueOf(this.getMaxClipping().getEnabled()));
        map.put("MinClippingColor", RmaColor.color2String(this.getMinClipping().getColor(), true));
        map.put("MinClippingValue", Double.toString(this.getMinClipping().getValue()));
        map.put("MinClippingEnabled", String.valueOf(this.getMinClipping().getEnabled()));
        map.put("ScaleToClipping", Boolean.toString(this._scaleToClipping));
        return map;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    static {
        _typeToClass.put(ASPECT_SHADING_TYPE, "rma.util.AspectShadingColorContour");
        _typeToClass.put(PRECIPITATION_TYPE, "rma.util.PrecipColorContour");
        _typeToClass.put(GRAYSCALE_TYPE, "rma.util.GrayscaleColorContour");
        _typeToClass.put(RED_GREEN_BLUE_TYPE, "rma.util.RGBColorContour");
        _typeToClass.put(TERRAIN_TYPE, "rma.util.TerrainColorContour");
        _typeToClass.put(LINEAR_TYPE, "rma.util.LinearColorContour");
        _typeToClass.put(WATER_DEPTH_TYPE, "rma.util.WaterDepthColorContour");
    }
}

