/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4deleteFlag;
import codebase.Field4double;
import codebase.Field4stringBuffer;
import hec.io.AsciiSerializableConstants;
import hec.io.AsciiSerializerFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.SerializerEditDlg;
import rma.swing.event.ReflectMultiListener;
import rma.swing.wheel.WheelTool;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class DBFFileViewer
extends RmaJFrame
implements AsciiSerializableConstants,
ActionListener {
    private static final int REC_NO_COL = 0;
    private static final int OBJ_ID_COL = 1;
    private static final int NAME_COL = 2;
    private static final int DESC_COL = 3;
    private static final int CLASS_COL = 4;
    private static final int OBJ_COL = 5;
    static final String TAG_ID = "TAG_ID";
    static final String TAG_NAME = "TAG_NAME";
    static final String FIELD_ID = "F_ID";
    static final String FIELD_NAME = "F_NAME";
    static final String FIELD_DESC = "F_DESC";
    static final String FIELD_OBJ = "F_OBJ";
    static final int MAX_ITEM_LEN = 50;
    RmaJTextField fileNameTxt;
    RmaJTextField fileSizeTxt;
    RmaJIntegerField recordCntTxt;
    RmaJTable objectTable;
    JMenuItem deleteMenuItem;
    JMenuItem packMenuItem;
    JMenuItem copyMenuItem;
    JMenuItem renameMenuItem;
    JMenuItem undeleteMenuItem;
    JCheckBoxMenuItem showDeletedMenuItem;
    JMenu fileMenu;
    Data4jni _dataFile;
    Field4double _objIdField;
    Field4stringBuffer _objNameField;
    Field4stringBuffer _objDescField;
    Field4stringBuffer _objSerializeField;
    Field4deleteFlag _deleteFlag;
    long _nextId = 1L;
    static Code4jni _database = null;
    File _currentDir;
    ReflectMultiListener _listener;
    Vector _lastMenus = new Vector();
    Hashtable _findDialogs = new Hashtable();
    boolean _opened = false;

    public DBFFileViewer() {
        this.setDefaultCloseOperation(0);
        try {
            _database = new Code4jni();
        }
        catch (IOException e) {
            System.out.println("Critical Error trying to open the database");
            System.out.println(e.getMessage());
        }
        this._listener = new ReflectMultiListener();
        try {
            int osType = RMAIO.getOSType();
            if (osType == 0 || osType == 1) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                WheelTool.initWheelTool();
            } else if (osType == 2) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                Font f = UIManager.getFont("TextField.font");
                f = new Font("timesroman", 0, 10);
                UIManager.put("Menu.font", f);
                UIManager.put("MenuItem.font", f);
                UIManager.put("CheckBoxMenuItem.font", f);
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                UIManager.put("TextField.font", f);
                UIManager.put("TextArea.font", f);
                UIManager.put("TextPane.font", f);
                UIManager.put("Table.font", f);
                UIManager.put("Menu.font", f);
                UIManager.put("MenuItem.font", f);
                UIManager.put("CheckBoxMenuItem.font", f);
                UIManager.put("text", new Color(0xC0C0C0));
                UIManager.put("Button.font", f);
                UIManager.put("Label.font", f);
                UIManager.put("TitledBorder.font", f);
                UIManager.put("TableHeader.font", f);
                UIManager.put("List.font", f);
                MetalLookAndFeel cfr_ignored_0 = (MetalLookAndFeel)UIManager.getLookAndFeel();
                UIManager.put("Button.background", MetalLookAndFeel.getMenuBackground());
                UIManager.put("ComboBox.font", f);
                MetalLookAndFeel cfr_ignored_1 = (MetalLookAndFeel)UIManager.getLookAndFeel();
                UIManager.put("Panel.background", MetalLookAndFeel.getMenuBackground());
                UIManager.put("CheckBox.font", f);
                UIManager.put("TabbedPane.font", f);
                UIManager.put("RadioButton.font", f);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to set look and feel");
        }
        this.buildMenus();
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("DBF File Viewer");
        this.setDefaultCloseOperation(3);
        JLabel label = new JLabel("File:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)label, gbc);
        this.fileNameTxt = new RmaJTextField();
        this.fileNameTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.fileNameTxt, gbc);
        this.objectTable = new RmaJTable((Component)this, (Object[])new String[]{"RecNo", "ID", "Name", "Description", "Class", "object"});
        this.objectTable.setColumnWidths(50, 40, 200, 200, 200, 0);
        this.objectTable.setAutoResizeMode(0);
        this.objectTable.setEditable(false);
        this.objectTable.setCellSelectionEnabled(false);
        this.objectTable.setColumnSelectionAllowed(false);
        this.objectTable.setRowSelectionAllowed(true);
        this.objectTable.setAddRemoveEnabled(false);
        this.objectTable.setColumnVisible(5, false, 0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 3.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.objectTable.getScrollPane(), gbc);
        label = new JLabel("Number of Records:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)label, gbc);
        this.recordCntTxt = new RmaJIntegerField(0, 5);
        this.recordCntTxt.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.recordCntTxt, gbc);
        label = new JLabel("File Size:");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)label, gbc);
        this.fileSizeTxt = new RmaJTextField();
        this.fileSizeTxt.setEditable(false);
        this.fileSizeTxt.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.fileSizeTxt, gbc);
        this.pack();
        this.setLocation();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DBFFileViewer.this.exitApp();
            }
        });
        this.objectTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = DBFFileViewer.this.objectTable.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    Object obj = DBFFileViewer.this.objectTable.getCell(row, 5);
                    String name = (String)DBFFileViewer.this.objectTable.getCell(row, 2);
                    double record = -1.0;
                    if (DBFFileViewer.this._objIdField != null) {
                        record = (Double)DBFFileViewer.this.objectTable.getCell(row, 1);
                    }
                    if (obj != null) {
                        DBFFileViewer.this.displaySerializedObject(name, record, obj.toString());
                    }
                }
            }
        });
        this.objectTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = DBFFileViewer.this.objectTable.getSelectedRow();
                DBFFileViewer.this.deleteMenuItem.setEnabled(row != -1);
                DBFFileViewer.this.copyMenuItem.setEnabled(row != -1);
                DBFFileViewer.this.renameMenuItem.setEnabled(row != -1);
                Integer key = (Integer)DBFFileViewer.this.objectTable.getValueAt(row, 0);
                if (key == null) {
                    DBFFileViewer.this.undeleteMenuItem.setEnabled(false);
                    return;
                }
                try {
                    DBFFileViewer.this._dataFile.top();
                    DBFFileViewer.this._dataFile.go(key.intValue());
                    if (DBFFileViewer.this._deleteFlag.isDeleted() && DBFFileViewer.this.showDeletedMenuItem.isSelected()) {
                        DBFFileViewer.this.undeleteMenuItem.setEnabled(true);
                    } else {
                        DBFFileViewer.this.undeleteMenuItem.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    System.out.println("error seeking to row " + key + " Error" + ex);
                }
            }
        });
        this.fileNameTxt.setDragEnabled(true);
        DropTarget dropTarget = new DropTarget(this.fileNameTxt, new DnDFileDropListener());
    }

    private void buildMenus() {
        JMenuBar mb = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        mb.add(this.fileMenu);
        JMenuItem menuItem = new JMenuItem("Open", 79);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "openFile"));
        this.fileMenu.add(menuItem);
        menuItem = new JMenuItem("Reload", 82);
        menuItem.addActionListener(this._listener.add(this, menuItem, "reloadFile"));
        this.fileMenu.add(menuItem);
        this.packMenuItem = new JMenuItem("Pack", 80);
        this.packMenuItem.addActionListener(this._listener.add(this, this.packMenuItem, "packFile"));
        this.fileMenu.add(this.packMenuItem);
        this.fileMenu.addSeparator();
        menuItem = new JMenuItem("Exit", 69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "exitApp"));
        this.fileMenu.add(menuItem);
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic('E');
        mb.add(menu);
        this.deleteMenuItem = new JMenuItem("Delete Record", 68);
        this.deleteMenuItem.addActionListener(this._listener.add(this, this.deleteMenuItem, "deleteRecord"));
        this.deleteMenuItem.setEnabled(false);
        menu.add(this.deleteMenuItem);
        this.copyMenuItem = new JMenuItem("Copy Record", 67);
        this.copyMenuItem.addActionListener(this._listener.add(this, this.copyMenuItem, "copyRecord"));
        this.copyMenuItem.setEnabled(false);
        menu.add(this.copyMenuItem);
        this.renameMenuItem = new JMenuItem("Rename Record", 82);
        this.renameMenuItem.addActionListener(this._listener.add(this, this.renameMenuItem, "renameRecord"));
        this.renameMenuItem.setEnabled(false);
        menu.add(this.renameMenuItem);
        menu.addSeparator();
        this.showDeletedMenuItem = new JCheckBoxMenuItem("Show Deleted");
        this.showDeletedMenuItem.addActionListener(this._listener.add(this, this.showDeletedMenuItem, "reloadFile"));
        menu.add(this.showDeletedMenuItem);
        this.undeleteMenuItem = new JMenuItem("Undelete Record", 85);
        this.undeleteMenuItem.addActionListener(this._listener.add(this, this.undeleteMenuItem, "undeleteRecord"));
        this.undeleteMenuItem.setVisible(false);
        menu.add(this.undeleteMenuItem);
        this.setJMenuBar(mb);
        Object userDir = System.getProperty("user.home");
        if (userDir == null) {
            return;
        }
        userDir = (String)userDir + File.separator + "dbfviewer.props";
        this.fileMenu.addSeparator();
        File f = new File((String)userDir);
        try {
            if (f.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    menuItem = this.addFileMenu(line);
                    if (menuItem == null) break;
                    this._lastMenus.add(menuItem);
                }
                reader.close();
                this.updateFileMenu();
            }
        }
        catch (Exception e) {
            System.out.println("buildMenus: error opening/reading " + (String)userDir + " Error:" + e);
            return;
        }
    }

    private JMenuItem addFileMenu(String filename) {
        if (this._lastMenus.size() >= 5) {
            return null;
        }
        JMenuItem menuItem = new JMenuItem(this.getMenuItemname(filename));
        menuItem.setName(filename);
        menuItem.setActionCommand("openFile");
        menuItem.addActionListener(this);
        menuItem.setToolTipText(filename);
        return menuItem;
    }

    private void updateFileMenu() {
        JMenuItem mi;
        int i;
        int cnt = this.fileMenu.getMenuComponentCount();
        for (i = 0; i < this._lastMenus.size(); ++i) {
            mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null) {
                return;
            }
            this.fileMenu.remove(mi);
        }
        if (this._lastMenus.size() > 5) {
            this._lastMenus.setSize(5);
        }
        for (i = 0; i < this._lastMenus.size(); ++i) {
            mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null) continue;
            this.fileMenu.add(mi);
        }
    }

    public void reloadFile() {
        String fileName = this.fileNameTxt.getText();
        if (fileName.length() == 0) {
            return;
        }
        this.closeFile();
        this.openFile(new File(fileName));
    }

    public void openFile() {
        JFileChooser chooser = new JFileChooser();
        if (this._currentDir == null) {
            this._currentDir = new File(System.getProperty("user.dir"));
        }
        chooser.setCurrentDirectory(this._currentDir);
        chooser.setFileFilter(new RMAFilenameFilter("dbf", "DBF Files"));
        int retval = chooser.showOpenDialog(this);
        if (retval == 0) {
            File theFile = chooser.getSelectedFile();
            if (theFile == null) {
                return;
            }
            this.openFile(theFile);
        }
    }

    private boolean openFile(File theFile) {
        this.closeFile();
        this.fileNameTxt.setText(theFile.getAbsolutePath());
        try {
            this._dataFile = new Data4jni(_database, theFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println("ERROR <openFile> : " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        boolean b = this.initializeDataVariables();
        this._currentDir = theFile.getParentFile();
        this._opened = true;
        int foundPos = -1;
        String path = theFile.getPath();
        for (int i = 0; i < this._lastMenus.size(); ++i) {
            JMenuItem mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null || !mi.getName().equals(path)) continue;
            foundPos = i;
            break;
        }
        if (foundPos == -1) {
            this._lastMenus.add(0, this.addFileMenu(path));
        } else {
            Object obj = this._lastMenus.remove(foundPos);
            this._lastMenus.add(0, obj);
        }
        if (this._lastMenus.size() > 5) {
            this._lastMenus.setSize(5);
        }
        this.updateFileMenu();
        return b;
    }

    private boolean initializeDataVariables() {
        if (!this.mapFields()) {
            return false;
        }
        try {
            this._dataFile.select(null);
            this._dataFile.bottom();
            this._dataFile.top();
            this.fillTable();
        }
        catch (Exception e) {
            System.out.println("ERROR <initializeDataVariable()> : Error computing the next ID value");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean mapFields() {
        try {
            this._objIdField = new Field4double((Data4)this._dataFile, FIELD_ID);
        }
        catch (Exception e) {
            System.out.println("ERROR mapFields() : " + e.getMessage());
            this._objIdField = null;
        }
        try {
            this._objNameField = new Field4stringBuffer((Data4)this._dataFile, FIELD_NAME);
            this._objDescField = new Field4stringBuffer((Data4)this._dataFile, FIELD_DESC);
            this._objSerializeField = new Field4stringBuffer((Data4)this._dataFile, FIELD_OBJ);
            this._deleteFlag = new Field4deleteFlag((Data4)this._dataFile);
        }
        catch (Exception e) {
            System.out.println("ERROR mapFields() : " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void fillTable() {
        this.objectTable.deleteCells();
        this.objectTable.clearColors();
        if (!this.showDeletedMenuItem.isSelected()) {
            this.undeleteMenuItem.setVisible(false);
            this.undeleteMenuItem.setEnabled(false);
            try {
                if (this._objIdField != null) {
                    this._dataFile.select(TAG_ID);
                }
            }
            catch (Exception e4) {
                System.out.println("ERROR <fillTable.> : Error selecting ID tag - " + e4.getMessage());
                e4.printStackTrace();
            }
        } else {
            this.undeleteMenuItem.setVisible(true);
            this.undeleteMenuItem.setEnabled(false);
        }
        boolean i = false;
        int rowNum = 0;
        try {
            int rc = this._dataFile.top();
            while (rc == 0) {
                try {
                    Vector<Object> row = new Vector<Object>(5);
                    row.add(new Integer(this._dataFile.recNo()));
                    if (this._objIdField != null) {
                        row.add(this._objIdField.get());
                    } else {
                        int recNum = this._dataFile.recNo();
                        row.add(String.valueOf(recNum));
                    }
                    row.add(this._objNameField.get().toString().trim());
                    row.add(this._objDescField.get().toString().trim());
                    String dataObj = this.loadCurrentRecord();
                    if (dataObj != null) {
                        String cls = this.getClassFromData(dataObj);
                        row.add(cls);
                        row.add(dataObj);
                    }
                    this.objectTable.appendRow(row);
                    if (this._deleteFlag.isDeleted()) {
                        this.objectTable.setRowForeground(rowNum, Color.red);
                    }
                    ++rowNum;
                }
                catch (Error4 e) {
                    System.out.println("ERROR <fillTable()> : Database Error " + e.getMessage());
                    return;
                }
                catch (Exception ee) {
                    System.out.println("ERROR <fillTable()()> : Exception " + ee);
                    return;
                }
                rc = this._dataFile.skip(1);
            }
            this.recordCntTxt.setValue(this._dataFile.recCount());
            File f = new File(this.fileNameTxt.getText());
            NumberFormat nf = NumberFormat.getInstance();
            String size = nf.format(f.length());
            this.fileSizeTxt.setText(size);
        }
        catch (Exception e) {
            System.out.println("ERROR: Trying to load object list");
            System.out.println(e.getMessage());
            return;
        }
    }

    private String getClassFromData(String dataObj) {
        StringReader strReader = new StringReader(dataObj);
        BufferedReader bufReader = new BufferedReader(strReader);
        try {
            String line;
            while ((line = bufReader.readLine()) != null) {
                if (!line.startsWith("{")) continue;
                return RMAIO.getParam(line, "=");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String loadCurrentRecord() {
        try {
            return this._objSerializeField.get().toString();
        }
        catch (Exception e) {
            System.out.println("ERROR <AsciiDataStorage.loadObject()> : Unable to get serialize object from data base -  " + e.getMessage());
            return null;
        }
    }

    private void displaySerializedObject(String name, double recordNumber, String serObject) {
        SerializerEditDlg chooserDialog = new SerializerEditDlg(this, "Serialized Object " + name, false, recordNumber);
        AsciiSerializerFormatter formatter = new AsciiSerializerFormatter();
        String text = formatter.format(serObject);
        chooserDialog.setText(text);
        chooserDialog.setVisible(true);
    }

    public void exitApp() {
        this.saveLastFile();
        this.closeFile();
        this.setVisible(false);
        System.exit(0);
    }

    private void saveLastFile() {
        Object userDir = System.getProperty("user.home");
        if (userDir == null) {
            return;
        }
        userDir = (String)userDir + File.separator + "dbfviewer.props";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter((String)userDir));
            for (int i = 0; i < this._lastMenus.size(); ++i) {
                JMenuItem mi = (JMenuItem)this._lastMenus.get(i);
                if (mi == null) continue;
                writer.write(mi.getName());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("saveLastFile: error opening/writing " + (String)userDir + " Error:" + e);
        }
    }

    public void packFile() {
        try {
            this._dataFile.pack();
            this._dataFile.memoCompress();
            File f = new File(this.fileNameTxt.getText());
            NumberFormat nf = NumberFormat.getInstance();
            this.fileSizeTxt.setText(nf.format(f.length()));
        }
        catch (Exception e) {
            System.out.println("packFile: error packing file " + e);
        }
    }

    public void closeFile() {
        if (!this._opened) {
            return;
        }
        try {
            this._dataFile.close();
            this.fileNameTxt.setText("");
            this.fileSizeTxt.setText("");
            this._opened = false;
        }
        catch (Error4unexpected e4unex) {
            System.err.println("Unexcpected Error encountered when closing the database");
            e4unex.printStackTrace();
        }
        catch (Error4usage e4usage) {
            e4usage.printStackTrace();
        }
    }

    public boolean saveRecord(double recNumber, String serializedTxt) {
        if (recNumber < 0.0) {
            System.out.println("saveRecord: invalid record number " + recNumber);
            return false;
        }
        if (serializedTxt == null) {
            System.out.println("saveRecord: no serialized text to save for record " + recNumber);
            return false;
        }
        boolean found = false;
        int row = -1;
        for (int i = 0; i < this.objectTable.getRowCount(); ++i) {
            double d = (Double)this.objectTable.getCell(i, 1);
            if (d != recNumber) continue;
            row = i;
            break;
        }
        if (row == -1) {
            System.out.println("saveRecord: failed to find Record " + recNumber);
        }
        System.out.println("saveRecord: record " + recNumber + " is row " + row);
        String name = (String)this.objectTable.getCell(row, 2);
        String desc = (String)this.objectTable.getCell(row, 3);
        int opt = JOptionPane.showConfirmDialog(this, "<html>OK to update record <font=+0 Color=blue>" + recNumber + "</font> Name=<font=+0 Color=blue>" + name + "</font> with new serialized data?", "Confirm Save", 0);
        if (opt != 0) {
            return false;
        }
        try {
            if (!this.findObject(TAG_ID, String.valueOf(recNumber))) {
                System.out.println("saveRecord: failed to find record " + recNumber);
                return false;
            }
            if (this._objIdField != null) {
                this._objIdField.set(new Double(recNumber));
            }
            this._objNameField.set(new StringBuffer(name));
            this._objDescField.set(new StringBuffer(desc));
            this._objSerializeField.set(new StringBuffer(serializedTxt));
            this._dataFile.update();
            this.fillTable();
        }
        catch (Error4unique e4unique) {
            System.out.println("ERROR saveRecord(" + this._objIdField + ") : Unique key constraint is violated in saveRecord()");
            System.out.println("ERROR Occured for object (" + recNumber + ") - " + name);
            System.out.println(e4unique.getMessage());
            return false;
        }
        catch (Exception e) {
            System.out.println("ERROR saveRecordcord(" + recNumber + ") : Fatal Error Saving Data");
            System.out.println("ERROR Occured for object (" + recNumber + ") - " + name);
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyRecord() {
        int row = this.objectTable.getSelectedRow();
        double srcRow = -1.0;
        double destRow = -1.0;
        if (row == -1) {
            return;
        }
        srcRow = (Double)this.objectTable.getCell(row, 1);
        try {
            String desc;
            String name;
            Object srcObj;
            String copyToRow;
            block18: {
                copyToRow = JOptionPane.showInputDialog(this, (Object)("Enter destination record number to copy source record " + srcRow + " to"));
                if (copyToRow == null || copyToRow.length() == 0) {
                    System.out.println("copyRecord: to destination record entered.");
                    return;
                }
                copyToRow = copyToRow.trim();
                try {
                    destRow = Double.parseDouble(copyToRow);
                }
                catch (Exception e) {
                    System.out.println("copyRecord: invalid destination Record number " + copyToRow);
                }
                boolean found = false;
                for (int i = 0; i < this.objectTable.getRowCount(); ++i) {
                    double d = (Double)this.objectTable.getCell(i, 1);
                    if (d != destRow) continue;
                    destRow = d;
                    found = true;
                    break;
                }
                if (!found) {
                    System.out.println("copyRecord: failed to find Destination Record " + copyToRow);
                }
                System.out.println("copyRecord: copy src record " + srcRow + " to dest record " + destRow);
                this.setCursor(Cursor.getPredefinedCursor(3));
                srcObj = this.objectTable.getCell(row, 5);
                if (srcObj == null) {
                    System.out.println("copyRecord: failed to find src object to copy");
                    return;
                }
                name = (String)this.objectTable.getCell((int)destRow, 2);
                desc = (String)this.objectTable.getCell((int)destRow, 3);
                if (this.findObject(TAG_ID, copyToRow)) break block18;
                System.out.println("copyRecord: failed to find dest record " + copyToRow);
                return;
            }
            try {
                if (this._objIdField != null) {
                    this._objIdField.set(new Double(copyToRow));
                }
                this._objNameField.set(new StringBuffer(name));
                this._objDescField.set(new StringBuffer(desc));
                this._objSerializeField.set(new StringBuffer(srcObj.toString()));
                this._dataFile.update();
                this.fillTable();
            }
            catch (Error4unique e4unique) {
                System.out.println("ERROR copyRecord(" + this._objIdField + ") : Unique key constraint is violated in copyRecord()");
                System.out.println("ERROR Occured for object (" + destRow + ") - " + name);
                System.out.println(e4unique.getMessage());
            }
            catch (Exception e) {
                System.out.println("ERROR copyRecord(" + destRow + ") : Fatal Error Saving Data");
                System.out.println("ERROR Occured for object (" + destRow + ") - " + name);
                System.out.println(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameRecord() {
        int row = this.objectTable.getSelectedRow();
        double srcRecord = -1.0;
        if (row == -1) {
            return;
        }
        srcRecord = (Double)this.objectTable.getCell(row, 1);
        try {
            String newName;
            block11: {
                String name = (String)this.objectTable.getCell(row, 2);
                newName = JOptionPane.showInputDialog(this, (Object)("<html>Enter new name for <FONT=+0 COLOR=blue>" + name + "</FONT> record no.<FONT=+0 COLOR=blue> " + srcRecord + "</FONT>:</html>"));
                if (newName == null || newName.length() == 0) {
                    System.out.println("renameRecord: no new name entered");
                    return;
                }
                System.out.println("renameRecord: rename record " + srcRecord + " to " + newName);
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (this.findObject(TAG_ID, String.valueOf(srcRecord))) break block11;
                System.out.println("renameRecord: failed to find source record " + srcRecord);
                return;
            }
            try {
                this._objNameField.set(new StringBuffer(newName));
                this._dataFile.update();
                this.fillTable();
            }
            catch (Error4unique e4unique) {
                System.out.println("ERROR renameRecord(" + this._objIdField + ") : Unique key constraint is violated in renameRecord()");
                System.out.println("ERROR Occured for object (" + srcRecord + ") - " + newName);
                System.out.println(e4unique.getMessage());
            }
            catch (Exception e) {
                System.out.println("ERROR renameRecord(" + srcRecord + ") : Fatal Error Saving Data");
                System.out.println("ERROR Occured for object (" + srcRecord + ") - " + newName);
                System.out.println(e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undeleteRecord() {
        int[] rows = this.objectTable.getSelectedRows();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < rows.length; ++i) {
                Integer recNo;
                block16: {
                    if (rows[i] == -1) {
                        JOptionPane.showMessageDialog(this, "Invalid row selected");
                        return;
                    }
                    recNo = (Integer)this.objectTable.getCell(rows[i], 0);
                    if (recNo == null) continue;
                    try {
                        this._dataFile.top();
                        this._dataFile.go(recNo.intValue());
                    }
                    catch (Exception e) {
                        System.out.println("undeleteRecord: failed to go to record no " + recNo + " Error:" + e);
                    }
                    try {
                        if (!this._deleteFlag.isDeleted()) {
                            System.out.println("undeleteRecord: can't undelete record " + recNo + " it's not deleted");
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        System.out.println("undeleteRecord: unable to determine if record" + recNo + " is undeletable Error:" + e);
                    }
                    continue;
                }
                try {
                    this._deleteFlag.set(false);
                    this._dataFile.update();
                    continue;
                }
                catch (Exception eMsg) {
                    System.out.println("ERROR undeleteRecord(" + this.fileNameTxt.getText() + ") : An error occurred when undeleting record id=" + recNo);
                    System.out.println(eMsg.getMessage());
                    eMsg.printStackTrace(System.out);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            try {
                this.objectTable.clearSelection();
                this.reloadFile();
            }
            catch (Exception e) {
                System.out.println("ERROR undeleteRecord(" + this.fileNameTxt.getText() + ") : An error occurred when reloading file");
                System.out.println(e.getMessage());
                e.printStackTrace(System.out);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteRecord() {
        int[] rows = this.objectTable.getSelectedRows();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] == -1) {
                    JOptionPane.showMessageDialog(this, "Invalid row selected");
                    return;
                }
                String objId = this.objectTable.getCell(rows[i], 1).toString();
                if (!this.findObject(TAG_ID, objId)) {
                    System.out.println("deleteRecord(" + this.fileNameTxt.getText() + " width id=" + objId + " was not found!");
                    return;
                }
                try {
                    this._deleteFlag.set(true);
                    this._dataFile.update();
                    continue;
                }
                catch (Exception eMsg) {
                    System.out.println("ERROR deleteRecord(" + this.fileNameTxt.getText() + ") : An error occurred when removing record id=" + objId);
                    System.out.println(eMsg.getMessage());
                    eMsg.printStackTrace(System.out);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            try {
                this._dataFile.pack();
                this._dataFile.memoCompress();
                this.fillTable();
            }
            catch (Exception e) {
                System.out.println("ERROR deleteRecord(" + this.fileNameTxt.getText() + ") : An error occurred when updating file");
                System.out.println(e.getMessage());
                e.printStackTrace(System.out);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean findObject(String tag, String key) {
        try {
            this._dataFile.select(tag);
            this._dataFile.top();
            if (this._dataFile.seek(key) != 0) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("findObject(" + this.fileNameTxt.getText() + ") Exception when seeking for record. tag='" + tag + "' key='" + key + "'");
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem mi;
        Object obj = e.getSource();
        if (obj instanceof JMenuItem && "openFile".equals((mi = (JMenuItem)obj).getActionCommand())) {
            this.openFile(new File(mi.getName()));
        }
    }

    protected String getMenuItemname(String pathname) {
        char FILE_SEPARATOR = "/".charAt(0);
        int pathnameLen = pathname.length();
        pathname = pathname.replace('\\', FILE_SEPARATOR);
        if (pathnameLen <= 50) {
            return pathname;
        }
        if (pathname.indexOf("/") == pathname.lastIndexOf("/")) {
            return pathname;
        }
        int ABBREVIATED_PREFIX_LEN = 6;
        int MAX_PATHNAME_LEN = 44;
        int firstFileSeparatorIndex = 0;
        for (int i = pathnameLen - 1; i >= pathnameLen - 44; --i) {
            if (pathname.charAt(i) != FILE_SEPARATOR) continue;
            firstFileSeparatorIndex = i;
        }
        if (firstFileSeparatorIndex > 0) {
            return pathname.substring(0, 3) + ".." + pathname.substring(firstFileSeparatorIndex, pathnameLen);
        }
        return pathname.substring(0, 3) + "../.." + pathname.substring(pathnameLen - 44, pathnameLen);
    }

    public static void main(String[] args) {
        new DBFFileViewer().setVisible(true);
    }

    public class DnDFileDropListener
    implements DropTargetListener {
        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            Transferable t;
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && this.shouldAcceptDrag(t = dtde.getTransferable())) {
                dtde.acceptDrag(3);
                return;
            }
            dtde.rejectDrag();
        }

        protected boolean shouldAcceptDrag(Transferable t) {
            Object flav;
            try {
                flav = t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
            if (flav instanceof List) {
                List files = (List)flav;
                int size = files.size();
                if (size == 0) {
                    return false;
                }
                if (files.get(0) instanceof File) {
                    for (int i = 0; i < size; ++i) {
                        File f = (File)files.get(i);
                        String fileExt = RMAIO.getFileExtension(f.getName());
                        if (fileExt == null || !".dbf".equalsIgnoreCase(fileExt)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object obj;
                Transferable t = dtde.getTransferable();
                int dropAction = dtde.getDropAction();
                dtde.acceptDrop(dropAction);
                if (!this.shouldAcceptDrag(t)) {
                    dtde.rejectDrop();
                    return;
                }
                boolean makeCopy = dropAction == 2;
                try {
                    obj = t.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    dtde.rejectDrop();
                    return;
                }
                catch (IOException e) {
                    dtde.rejectDrop();
                    return;
                }
                List files = (List)obj;
                int size = files.size();
                ArrayList<File> validFiles = new ArrayList<File>();
                for (int i = 0; i < size; ++i) {
                    File f = (File)files.get(i);
                    String fileExt = RMAIO.getFileExtension(f.getName());
                    if (fileExt == null || !".dbf".equalsIgnoreCase(fileExt)) continue;
                    validFiles.add(f);
                }
                if (validFiles.size() == 0) {
                    dtde.rejectDrop();
                    return;
                }
                File[] fArray = new File[validFiles.size()];
                fArray = validFiles.toArray(fArray);
                DBFFileViewer.this.openFile(fArray[0]);
                return;
            }
            dtde.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

