/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.DoubleArrayEnumerator;

public class DoubleArray
implements Cloneable,
Serializable,
AsciiSerializable {
    protected double[] _elementData;
    protected int _elementCount;
    protected int _capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public DoubleArray(int initialCapacity, int capacityIncrement) {
        this._elementData = new double[initialCapacity];
        this._capacityIncrement = capacityIncrement;
    }

    public DoubleArray(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public DoubleArray() {
        this(10);
    }

    public DoubleArray(double[] array) {
        this(array.length);
        System.arraycopy(array, 0, this._elementData, 0, array.length);
        this._elementCount = array.length;
    }

    public final void copyInto(double[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = this._elementData[i];
        }
    }

    public final void trimToSize() {
        int oldCapacity = this._elementData.length;
        if (this._elementCount < oldCapacity) {
            double[] oldData = this._elementData;
            this._elementData = new double[this._elementCount];
            System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this._elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this._elementData.length;
        double[] oldData = this._elementData;
        int n = newCapacity = this._capacityIncrement > 0 ? oldCapacity + this._capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this._elementData = new double[newCapacity];
        System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
    }

    public final void setSize(int newSize) {
        this.setSize(newSize, Double.NEGATIVE_INFINITY);
    }

    public final void setSize(int newSize, double defaultValue) {
        if (newSize > this._elementCount && newSize > this._elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this._elementCount; ++i) {
                this._elementData[i] = defaultValue;
            }
        }
        this._elementCount = newSize;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    private final DoubleArrayEnumerator elements() {
        return new DoubleArrayEnumerator(this);
    }

    public final boolean contains(double elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(double elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(double elem, int index) {
        for (int i = index; i < this._elementCount; ++i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(double elem) {
        return this.lastIndexOf(elem, this._elementCount - 1);
    }

    public final int lastIndexOf(double elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public double get(int index) {
        return this.elementAt(index);
    }

    public final double elementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        try {
            return this._elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final double firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException("No elements in list");
        }
        return this._elementData[0];
    }

    public final double lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException("No elements in list");
        }
        return this._elementData[this._elementCount - 1];
    }

    public final void setElementAt(double obj, int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        this._elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this._elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, j);
        }
        --this._elementCount;
        this._elementData[this._elementCount] = Double.NEGATIVE_INFINITY;
    }

    public final void insertElementAt(double obj, int index) {
        int newcount = this._elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this._elementCount);
        }
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._elementCount - index);
        this._elementData[index] = obj;
        ++this._elementCount;
    }

    public void add(double obj) {
        this.addElement(obj);
    }

    public boolean addAll(DoubleArray dv) {
        double[] a = dv.toArray();
        int numNew = a.length;
        this.ensureCapacity(this._elementCount + numNew);
        System.arraycopy(a, 0, this._elementData, this._elementCount, numNew);
        this._elementCount += numNew;
        return numNew != 0;
    }

    public final void addElement(double obj) {
        int newcount = this._elementCount + 1;
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this._elementData[this._elementCount++] = obj;
    }

    public double[] toArray() {
        double[] result = new double[this._elementCount];
        System.arraycopy(this._elementData, 0, result, 0, this._elementCount);
        return result;
    }

    public boolean remove(double obj) {
        return this.removeElement(obj);
    }

    public final boolean removeElement(double obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeAllElements();
    }

    public final void removeAllElements() {
        for (int i = 0; i < this._elementCount; ++i) {
            this._elementData[i] = Double.NEGATIVE_INFINITY;
        }
        this._elementCount = 0;
    }

    public Object clone() {
        try {
            DoubleArray v = (DoubleArray)super.clone();
            v._elementData = new double[this._elementCount];
            System.arraycopy(this._elementData, 0, v._elementData, 0, this._elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public double getMax() {
        DoubleArrayEnumerator e = this.elements();
        double max = Double.NEGATIVE_INFINITY;
        while (e.hasMoreElements()) {
            max = Math.max(e.nextElement(), max);
        }
        return max;
    }

    public double getMin() {
        DoubleArrayEnumerator e = this.elements();
        double min = Double.POSITIVE_INFINITY;
        while (e.hasMoreElements()) {
            min = Math.min(e.nextElement(), min);
        }
        return min;
    }

    public double elementTotal() {
        DoubleArrayEnumerator e = this.elements();
        double total = 0.0;
        while (e.hasMoreElements()) {
            total += e.nextElement();
        }
        return total;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        DoubleArrayEnumerator e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            double l = e.nextElement();
            String s = l == Double.NEGATIVE_INFINITY ? "" : Double.toString(l);
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleArray)) {
            return false;
        }
        if (this._elementCount != ((DoubleArray)obj)._elementCount) {
            return false;
        }
        for (int i = 0; i < this._elementCount; ++i) {
            if (((DoubleArray)obj)._elementData[i] == this._elementData[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

