/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import rma.swing.RmaTexturePaint;

public class FillPatternFactory {
    public static Paint createFillPattern(int fillType, Color color) {
        BufferedImage bi = new BufferedImage(32, 32, 2);
        Graphics2D g = bi.createGraphics();
        Composite oldAc = g.getComposite();
        g.setComposite(AlphaComposite.Clear);
        g.setColor(Color.white);
        g.fillRect(0, 0, 32, 32);
        g.setComposite(oldAc);
        g.setColor(color);
        g.setStroke(new BasicStroke());
        Rectangle r = new Rectangle(0, 0, 32, 32);
        switch (fillType) {
            case 3: {
                FillPatternFactory.drawBackDiagonalHatch(g);
                break;
            }
            case 4: {
                FillPatternFactory.drawForwardDiagonalHatch(g);
                break;
            }
            case 5: {
                FillPatternFactory.drawCrossHatch(g);
                break;
            }
            case 1: {
                FillPatternFactory.drawHorizontalHatch(g);
                break;
            }
            case 6: {
                FillPatternFactory.drawDiagonalCrossHatch(g);
                break;
            }
            case 2: {
                FillPatternFactory.drawVerticalHatch(g);
                break;
            }
            case 0: {
                FillPatternFactory.drawSolid(g);
            }
        }
        RmaTexturePaint tp = new RmaTexturePaint(bi, r, fillType);
        return tp;
    }

    private static void drawSolid(Graphics g) {
        g.fillRect(0, 0, 32, 32);
    }

    private static void drawHorizontalHatch(Graphics g) {
        g.drawLine(0, 0, 32, 0);
        g.drawLine(0, 8, 32, 8);
        g.drawLine(0, 16, 32, 16);
        g.drawLine(0, 24, 32, 24);
        g.drawLine(0, 32, 32, 32);
    }

    private static void drawVerticalHatch(Graphics g) {
        g.drawLine(0, 0, 0, 32);
        g.drawLine(8, 0, 8, 32);
        g.drawLine(16, 0, 16, 32);
        g.drawLine(24, 0, 24, 32);
        g.drawLine(32, 0, 32, 32);
    }

    private static void drawForwardDiagonalHatch(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.drawLine(0, 0, 0, 0);
        g.drawLine(0, 8, 8, 0);
        g.drawLine(0, 16, 16, 0);
        g.drawLine(0, 24, 24, 0);
        g.drawLine(0, 32, 32, 0);
        g.drawLine(8, 32, 32, 8);
        g.drawLine(16, 32, 32, 16);
        g.drawLine(24, 32, 32, 24);
        g.drawLine(32, 32, 32, 32);
    }

    private static void drawBackDiagonalHatch(Graphics g) {
        g.drawLine(0, 0, 32, 32);
        g.drawLine(0, 8, 24, 32);
        g.drawLine(0, 16, 16, 32);
        g.drawLine(0, 24, 8, 32);
        g.drawLine(8, 0, 32, 24);
        g.drawLine(16, 0, 32, 16);
        g.drawLine(24, 0, 32, 8);
    }

    private static void drawCrossHatch(Graphics g) {
        FillPatternFactory.drawHorizontalHatch(g);
        FillPatternFactory.drawVerticalHatch(g);
    }

    private static void drawDiagonalCrossHatch(Graphics g) {
        FillPatternFactory.drawForwardDiagonalHatch(g);
        FillPatternFactory.drawBackDiagonalHatch(g);
    }
}

