/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.Arrays;

public class FixedWidthFileReader {
    int[] m_columnSizes = null;
    int[] m_columnStartIndexs = null;
    StringBuffer _masterString = new StringBuffer();

    public FixedWidthFileReader() {
    }

    public FixedWidthFileReader(int[] sizes) {
        this.setColumnSizes(sizes);
    }

    public void setColumnSizes(int[] sizes) {
        this.m_columnSizes = sizes;
        this.m_columnStartIndexs = new int[this.m_columnSizes.length];
        Arrays.fill(this.m_columnStartIndexs, 0);
        for (int i = 1; i < this.m_columnSizes.length; ++i) {
            this.m_columnStartIndexs[i] = this.m_columnSizes[i - 1] + this.m_columnStartIndexs[i - 1];
        }
    }

    public int[] getColumnSizes() {
        return this.m_columnSizes;
    }

    public String[] parseLine(String line) {
        if (line == null || this.m_columnSizes == null || this.m_columnSizes.length == 0) {
            return new String[0];
        }
        Object[] values = new String[this.m_columnSizes.length];
        Arrays.fill(values, "");
        boolean finished = false;
        for (int i = 0; !finished && i < values.length; ++i) {
            if (this.m_columnStartIndexs[i] + this.m_columnSizes[i] >= line.length()) {
                values[i] = line.substring(this.m_columnStartIndexs[i], line.length()).trim();
                finished = true;
                continue;
            }
            values[i] = line.substring(this.m_columnStartIndexs[i], this.m_columnStartIndexs[i] + this.m_columnSizes[i]).trim();
        }
        return values;
    }

    public String formatString(String ... values) {
        int i;
        int sumOfColumnLengths = 0;
        this._masterString.setLength(0);
        if (this.m_columnSizes == null) {
            return "";
        }
        for (i = 0; i < this.m_columnSizes.length; ++i) {
            sumOfColumnLengths += this.m_columnSizes[i];
        }
        if (values == null) {
            for (i = 0; i < sumOfColumnLengths; ++i) {
                this._masterString.append(' ');
            }
            return this._masterString.substring(0);
        }
        for (i = 0; i < values.length && i < this.m_columnSizes.length; ++i) {
            StringBuffer sb = new StringBuffer(values[i] != null ? values[i] : "");
            if (sb.length() < this.m_columnSizes[i]) {
                for (int z = sb.length(); z < this.m_columnSizes[i]; ++z) {
                    sb.insert(0, ' ');
                }
            } else if (sb.length() > this.m_columnSizes[i]) {
                sb = new StringBuffer(sb.substring(0, this.m_columnSizes[i]));
            }
            this._masterString.append(sb);
        }
        for (int zz = this._masterString.length(); zz < sumOfColumnLengths; ++zz) {
            this._masterString.append(' ');
        }
        return this._masterString.substring(0);
    }

    public static void main(String[] args) {
        FixedWidthFileReader fwfr = new FixedWidthFileReader();
        fwfr.setColumnSizes(new int[0]);
        String[] values = null;
        String master = null;
        master = fwfr.formatString(null);
        values = fwfr.parseLine("SQ 203.6   454.0");
        master = fwfr.formatString(values);
        values = fwfr.parseLine("XS 129.0   463.8   133.0   463.0   136.2   462.1   139.0   461.2   141.0   460.0");
        master = fwfr.formatString(values);
        values = fwfr.parseLine("XS 129.0   463.8   133.0   463.0   136.2   462.1   139.0   461.2   141.0   460.0   141.0   460.0");
        master = fwfr.formatString(values);
        values = fwfr.parseLine("RH 0.060");
        master = fwfr.formatString(values);
        values = fwfr.parseLine("ST   0.0      24     1.0     1.0     0.0     1.0     0.0");
        master = fwfr.formatString(values);
    }
}

