/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.FloatArrayEnumerator;

public class FloatArray
implements Cloneable,
Serializable,
AsciiSerializable {
    protected float[] _elementData;
    protected int _elementCount;
    protected int _capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public FloatArray(int initialCapacity, int capacityIncrement) {
        this._elementData = new float[initialCapacity];
        this._capacityIncrement = capacityIncrement;
    }

    public FloatArray(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public FloatArray() {
        this(10);
    }

    public FloatArray(float[] array) {
        this(array.length);
        System.arraycopy(array, 0, this._elementData, 0, array.length);
        this._elementCount = array.length;
    }

    public final void copyInto(float[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = this._elementData[i];
        }
    }

    public final void trimToSize() {
        int oldCapacity = this._elementData.length;
        if (this._elementCount < oldCapacity) {
            float[] oldData = this._elementData;
            this._elementData = new float[this._elementCount];
            System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this._elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this._elementData.length;
        float[] oldData = this._elementData;
        int n = newCapacity = this._capacityIncrement > 0 ? oldCapacity + this._capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this._elementData = new float[newCapacity];
        System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
    }

    public final void setSize(int newSize) {
        this.setSize(newSize, Float.NEGATIVE_INFINITY);
    }

    public final void setSize(int newSize, float defaultValue) {
        if (newSize > this._elementCount && newSize > this._elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this._elementCount; ++i) {
                this._elementData[i] = defaultValue;
            }
        }
        this._elementCount = newSize;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    private final FloatArrayEnumerator elements() {
        return new FloatArrayEnumerator(this);
    }

    public final boolean contains(float elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(float elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(float elem, int index) {
        for (int i = index; i < this._elementCount; ++i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(float elem) {
        return this.lastIndexOf(elem, this._elementCount - 1);
    }

    public final int lastIndexOf(float elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public float get(int index) {
        return this.elementAt(index);
    }

    public final float elementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        try {
            return this._elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final float firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException("No elements in list");
        }
        return this._elementData[0];
    }

    public final float lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException("No elements in list");
        }
        return this._elementData[this._elementCount - 1];
    }

    public final void setElementAt(float obj, int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        this._elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this._elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, j);
        }
        --this._elementCount;
        this._elementData[this._elementCount] = Float.NEGATIVE_INFINITY;
    }

    public final void insertElementAt(float obj, int index) {
        int newcount = this._elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this._elementCount);
        }
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._elementCount - index);
        this._elementData[index] = obj;
        ++this._elementCount;
    }

    public void add(float obj) {
        this.addElement(obj);
    }

    public boolean addAll(FloatArray dv) {
        float[] a = dv.toArray();
        int numNew = a.length;
        this.ensureCapacity(this._elementCount + numNew);
        System.arraycopy(a, 0, this._elementData, this._elementCount, numNew);
        this._elementCount += numNew;
        return numNew != 0;
    }

    public final void addElement(float obj) {
        int newcount = this._elementCount + 1;
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this._elementData[this._elementCount++] = obj;
    }

    public float[] toArray() {
        float[] result = new float[this._elementCount];
        System.arraycopy(this._elementData, 0, result, 0, this._elementCount);
        return result;
    }

    public boolean remove(float obj) {
        return this.removeElement(obj);
    }

    public final boolean removeElement(float obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeAllElements();
    }

    public final void removeAllElements() {
        for (int i = 0; i < this._elementCount; ++i) {
            this._elementData[i] = Float.NEGATIVE_INFINITY;
        }
        this._elementCount = 0;
    }

    public Object clone() {
        try {
            FloatArray v = (FloatArray)super.clone();
            v._elementData = new float[this._elementCount];
            System.arraycopy(this._elementData, 0, v._elementData, 0, this._elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public float getMax() {
        FloatArrayEnumerator e = this.elements();
        float max = Float.NEGATIVE_INFINITY;
        while (e.hasMoreElements()) {
            max = Math.max(e.nextElement(), max);
        }
        return max;
    }

    public float getMin() {
        FloatArrayEnumerator e = this.elements();
        float min = Float.POSITIVE_INFINITY;
        while (e.hasMoreElements()) {
            min = Math.min(e.nextElement(), min);
        }
        return min;
    }

    public float elementTotal() {
        FloatArrayEnumerator e = this.elements();
        float total = 0.0f;
        while (e.hasMoreElements()) {
            total += e.nextElement();
        }
        return total;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        FloatArrayEnumerator e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            float l = e.nextElement();
            String s = (double)l == Double.NEGATIVE_INFINITY ? "" : Float.toString(l);
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatArray)) {
            return false;
        }
        if (this._elementCount != ((FloatArray)obj)._elementCount) {
            return false;
        }
        for (int i = 0; i < this._elementCount; ++i) {
            if (((FloatArray)obj)._elementData[i] == this._elementData[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

