/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

public class Format {
    private String _s;

    public Format() {
        this._s = "";
    }

    public Format(String line, int column, int format) {
        this.parse(line, column, format);
    }

    public Format parse(String line, int column, int format) {
        try {
            int start = column * format;
            int end = (column + 1) * format;
            if (end > line.length()) {
                end = line.length();
            }
            this._s = line.substring(start, end);
        }
        catch (Exception e) {
            this._s = "";
        }
        return this;
    }

    public String parseString() {
        return this._s.trim();
    }

    public boolean parseBoolean() {
        boolean val = false;
        String tmp = this._s.trim();
        if (tmp.equalsIgnoreCase("F")) {
            val = false;
        } else if (tmp.equalsIgnoreCase("T")) {
            val = true;
        }
        return val;
    }

    public double parseDouble() {
        return this.parseDouble(0.0);
    }

    public double parseDouble(double defaultVal) {
        double val;
        String tmp = this._s.trim();
        if (tmp.length() == 0) {
            return defaultVal;
        }
        try {
            val = Double.parseDouble(tmp);
        }
        catch (Exception e) {
            val = 0.0;
            System.out.println(e);
        }
        return val;
    }

    public int parseInt() {
        int val;
        String tmp = this._s.trim();
        if (tmp.length() == 0) {
            return 0;
        }
        try {
            val = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            val = 0;
            System.out.println(e);
        }
        return val;
    }

    public short parseShort() {
        short val;
        String tmp = this._s.trim();
        if (tmp.length() == 0) {
            return 0;
        }
        try {
            val = Integer.valueOf(tmp).shortValue();
        }
        catch (Exception e) {
            val = 0;
            System.out.println(e);
        }
        return val;
    }
}

