/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.IntArrayEnumerator;
import rma.util.IntVector;

public class IntArray
implements Cloneable,
Serializable,
AsciiSerializable {
    protected int[] _elementData;
    protected int _elementCount;
    protected int _capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public IntArray(int initialCapacity, int capacityIncrement) {
        this._elementData = new int[initialCapacity];
        this._capacityIncrement = capacityIncrement;
    }

    public IntArray(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IntArray() {
        this(10);
    }

    public IntArray(int[] array) {
        this(array.length);
        System.arraycopy(array, 0, this._elementData, 0, array.length);
        this._elementCount = array.length;
    }

    public boolean addAll(int[] array) {
        int numNew = array.length;
        this.ensureCapacityHelper(this._elementCount + numNew);
        for (int i = 0; i < numNew; ++i) {
            this._elementData[this._elementCount++] = array[i];
        }
        return numNew != 0;
    }

    public boolean addAll(IntVector iv) {
        int numNew = iv.size();
        this.ensureCapacityHelper(this._elementCount + numNew);
        for (int i = 0; i < numNew; ++i) {
            this._elementData[this._elementCount++] = iv.get(i);
        }
        return numNew != 0;
    }

    public int[] toArray() {
        int[] array = new int[this._elementCount];
        System.arraycopy(this._elementData, 0, array, 0, this._elementCount);
        return array;
    }

    public final void copyInto(int[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = this._elementData[i];
        }
    }

    public final void copyInto(Integer[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = new Integer(this._elementData[i]);
        }
    }

    public final void trimToSize() {
        int oldCapacity = this._elementData.length;
        if (this._elementCount < oldCapacity) {
            int[] oldData = this._elementData;
            this._elementData = new int[this._elementCount];
            System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this._elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this._elementData.length;
        int[] oldData = this._elementData;
        int n = newCapacity = this._capacityIncrement > 0 ? oldCapacity + this._capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this._elementData = new int[newCapacity];
        System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this._elementCount && newSize > this._elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this._elementCount; ++i) {
                this._elementData[i] = Integer.MIN_VALUE;
            }
        }
        this._elementCount = newSize;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    private final IntArrayEnumerator elements() {
        return new IntArrayEnumerator(this);
    }

    public final boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(int elem, int index) {
        for (int i = index; i < this._elementCount; ++i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(int elem) {
        return this.lastIndexOf(elem, this._elementCount - 1);
    }

    public final int lastIndexOf(int elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int get(int index) {
        return this.elementAt(index);
    }

    public final int elementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        try {
            return this._elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final int firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[0];
    }

    public final int lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[this._elementCount - 1];
    }

    public final int removeLastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        int rv = this._elementData[this._elementCount - 1];
        --this._elementCount;
        return rv;
    }

    public final void setElementAt(int obj, int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        this._elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this._elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, j);
        }
        --this._elementCount;
        this._elementData[this._elementCount] = Integer.MIN_VALUE;
    }

    public final void insertElementAt(int obj, int index) {
        int newcount = this._elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this._elementCount);
        }
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._elementCount - index);
        this._elementData[index] = obj;
        ++this._elementCount;
    }

    public void add(int obj) {
        this.addElement(obj);
    }

    public final void addElement(int obj) {
        int newcount = this._elementCount + 1;
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this._elementData[this._elementCount++] = obj;
    }

    public boolean remove(int obj) {
        return this.removeElement(obj);
    }

    public int removeAll(int[] objs) {
        int removed = 0;
        if (objs == null) {
            return 0;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!this.remove(objs[i])) continue;
            ++removed;
        }
        return removed;
    }

    public final boolean removeElement(int obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeAllElements();
    }

    public final void removeAllElements() {
        for (int i = 0; i < this._elementCount; ++i) {
            this._elementData[i] = Integer.MIN_VALUE;
        }
        this._elementCount = 0;
    }

    public Object clone() {
        try {
            IntVector v = (IntVector)super.clone();
            v._elementData = new int[this._elementCount];
            System.arraycopy(this._elementData, 0, v._elementData, 0, this._elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public long elementTotal() {
        IntArrayEnumerator e = this.elements();
        int total = 0;
        while (e.hasMoreElements()) {
            total += e.nextElement();
        }
        return total;
    }

    public final String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        IntArrayEnumerator e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            int l = e.nextElement();
            String s = l == Integer.MIN_VALUE ? "" : Integer.toString(l);
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

