/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.python.core.PyException;
import org.python.util.PythonInterpreter;
import rma.swing.FontChooser;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAFilenameFilter;

public class JPythonTester
extends JFrame
implements ActionListener {
    JTextArea _scriptText;
    JButton _runScriptButton;
    JMenu _fileMenu;
    Vector _lastMenus = new Vector();
    ReflectMultiListener _listener;

    public JPythonTester() {
        this.setTitle("JPython Tester");
        this.setDefaultCloseOperation(0);
        this.setLocation(100, 100);
        this._listener = new ReflectMultiListener();
        this.getContentPane().setLayout(new GridBagLayout());
        this._scriptText = new JTextArea(20, 80);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)new JScrollPane(this._scriptText), gbc);
        this._runScriptButton = new JButton("Execute");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._runScriptButton, gbc);
        this._runScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPythonTester.runScript(JPythonTester.this._scriptText.getText());
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this._fileMenu = new JMenu("File");
        this._fileMenu.setMnemonic('F');
        menuBar.add(this._fileMenu);
        JMenuItem menuItem = new JMenuItem("Open", 48);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "openFile"));
        this._fileMenu.add(menuItem);
        menuItem = new JMenuItem("Save", 83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "saveFile"));
        this._fileMenu.add(menuItem);
        this._fileMenu.addSeparator();
        menuItem = new JMenuItem("Exit", 120);
        menuItem.addActionListener(this._listener.add(this, menuItem, "exitApp"));
        this._fileMenu.add(menuItem);
        JMenu menu = new JMenu("Edit");
        menuBar.add(menu);
        menuItem = new JMenuItem("Cut", 84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "cut"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Copy", 67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "copy"));
        menu.add(menuItem);
        menuItem = new JMenuItem("Paste", 80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "paste"));
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Select All", 65);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectAll"));
        menu.add(menuItem);
        menu = new JMenu("Format");
        menuItem = new JMenuItem("Font", 70);
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectFont"));
        menu.add(menuItem);
        JMenu menu2 = new JMenu("Colors");
        menu2.setMnemonic('C');
        menu.add(menu2);
        menuItem = new JMenuItem("Foreground");
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectForeground"));
        menu2.add(menuItem);
        menuItem = new JMenuItem("Background");
        menuItem.addActionListener(this._listener.add(this, menuItem, "selectBackground"));
        menu2.add(menuItem);
        menuBar.add(menu);
        Object userDir = System.getProperty("user.home");
        if (userDir == null) {
            return;
        }
        userDir = (String)userDir + File.separator + "jpythonTester.props";
        this._fileMenu.addSeparator();
        File f = new File((String)userDir);
        try {
            if (f.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    menuItem = this.addFileMenu(line);
                    if (menuItem == null) break;
                    this._lastMenus.add(menuItem);
                }
                reader.close();
                this.updateFileMenu();
            }
        }
        catch (Exception e) {
            System.out.println("buildMenus: error opening/reading " + (String)userDir + " Error:" + e);
            return;
        }
        this.setJMenuBar(menuBar);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JPythonTester.this.exitApp();
            }
        });
    }

    private JMenuItem addFileMenu(String filename) {
        if (this._lastMenus.size() >= 5) {
            return null;
        }
        JMenuItem menuItem = new JMenuItem(filename);
        menuItem.setActionCommand("openFile");
        menuItem.addActionListener(this);
        return menuItem;
    }

    private void updateFileMenu() {
        JMenuItem mi;
        int i;
        int cnt = this._fileMenu.getMenuComponentCount();
        for (i = 0; i < this._lastMenus.size(); ++i) {
            mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null) {
                return;
            }
            this._fileMenu.remove(mi);
        }
        if (this._lastMenus.size() > 5) {
            this._lastMenus.setSize(5);
        }
        for (i = 0; i < this._lastMenus.size(); ++i) {
            mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null) continue;
            this._fileMenu.add(mi);
        }
    }

    public void openFile() {
        JFileChooser chooser = new JFileChooser(new File("."));
        chooser.setFileFilter(new RMAFilenameFilter("py", "JPython files"));
        int rv = chooser.showOpenDialog(this);
        if (rv != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        String path = f.getAbsolutePath();
        String s = JPythonTester.readFile(path);
        if (s != null) {
            this._scriptText.setText(s);
        } else {
            this._scriptText.setText("");
        }
        this._scriptText.setCaretPosition(0);
        this.addAMenu(path);
    }

    void addAMenu(String path) {
        int foundPos = -1;
        for (int i = 0; i < this._lastMenus.size(); ++i) {
            JMenuItem mi = (JMenuItem)this._lastMenus.get(i);
            if (mi == null || !mi.getText().equals(path)) continue;
            foundPos = i;
            break;
        }
        if (foundPos == -1) {
            this._lastMenus.add(0, this.addFileMenu(path));
        } else {
            Object obj = this._lastMenus.remove(foundPos);
            this._lastMenus.add(0, obj);
        }
        if (this._lastMenus.size() > 5) {
            this._lastMenus.setSize(5);
        }
        this.updateFileMenu();
    }

    private void saveLastFile() {
        Object userDir = System.getProperty("user.home");
        if (userDir == null) {
            return;
        }
        userDir = (String)userDir + File.separator + "jpythonTester.props";
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter((String)userDir));
            for (int i = 0; i < this._lastMenus.size(); ++i) {
                JMenuItem mi = (JMenuItem)this._lastMenus.get(i);
                if (mi == null) continue;
                writer.write(mi.getText());
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("saveLastFile: error opening/writing " + (String)userDir + " Error:" + e);
        }
    }

    public void saveFile() {
        JFileChooser chooser = new JFileChooser(new File("."));
        chooser.setFileFilter(new RMAFilenameFilter("py", "JPython files"));
        int rv = chooser.showSaveDialog(this);
        if (rv != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        String path = f.getAbsolutePath();
        if (!path.endsWith(".py")) {
            path = path.concat(".py");
        }
        this.saveFile(path);
        this.addAMenu(path);
    }

    static void runScript(String script) {
        PythonInterpreter _interp = new PythonInterpreter();
        _interp.exec("import sys");
        try {
            _interp.exec(script);
        }
        catch (PyException pye) {
            System.out.println("runScript.execute:Error in script " + pye);
        }
    }

    public void saveFile(String fileName) {
        if (fileName == null) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(this._scriptText.getText());
            writer.newLine();
            writer.close();
        }
        catch (IOException ioe) {
            System.out.println("saveFile: error saving " + fileName + " Error:" + ioe);
            JOptionPane.showMessageDialog(this, "error saving " + fileName + "\nError:" + ioe, "Error", 0);
        }
    }

    static String readFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        System.out.println("reading " + fileName);
        StringBuffer buf = new StringBuffer(100);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("readFile: error saving " + fileName + " Error:" + ioe);
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem mi;
        Object obj = e.getSource();
        if (obj instanceof JMenuItem && "openFile".equals((mi = (JMenuItem)obj).getActionCommand())) {
            String s = JPythonTester.readFile(mi.getText());
            if (s != null) {
                this._scriptText.setText(s);
            } else {
                this._scriptText.setText("");
            }
            this._scriptText.setCaretPosition(0);
        }
    }

    void selectForeground() {
        Color c2 = JColorChooser.showDialog(this, "Select Foreground Color", this._scriptText.getForeground());
        if (c2 == null) {
            return;
        }
        this._scriptText.setForeground(c2);
    }

    void selectBackground() {
        Color c2 = JColorChooser.showDialog(this, "Select Background Color", this._scriptText.getForeground());
        if (c2 == null) {
            return;
        }
        this._scriptText.setBackground(c2);
    }

    void selectFont() {
        FontChooser chooser = new FontChooser((Frame)this, "Select Font", true, this._scriptText.getFont());
        Font f = chooser.getSelectedFont();
        if (f == null) {
            return;
        }
        this._scriptText.setFont(f);
    }

    void cut() {
        this._scriptText.cut();
    }

    void copy() {
        this._scriptText.copy();
    }

    void paste() {
        this._scriptText.paste();
    }

    void selectAll() {
        this._scriptText.selectAll();
    }

    public void exitApp() {
        this.saveLastFile();
        this.setVisible(false);
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            JPythonTester jPythonTester1 = new JPythonTester();
            jPythonTester1.setVisible(true);
        } else {
            String s = JPythonTester.readFile(args[0]);
            if (s != null) {
                JPythonTester.runScript(s);
            }
        }
    }
}

