/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class JTreeContentHandler
extends DefaultHandler {
    private Locator locator;
    private Map namespaceMappings;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode current;

    public JTreeContentHandler(DefaultTreeModel treeModel, DefaultMutableTreeNode base) {
        this.treeModel = treeModel;
        this.current = base;
        this.namespaceMappings = new HashMap();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        DefaultMutableTreeNode pi = new DefaultMutableTreeNode("PI (target = '" + target + "', data = '" + data + "')");
        this.current.add(pi);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.namespaceMappings.put(uri, prefix);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        for (String uri : this.namespaceMappings.keySet()) {
            String thisPrefix = (String)this.namespaceMappings.get(uri);
            if (!prefix.equals(thisPrefix)) continue;
            this.namespaceMappings.remove(uri);
            break;
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.length() == 0) {
            localName = qName;
        }
        DefaultMutableTreeNode element = new DefaultMutableTreeNode("Element: " + localName);
        this.current.add(element);
        this.current = element;
        if (namespaceURI.length() > 0) {
            String prefix = (String)this.namespaceMappings.get(namespaceURI);
            if (prefix.equals("")) {
                prefix = "[None]";
            }
            DefaultMutableTreeNode namespace = new DefaultMutableTreeNode("Namespace: prefix = '" + prefix + "', URI = '" + namespaceURI + "'");
            this.current.add(namespace);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String aName = atts.getLocalName(i);
            if (aName.length() == 0) {
                aName = atts.getQName(i);
            }
            DefaultMutableTreeNode attribute = new DefaultMutableTreeNode("Attribute (name = '" + aName + "', value = '" + atts.getValue(i) + "')");
            String attURI = atts.getURI(i);
            if (attURI.length() > 0) {
                String attPrefix = (String)this.namespaceMappings.get(namespaceURI);
                if (attPrefix.equals("")) {
                    attPrefix = "[None]";
                }
                DefaultMutableTreeNode attNamespace = new DefaultMutableTreeNode("Namespace: prefix = '" + attPrefix + "', URI = '" + attURI + "'");
                attribute.add(attNamespace);
            }
            this.current.add(attribute);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.current = (DefaultMutableTreeNode)this.current.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length == 0) {
            return;
        }
        String s = new String(ch, start, length);
        DefaultMutableTreeNode data = new DefaultMutableTreeNode("Character Data: '" + s + "'");
        this.current.add(data);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        DefaultMutableTreeNode skipped = new DefaultMutableTreeNode("Skipped Entity: '" + name + "'");
        this.current.add(skipped);
    }
}

