/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaColor;
import rma.util.ColorContour;
import rma.util.RMAUtil;
import rma.util.SingleColorContour;
import rma.xml.adapters.XmlColorAdapter;

@XmlRootElement(name="LinearColorContour")
@XmlAccessorType(value=XmlAccessType.NONE)
public class LinearColorContour
extends ColorContour
implements Cloneable,
Serializable,
AsciiSerializable,
SingleColorContour {
    protected int _red = 0;
    protected int _green = 0;
    protected int _blue = 64;
    protected int _255MinusRed = 255 - this._red;
    protected int _255MinusGreen = 255 - this._green;
    protected int _255MinusBlue = 255 - this._blue;
    @XmlElement(name="reversed")
    protected boolean _reversed;
    @XmlElement(name="color")
    @XmlJavaTypeAdapter(value=XmlColorAdapter.class)
    protected Color _color = new Color(this._red, this._green, this._blue);

    @Override
    protected void read0(String type, String param, BufferedReader input) throws IOException {
        if (type.compareTo("LinearColor") == 0) {
            Color color = null;
            try {
                int rgb = Integer.parseInt(param);
                color = new Color(rgb);
            }
            catch (Exception e) {
                color = RmaColor.parseColorString(param);
            }
            this.setColor(color);
        }
    }

    @Override
    public void write(BufferedWriter output) throws IOException {
        super.write(output);
        output.write("LinearColor=" + this.getColor().getRGB());
        output.newLine();
    }

    @Override
    public Map getAttributes(Map map) {
        super.getAttributes(map);
        map.put("LinearColor", RmaColor.color2String(this.getColor(), true));
        return map;
    }

    @Override
    protected void setAttributes(Map attributes) {
        super.setAttributes(attributes);
        Object obj = attributes.get("LinearColor");
        Color clr = RmaColor.parseColorString((String)obj);
        if (clr != null) {
            this.setColor(clr);
        }
    }

    public void setReverse(boolean reversed) {
        this._reversed = reversed;
    }

    public boolean isReversed() {
        return this._reversed;
    }

    @Override
    public void setColor(Color c2) {
        this._color = c2;
        this._red = this._color.getRed();
        this._255MinusRed = 255 - this._red;
        this._green = this._color.getGreen();
        this._255MinusGreen = 255 - this._green;
        this._blue = this._color.getBlue();
        this._255MinusBlue = 255 - this._blue;
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void addExtras(JPanel panel, Observer observer) {
        panel.removeAll();
        panel.setLayout(new GridBagLayout());
        JLabel jLabelColor = new JLabel();
        jLabelColor.setText("Color");
        jLabelColor.setHorizontalAlignment(4);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)jLabelColor, gbc);
        JButton jButtonColor = new JButton();
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 2, 0, 2);
        panel.add((Component)jButtonColor, gbc);
        JCheckBox reversedCheck = new JCheckBox("Reversed");
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 2, 0, 2);
        panel.add((Component)reversedCheck, gbc);
        if (this._color != null) {
            jButtonColor.setIcon(this.getColorIcon(this._color));
        }
        reversedCheck.setSelected(this._reversed);
        ColorContourObserverableListener alobs = new ColorContourObserverableListener(jButtonColor, panel, reversedCheck);
        jButtonColor.addActionListener(alobs);
        reversedCheck.addActionListener(alobs);
        alobs.addObserver(observer);
    }

    protected ImageIcon getColorIcon(Color c2) {
        int w = 12;
        int h = 12;
        int rgb = c2.getRGB();
        int[] pix = new int[h * w];
        for (int ii = 0; ii < pix.length; ++ii) {
            pix[ii] = rgb;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        ImageIcon imgIcon = new ImageIcon(img);
        return imgIcon;
    }

    @Override
    protected double[] getRGB0(double val, double min, double max) {
        double[] rgb = new double[3];
        this.getRGB0(rgb, val, min, max);
        return rgb;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double min, double max) {
        double maxMinusMin;
        double valMinusMin;
        if (this._reversed) {
            valMinusMin = val - max;
            maxMinusMin = min - max;
        } else {
            valMinusMin = val - min;
            maxMinusMin = max - min;
        }
        rgb[0] = (double)this._red + (double)this._255MinusRed / maxMinusMin * valMinusMin;
        rgb[1] = (double)this._green + (double)this._255MinusGreen / maxMinusMin * valMinusMin;
        rgb[2] = (double)this._blue + (double)this._255MinusBlue / maxMinusMin * valMinusMin;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public class ColorContourObserverableListener
    extends Observable
    implements ActionListener {
        JButton _jButtonColor;
        JPanel _panel;
        private JCheckBox _reversedCheck;

        public ColorContourObserverableListener(JButton jButtonColor, JPanel panel, JCheckBox reversedCheck) {
            this._jButtonColor = jButtonColor;
            this._panel = panel;
            this._reversedCheck = reversedCheck;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this._jButtonColor) {
                Color oldColor = LinearColorContour.this.getColor();
                Color newColor = RMAUtil.colorChooser(this._panel, oldColor);
                this._jButtonColor.setIcon(LinearColorContour.this.getColorIcon(newColor));
                LinearColorContour.this.setColor(newColor);
            } else {
                LinearColorContour.this.setReverse(this._reversedCheck.isSelected());
            }
            this.setChanged();
            this.notifyObservers(LinearColorContour.this);
        }
    }
}

