/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.VectorEnumerator;

public class LongVector
implements Cloneable,
Serializable,
AsciiSerializable {
    protected long[] elementData;
    protected int elementCount;
    protected int capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public LongVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new long[initialCapacity];
        this.capacityIncrement = capacityIncrement;
    }

    public LongVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public LongVector() {
        this(10);
    }

    public final synchronized void copyInto(long[] anArray) {
        int i = this.elementCount;
        while (i-- > 0) {
            anArray[i] = this.elementData[i];
        }
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            long[] oldData = this.elementData;
            this.elementData = new long[this.elementCount];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this.elementData.length;
        long[] oldData = this.elementData;
        int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.elementData = new long[newCapacity];
        System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount && newSize > this.elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this.elementCount; ++i) {
                this.elementData[i] = Long.MIN_VALUE;
            }
        }
        this.elementCount = newSize;
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    private final synchronized VectorEnumerator elements() {
        return new VectorEnumerator(this);
    }

    public final boolean contains(long elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(long elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(long elem, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(long elem) {
        return this.lastIndexOf(elem, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(long elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public long get(int index) {
        return this.elementAt(index);
    }

    public final synchronized long elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final synchronized long firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final synchronized long lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final synchronized void setElementAt(long obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        this.elementData[index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, j);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = Long.MIN_VALUE;
    }

    public final synchronized void insertElementAt(long obj, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.elementCount - index);
        this.elementData[index] = obj;
        ++this.elementCount;
    }

    public void add(long obj) {
        this.addElement(obj);
    }

    public final synchronized void addElement(long obj) {
        int newcount = this.elementCount + 1;
        if (newcount > this.elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this.elementData[this.elementCount++] = obj;
    }

    public synchronized boolean addAll(long[] array) {
        int numNew = array.length;
        this.ensureCapacityHelper(this.elementCount + numNew);
        for (int i = 0; i < numNew; ++i) {
            this.elementData[this.elementCount++] = array[i];
        }
        return numNew != 0;
    }

    public boolean remove(long obj) {
        return this.removeElement(obj);
    }

    public final synchronized boolean removeElement(long obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeAllElements();
    }

    public final synchronized void removeAllElements() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = Long.MIN_VALUE;
        }
        this.elementCount = 0;
    }

    public synchronized Object clone() {
        try {
            LongVector v = (LongVector)super.clone();
            v.elementData = new long[this.elementCount];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        VectorEnumerator e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            long l = e.nextElement();
            String s = l == Long.MIN_VALUE ? "" : Long.toString(l);
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

