/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;

public class MemProgressBar
extends JProgressBar {
    private static final int oneMb = 0x100000;
    private long um = 0x100000L;
    private String umString = "M";
    private Timer timer = null;
    private boolean _warningMode;

    public MemProgressBar() {
        this.updateValues();
        this.createUpdateTimer(3000);
        this.setActive(true);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MemProgressBar.this.setActive(false);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MemProgressBar.this.setActive(true);
            }
        });
        this.setStringPainted(true);
    }

    protected void updateValues() {
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        long totalMemMb = totalMem / this.um;
        long usedMemMb = usedMem / this.um;
        this.setMaximum((int)totalMemMb);
        this.setValue((int)usedMemMb);
        double percentUsed = (double)usedMemMb / (double)totalMemMb;
        if (percentUsed >= 0.9) {
            this.setForeground(Color.RED);
            this._warningMode = true;
        } else if (this._warningMode) {
            this._warningMode = false;
            this.setForeground(UIManager.getColor("ProgressBar.foreground"));
        }
        this.setString(usedMemMb + this.umString + " of " + totalMemMb + this.umString);
    }

    protected void createUpdateTimer(int millis) {
        if (millis <= 0) {
            millis = 1;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = new Timer(millis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemProgressBar.this.updateValues();
            }
        });
        this.timer.setRepeats(true);
    }

    protected void setUpdateTime(int millis) {
        this.timer.setDelay(millis);
    }

    protected int getUpdateTime() {
        return this.timer.getDelay();
    }

    public boolean isActive() {
        return this.timer.isRunning();
    }

    public void setActive(boolean active) {
        if (this.timer != null) {
            if (active && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!active && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }
}

