/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.Vector;

public abstract class ObjectPool {
    int _minSize;
    int _transOut;
    int _maxSize = Integer.MAX_VALUE;
    Vector _objectPool;

    public ObjectPool(int minSize) {
        if (minSize < 1) {
            this._minSize = 1;
        }
        this._minSize = minSize;
        this._objectPool = new Vector(this._minSize);
        this.buildObjects();
        this._transOut = 0;
    }

    public ObjectPool(int minSize, int maxSize) {
        this(minSize);
        this._maxSize = maxSize < this._minSize ? this._minSize + 1 : maxSize;
    }

    private void buildObjects() {
        for (int i = 0; i < this._minSize; ++i) {
            this._objectPool.addElement(this.buildObject());
        }
    }

    protected abstract Object buildObject();

    public synchronized Object getObject() {
        Object obj;
        if (this._transOut >= this._maxSize) {
            while (this._transOut >= this._maxSize) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    System.out.println("getObject: interrupted exception wait for the next available object " + ie);
                }
            }
        }
        if (this._objectPool.size() < 1) {
            obj = this.buildObject();
        } else {
            obj = this._objectPool.elementAt(0);
            if (obj == null) {
                obj = this.buildObject();
            } else {
                this._objectPool.removeElementAt(0);
            }
        }
        ++this._transOut;
        return obj;
    }

    public synchronized void returnObject(Object obj) {
        if (this._objectPool.size() < this._minSize) {
            this._objectPool.addElement(obj);
        } else {
            obj = null;
        }
        this.notifyAll();
        --this._transOut;
    }

    public int size() {
        return this._minSize;
    }

    public void setMaxSize(int max) {
        this._maxSize = max;
        this.notifyAll();
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getObjectOut() {
        return this._transOut;
    }
}

