/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class OxfordCommaStringCollector
implements Collector<CharSequence, ArrayList<CharSequence>, String> {
    private String _delimiter;

    private OxfordCommaStringCollector(String delimiter) {
        this._delimiter = delimiter;
    }

    @Override
    public Supplier<ArrayList<CharSequence>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<CharSequence>, CharSequence> accumulator() {
        return ArrayList::add;
    }

    @Override
    public BinaryOperator<ArrayList<CharSequence>> combiner() {
        return (s1, s2) -> {
            s1.addAll(s2);
            return s1;
        };
    }

    @Override
    public Function<ArrayList<CharSequence>, String> finisher() {
        return sj -> {
            OxfordCommaStringBuilder stringBuilder = new OxfordCommaStringBuilder();
            if (sj.size() == 0) {
                stringBuilder.join("");
            }
            if (sj.size() == 1) {
                stringBuilder.join((CharSequence)sj.get(0));
            } else if (sj.size() == 2) {
                stringBuilder.join((CharSequence)sj.get(0));
                stringBuilder.joinSpaceAndSpaceString((CharSequence)sj.get(1));
            } else {
                for (int i = 0; i < sj.size(); ++i) {
                    if (i < sj.size() - 1) {
                        stringBuilder.joinStringDelimiterSpace((CharSequence)sj.get(i));
                        continue;
                    }
                    stringBuilder.joinAndSpaceString((CharSequence)sj.get(i));
                }
            }
            return stringBuilder.toString();
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return new HashSet<Collector.Characteristics>();
    }

    public static Collector<CharSequence, ?, String> joining(String delimiter) {
        return new OxfordCommaStringCollector(delimiter);
    }

    private class OxfordCommaStringBuilder {
        StringBuilder builder = new StringBuilder();

        private OxfordCommaStringBuilder() {
        }

        void joinAndSpaceString(CharSequence string) {
            this.builder.append("and");
            this.builder.append(" ");
            this.builder.append(string);
        }

        void joinSpaceAndSpaceString(CharSequence string) {
            this.builder.append(" ");
            this.builder.append("and");
            this.builder.append(" ");
            this.builder.append(string);
        }

        void joinStringDelimiterSpace(CharSequence string) {
            this.builder.append(string);
            this.builder.append(OxfordCommaStringCollector.this._delimiter);
            this.builder.append(" ");
        }

        void join(CharSequence string) {
            this.builder.append(string);
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

