/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class PerforceReport {
    private static final String DEPOT = "//hecjavadev/dev/...";
    private boolean _ready;
    private static StringBuffer _output = new StringBuffer("");
    private static boolean _writeOut = true;
    private static Process proc;
    private static ProcessReader _reader;
    private final MessageFormatter _format = new MessageFormatter();

    private PerforceReport(String date, String depot) {
        StringTokenizer token = new StringTokenizer(date, "/- ");
        if (token.countTokens() < 3) {
            System.out.println("Invalid date " + date);
            return;
        }
        String[] depotPaths = new String[]{depot};
        if (depot.contains(File.pathSeparator)) {
            depotPaths = depot.split(File.pathSeparator);
        }
        for (String depotPath : depotPaths) {
            this.runPerforceChangesReport(date, depotPath);
        }
        _reader.stopReader();
        System.exit(0);
    }

    private void runPerforceChangesReport(String date, String depot) {
        String msg;
        this.runCommand("changes -l " + depot + "@" + date + ",#head");
        boolean anError = false;
        while ((msg = this._format.getNextErrorMessage()) != null) {
            System.out.println("ERROR:" + msg);
            anError = true;
        }
        if (anError) {
            _reader.stopReader();
            System.exit(2);
        }
        Vector<String> changeList = new Vector<String>(this._format.getNumMessages());
        while ((msg = this._format.getNextMessage()) != null) {
            if (!msg.startsWith("Change")) continue;
            changeList.add(this.getChangeNumber(msg));
        }
        StringBuffer buf = new StringBuffer(changeList.size() * 3 + 20);
        buf.append("describe -s ");
        for (int i = 0; i < changeList.size(); ++i) {
            buf.append(changeList.get(i));
            buf.append(" ");
        }
        anError = false;
        this.runCommand(buf.toString());
        while ((msg = this._format.getNextErrorMessage()) != null) {
            System.out.println("ERROR:" + msg);
            anError = true;
        }
        if (anError) {
            _reader.stopReader();
            System.exit(2);
        }
        String title = "Depot:  " + depot + "<br>Changes Since " + date;
        System.out.println("<HTML><HEAD><TITLE> " + title + "</TITLE></HEAD>");
        System.out.println("<DIV ALIGN=CENTER");
        System.out.println("<h2><font size=+2>" + title + "</font></h2></DIV>");
        while ((msg = this._format.getNextMessage()) != null) {
            if (msg.startsWith("Change")) {
                System.out.println("<P>");
                System.out.println("<Font Size=+1><U>");
                System.out.println(msg);
                System.out.println("</U></Font>");
            } else if (msg.startsWith("...")) {
                System.out.println("<Font size=+0 Color=blue>");
                System.out.println(msg);
                System.out.println("</Font>");
            } else {
                System.out.println(msg);
            }
            System.out.println("<br>");
        }
        System.out.println("</HTML>");
    }

    public String getChangeNumber(String msg) {
        int idx = msg.indexOf(" ");
        int endidx = msg.indexOf(" ", idx + 1);
        String changeNumber = msg.substring(idx, endidx).trim();
        return changeNumber;
    }

    private boolean messageAfter(String msg, int year, int month, int day) {
        int idx = msg.indexOf(" ");
        idx = msg.indexOf(" ", idx + 1);
        idx = msg.indexOf(" ", idx + 1);
        int endidx = msg.indexOf(" ", idx + 1);
        String msgDate = msg.substring(idx, endidx).trim();
        StringTokenizer token = new StringTokenizer(msgDate, "/");
        int msgyear = Integer.parseInt(token.nextToken());
        int msgmonth = Integer.parseInt(token.nextToken());
        int msgday = Integer.parseInt(token.nextToken());
        if (msgyear >= year) {
            if (msgyear > year) {
                msgmonth += 12;
            }
            if (msgmonth >= month && msgday >= day) {
                return true;
            }
        }
        return false;
    }

    public boolean runCommand(String command) {
        this._ready = false;
        String commandLine = "p4.exe " + command;
        try {
            proc = Runtime.getRuntime().exec(commandLine);
            this._ready = true;
            return this.finishCommand();
        }
        catch (IOException ioe) {
            System.out.println("[CommandTool] (runCommand)\n" + ioe.toString());
            return false;
        }
    }

    public boolean finishCommand() {
        String errors = "";
        String message = "";
        try {
            if (_reader == null) {
                _reader = new ProcessReader(proc);
            } else {
                _reader.setProcess(proc);
                _reader.interrupt();
            }
            int code = proc.waitFor();
            while (!_reader.isFinished()) {
            }
            proc.destroy();
            System.gc();
            return true;
        }
        catch (InterruptedException ie) {
            System.out.println("[CommandTool] (finishCommand)" + System.getProperty("line.separator") + ie.toString());
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: PerforceReport mm/dd/ccyy [depot]");
            System.out.println("Usage: \t where [depot] is the name of the depot. i.e. //hecjavadev/dev/...");
            System.exit(1);
        }
        String depot = DEPOT;
        if (args.length == 2) {
            depot = args[1];
        }
        new PerforceReport(args[0], depot);
    }

    static {
        _reader = null;
    }

    public final class MessageFormatter {
        private ArrayList m_messages = new ArrayList(10);
        private ArrayList m_errorMessages = new ArrayList(10);
        private int m_position = 0;
        private int m_errorPosition = 0;

        MessageFormatter() {
        }

        public void addMessage(String message) {
            this.m_messages.add(message);
        }

        public void addErrorMessage(String message) {
            this.m_errorMessages.add(message);
        }

        public void clearMessages() {
            this.m_messages.clear();
            this.m_position = 0;
            this.m_errorMessages.clear();
            this.m_errorPosition = 0;
        }

        public String getNextMessage() {
            if (this.m_position >= this.m_messages.size()) {
                return null;
            }
            ++this.m_position;
            return (String)this.m_messages.get(this.m_position - 1);
        }

        public int getNumMessages() {
            return this.m_messages.size();
        }

        public String getNextErrorMessage() {
            if (this.m_errorPosition >= this.m_errorMessages.size()) {
                return null;
            }
            ++this.m_errorPosition;
            return (String)this.m_errorMessages.get(this.m_errorPosition - 1);
        }
    }

    public final class ProcessReader
    extends Thread {
        private BufferedReader _in = null;
        private boolean _finished = false;
        private Process _proc = null;
        private boolean _running = true;
        private boolean _ready = false;

        ProcessReader(Process proc) {
            this.setProcess(proc);
            this.start();
        }

        private void setProcess(Process proc) {
            this._proc = proc;
            this._ready = true;
            this._in = new BufferedReader(new InputStreamReader(this._proc.getInputStream()));
        }

        public boolean isFinished() {
            return this._finished;
        }

        public void stopReader() {
            if (_reader != null) {
                PerforceReport._reader._running = false;
                _reader.interrupt();
            }
        }

        @Override
        public void run() {
            while (this._running) {
                if (this._ready) {
                    String line = "";
                    PerforceReport.this._format.clearMessages();
                    try {
                        String tmp = "";
                        while ((line = this._in.readLine()) != null) {
                            PerforceReport.this._format.addMessage(line);
                        }
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println("[ProcessReader] (run) Error reading data from process!" + System.getProperty("line.separator") + ioe.toString());
                        continue;
                    }
                    finally {
                        this._proc = null;
                        this._finished = true;
                        this._ready = false;
                        continue;
                    }
                }
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

