/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import rma.util.WildCardFileFilter;

public class PlugInLoader {
    private static final String MAIN_CLASS_KEY = "MainClass";
    static String MANIFEST_MF = "MANIFEST.MF";
    static String META_INF = "META-INF";
    private static Set<String> _loadedOnce = Collections.synchronizedSet(new HashSet());
    private static Set<String> _checkedOnce = Collections.synchronizedSet(new HashSet());
    private static Logger logger = Logger.getLogger(PlugInLoader.class.getName());

    public static void clearLogControls() {
        _loadedOnce.clear();
        _checkedOnce.clear();
    }

    public static boolean getLogFailureToLoad() {
        return Boolean.getBoolean("PluginLoader.LogFailureToLoad");
    }

    public static void setLogFailureToLoad(boolean logFailureToLoad) {
        System.setProperty("PluginLoader.LogFailureToLoad", Boolean.toString(logFailureToLoad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesPluginExist(String manifestEntry) {
        try {
            List<File> jarFiles = PlugInLoader.getJarFiles(manifestEntry, null);
            for (File jar : jarFiles) {
                List<String> mainClasses = PlugInLoader.getMainClasses(jar, manifestEntry);
                if (mainClasses.isEmpty()) continue;
                logger.log(Level.FINE, "Found plugin, '" + manifestEntry + "' in jar '" + jar.getAbsolutePath() + "' with main classes '" + mainClasses + "'.");
                boolean bl = true;
                return bl;
            }
            if (!_checkedOnce.contains(manifestEntry)) {
                File f = PlugInLoader.getPluginDirectory();
                if (jarFiles.isEmpty()) {
                    logger.log(Level.INFO, "Failed to find plugin, '" + manifestEntry + "', no jar files found in '" + f.getAbsolutePath() + "'.");
                } else {
                    logger.log(Level.INFO, "Failed to find plugin, '" + manifestEntry + "', in '" + f.getAbsolutePath() + "'. Jars in directory: '" + jarFiles.toString() + "'");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            _checkedOnce.add(manifestEntry);
        }
    }

    public static File getPluginDirectory() {
        String pluginDirectory = System.getProperty("PLUGINS");
        if (pluginDirectory == null) {
            pluginDirectory = "jar/ext";
        }
        File f = new File(pluginDirectory);
        return f;
    }

    public static void loadPlugIns(String manifestEntry, Object[] args) {
        PlugInLoader.loadPlugIns(manifestEntry, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugIns(String manifestEntry, Object[] args, Comparator<File> fileSorter) {
        try {
            File f = PlugInLoader.getPluginDirectory();
            List<File> jarFiles = PlugInLoader.getJarFiles(manifestEntry, fileSorter);
            if (!_loadedOnce.contains(manifestEntry)) {
                if (!jarFiles.isEmpty()) {
                    logger.log(Level.FINE, "Found plugin jar files, in '" + f.getAbsolutePath() + "'. Jars in directory: '" + jarFiles.toString() + "'");
                } else if (PlugInLoader.getLogFailureToLoad()) {
                    logger.log(Level.SEVERE, "Failed to find plugin jar files for, '" + manifestEntry + "'. No jar files found in directory, '" + f.getAbsolutePath() + "'.");
                } else {
                    logger.log(Level.FINE, "Failed to find plugin jar files for, '" + manifestEntry + "'. No jar files found in directory, '" + f.getAbsolutePath() + "'.");
                }
            }
            if (!jarFiles.isEmpty()) {
                boolean foundMainClass = false;
                for (File jar : jarFiles) {
                    boolean tf = PlugInLoader.loadPlugIn(jar, manifestEntry, args);
                    if (!tf) continue;
                    foundMainClass = true;
                }
                if (!foundMainClass && !_loadedOnce.contains(manifestEntry)) {
                    if (PlugInLoader.getLogFailureToLoad()) {
                        logger.log(Level.SEVERE, "Failed to find plugin, '" + manifestEntry + "', in directory '" + f.getAbsolutePath() + "'. Jar files: '" + jarFiles + "'.");
                    } else {
                        logger.log(Level.FINE, "Failed to find plugin, '" + manifestEntry + "', in directory '" + f.getAbsolutePath() + "'. Jar files: '" + jarFiles + "'.");
                    }
                }
            }
        }
        finally {
            _loadedOnce.add(manifestEntry);
        }
    }

    private static String[] getPluginDirectories() {
        String pluginDirectory = System.getProperty("PLUGINS");
        if (pluginDirectory == null) {
            pluginDirectory = "jar/ext";
        }
        String[] pluginDirectoryPaths = new String[]{pluginDirectory};
        if (pluginDirectory.contains(File.pathSeparator)) {
            pluginDirectoryPaths = pluginDirectory.split(File.pathSeparator);
        }
        return pluginDirectoryPaths;
    }

    private static List<File> getJarFiles(String manifestEntry, Comparator<File> fileSorter) {
        String[] pluginDirectories = PlugInLoader.getPluginDirectories();
        ArrayList<File> jarList = new ArrayList<File>();
        WildCardFileFilter filter = new WildCardFileFilter("*.jar");
        filter.setAcceptDirectories(false);
        for (String dir : pluginDirectories) {
            File jarF = new File(dir);
            File[] jarfiles = jarF.listFiles(filter);
            if (jarfiles == null || jarfiles.length <= 0) continue;
            jarList.addAll(Arrays.asList(jarfiles));
        }
        if (jarList == null || jarList.isEmpty()) {
            return Collections.emptyList();
        }
        if (fileSorter != null) {
            Collections.sort(jarList, fileSorter);
        }
        return jarList;
    }

    private static boolean loadPlugIn(File jar, String manifestEntry, Object[] args) {
        List<String> mainClasses = PlugInLoader.getMainClasses(jar, manifestEntry);
        if (mainClasses.isEmpty()) {
            return false;
        }
        logger.log(Level.FINE, "In jar, " + jar + ", found plugin, '" + manifestEntry + "' main classes: '" + mainClasses + "'");
        for (String mainClass : mainClasses) {
            PlugInLoader.loadClass(manifestEntry, jar, mainClass, args);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getMainClasses(File jar, String manifestEntry) {
        List<String> mainClasses = Collections.emptyList();
        if (jar != null && jar.isFile()) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(jar));
            }
            catch (FileNotFoundException nfe) {
                logger.log(Level.SEVERE, "ERROR: File not found, " + jar, nfe);
                return mainClasses;
            }
            ZipInputStream zin = null;
            try {
                ZipEntry zipentry;
                zin = new ZipInputStream(in);
                mainClasses = new ArrayList<String>();
                while ((zipentry = zin.getNextEntry()) != null) {
                    String mainClass;
                    if (!zipentry.getName().equalsIgnoreCase(META_INF + "/" + MANIFEST_MF)) continue;
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(zin));
                    while ((mainClass = PlugInLoader.getMainClass(zipentry.getName(), bufferedreader, manifestEntry)) != null) {
                        mainClasses.add(mainClass);
                    }
                }
            }
            catch (Exception ioe) {
                logger.log(Level.SEVERE, "ERROR: unable to read '" + jar + "'.", ioe);
                List<String> list = Collections.emptyList();
                return list;
            }
            finally {
                try {
                    if (zin != null) {
                        zin.close();
                    }
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "ERROR: unable to close '" + jar + "'.", ioe);
                }
            }
        }
        return mainClasses;
    }

    private static String getMainClass(String manifestFile, BufferedReader reader, String manifestEntry) {
        String s1 = null;
        try {
            while ((s1 = reader.readLine()) != null) {
                int idx;
                if (!s1.startsWith(manifestEntry) || (idx = s1.indexOf(":")) <= -1) continue;
                return s1.substring(s1.indexOf(":") + 1).trim();
            }
            return null;
        }
        catch (IOException ioexception) {
            logger.log(Level.SEVERE, "Error reading manifest file, '" + manifestFile + ",.", ioexception);
            return null;
        }
    }

    private static void loadClass(String manifestEntry, File jarFile, String theClass, Object[] argsArray) {
        Class<?> cls;
        if (theClass == null) {
            return;
        }
        try {
            cls = Class.forName(theClass);
        }
        catch (ClassNotFoundException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.SEVERE, "Failed to find class, '" + theClass + "'.", e);
            } else {
                logger.log(Level.SEVERE, "Failed to find class, '" + theClass + "'.");
            }
            logger.log(Level.SEVERE, "Classpath is, '" + System.getProperty("java.class.path") + "'");
            return;
        }
        Class[] argsCls = new Class[]{Object[].class};
        Object[] args = new Object[]{argsArray};
        try {
            Method mainMethod = cls.getMethod("main", argsCls);
            logger.log(Level.INFO, "Loading plugin, '" + manifestEntry + "', from jar: '" + jarFile.getAbsolutePath() + "'.");
            mainMethod.invoke(null, args);
        }
        catch (Exception e1) {
            logger.log(Level.SEVERE, "Error invoking main method for plug-in, '" + manifestEntry + "' for " + theClass, e1);
        }
    }
}

