/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.Enumeration;
import java.util.StringTokenizer;

public class PowerfulTokenizer
implements Enumeration {
    private String sInput;
    private String sDelim;
    private boolean bIncludeDelim = false;
    private StringTokenizer oTokenizer;
    private int iEndQuote = 0;
    private String sPrevToken = "";
    private int iTokenNo = 0;
    private int iTotalTokens = 0;
    private int iTokens = 0;
    private int iLen = 0;
    private boolean trimTokens;

    public PowerfulTokenizer(String str, String sep) {
        this.sInput = str;
        this.sDelim = sep;
        this.iLen = this.sDelim.length();
        this.oTokenizer = new StringTokenizer(str, sep, true);
        this.iTotalTokens = this.countTokens();
    }

    public PowerfulTokenizer(String str, String sep, boolean bIncludeDelim) {
        this.sInput = str;
        this.sDelim = sep;
        this.bIncludeDelim = bIncludeDelim;
        this.iLen = this.sDelim.length();
        this.oTokenizer = new StringTokenizer(str, sep, true);
        this.iTotalTokens = this.countTokens();
    }

    public void setTrimTokens(boolean b) {
        this.trimTokens = b;
    }

    public String nextToken() {
        Object sToken = this.oTokenizer.nextToken();
        if (this.sPrevToken.equals(this.sDelim) && ((String)sToken).equals(this.sDelim)) {
            this.sPrevToken = sToken;
            ++this.iTokenNo;
            return "";
        }
        if (((String)sToken).trim().startsWith("\"") && ((String)sToken).length() == 1) {
            String sNextToken = this.oTokenizer.nextToken();
            while (!sNextToken.trim().endsWith("\"")) {
                sToken = (String)sToken + sNextToken;
                sNextToken = this.oTokenizer.nextToken();
            }
            this.sPrevToken = sToken = (String)sToken + sNextToken;
            ++this.iTokenNo;
            return ((String)sToken).substring(1, ((String)sToken).length() - 1);
        }
        if (((String)sToken).trim().startsWith("\"") && (!((String)sToken).trim().endsWith("\"") || ((String)sToken).trim().endsWith("\"\"")) && this.oTokenizer.hasMoreTokens()) {
            String sNextToken = this.oTokenizer.nextToken();
            while (!sNextToken.trim().endsWith("\"") || sNextToken.trim().endsWith("\"\"")) {
                sToken = (String)sToken + sNextToken;
                if (!this.oTokenizer.hasMoreTokens()) {
                    sNextToken = "";
                    break;
                }
                sNextToken = this.oTokenizer.nextToken();
            }
            sToken = (String)sToken + sNextToken;
        }
        this.sPrevToken = sToken;
        if (this.trimTokens) {
            sToken = ((String)sToken).trim();
        }
        if (((String)sToken).length() > 0) {
            if (((String)sToken).charAt(0) == '\"' && ((String)sToken).charAt(((String)sToken).length() - 1) == '\"') {
                sToken = ((String)sToken).substring(1, ((String)sToken).length() - 1);
            }
            Object sTemp = "";
            int iPrevDblQuote = 0;
            int iDblQuote = ((String)sToken).indexOf("\"\"");
            if (iDblQuote != -1) {
                Object sDummy = sToken;
                while (iDblQuote != -1) {
                    sTemp = ((String)sDummy).substring(0, iDblQuote + 1);
                    sTemp = (String)sTemp + ((String)sDummy).substring(iDblQuote + 2);
                    iPrevDblQuote = iDblQuote;
                    sDummy = sTemp;
                    iDblQuote = ((String)sDummy).indexOf("\"\"", iPrevDblQuote + 1);
                }
                sToken = sTemp;
            }
        }
        if (!this.bIncludeDelim && ((String)sToken).equals(this.sDelim)) {
            sToken = this.nextToken();
        } else {
            ++this.iTokenNo;
        }
        return sToken;
    }

    public boolean hasMoreTokens() {
        if (this.iTotalTokens == 0) {
            this.iTotalTokens = this.countTokens();
        }
        return this.iTokenNo < this.iTotalTokens;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int iActualTokens = this.iTokens = this.oTokenizer.countTokens();
        if (this.iTokens == 0) {
            return 0;
        }
        int[] aiIndex = new int[this.iTokens];
        aiIndex[0] = 0;
        int iIndex = 0;
        int iNextIndex = 0;
        for (int i = 1; i < aiIndex.length && (iIndex = this.sInput.indexOf(this.sDelim, iIndex + 1)) != -1; ++i) {
            while (this.sInput.substring(iIndex - this.iLen, iIndex).equals(this.sDelim) && (iNextIndex = this.sInput.indexOf(this.sDelim, iIndex + 1)) != -1) {
                iIndex = iNextIndex;
            }
            aiIndex[i] = iIndex;
            if (!this.isWithinQuotes(iIndex)) continue;
            if (this.bIncludeDelim) {
                this.iTokens -= 2;
                continue;
            }
            --this.iTokens;
        }
        if (this.bIncludeDelim) {
            return this.iTokens;
        }
        if (!this.bIncludeDelim || this.iTokens == iActualTokens) {
            int iIdx = 0;
            iIdx = this.sInput.indexOf(this.sDelim, iIdx + 1);
            while (iIdx != -1) {
                if (this.sInput.charAt(iIdx - 1) != '\"' || this.sInput.charAt(iIdx + 1) != '\"' || iIdx + 1 + this.iLen > this.sInput.length() || !this.sInput.substring(iIdx + 1, iIdx + 1 + this.iLen).equals(this.sDelim)) {
                    --this.iTokens;
                }
                while (iIdx + 1 < this.sInput.length() && this.sInput.substring(iIdx + 1, iIdx + 1 + this.iLen).equals(this.sDelim)) {
                    iIdx += this.iLen;
                }
                iIdx = this.sInput.indexOf(this.sDelim, iIdx + 1);
            }
        }
        return this.iTokens;
    }

    private boolean isWithinQuotes(int k) {
        int iStartQuote = this.sInput.indexOf("\"", 0);
        if (k < iStartQuote) {
            return false;
        }
        if (!this.bIncludeDelim && this.sInput.charAt(k - 1) == '\"' && this.sInput.charAt(k + 1) == '\"' && k + 1 + this.iLen <= this.sInput.length() && this.sInput.substring(k + 1, k + 1 + this.iLen).equals(this.sDelim)) {
            this.iTokens -= 2;
            return false;
        }
        while (iStartQuote != -1) {
            this.iEndQuote = this.sInput.indexOf("\"", iStartQuote + 1);
            if (k > iStartQuote && k < this.iEndQuote) {
                return true;
            }
            iStartQuote = this.sInput.indexOf("\"", this.iEndQuote + 1);
        }
        return false;
    }

    public static void main(String[] args) {
        String sIn = "hello, Today,,, \"I, am \", going to,,, \"buy, a, book\"";
        PowerfulTokenizer oMT = new PowerfulTokenizer(sIn, ",");
        int iTokens = oMT.countTokens();
        System.out.println("no of tokens = " + iTokens);
        int i = 0;
        while (oMT.hasMoreTokens()) {
            System.out.println("token" + i++ + " = " + oMT.nextToken());
        }
        oMT = new PowerfulTokenizer(sIn, ",", true);
        iTokens = oMT.countTokens();
        System.out.println("no of tokens = " + iTokens);
        i = 0;
        while (oMT.hasMoreTokens()) {
            System.out.println("token" + i++ + " = " + oMT.nextToken());
        }
    }
}

