/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component c2) {
        new PrintUtilities(c2).print();
    }

    public PrintUtilities(Component componentToBePrinted) {
        this.componentToBePrinted = componentToBePrinted;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                System.out.println("Calling PrintJob.print()");
                printJob.print();
                System.out.println("End PrintJob.print()");
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        int response = 1;
        Graphics2D g2 = (Graphics2D)g;
        Dimension d = this.componentToBePrinted.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            response = 1;
        } else {
            PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
            try {
                g2.translate(pf.getImageableX(), pf.getImageableY());
                g2.translate(0.0, (double)(-pageIndex) * pageHeight);
                g2.scale(scale, scale);
                this.componentToBePrinted.paint(g2);
            }
            finally {
                PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
            }
            response = 0;
        }
        return response;
    }

    public static void disableDoubleBuffering(Component c2) {
        RepaintManager currentManager = RepaintManager.currentManager(c2);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c2) {
        RepaintManager currentManager = RepaintManager.currentManager(c2);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

