/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import rma.util.ColorContour;

@XmlRootElement(name="RGBColorContour")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RGBColorContour
extends ColorContour {
    static final double red = 0.0;
    static final double yellow = 0.23;
    static final double green = 0.333;
    static final double cyan = 0.43;
    static final double blue = 0.667;
    static final double magenta = 0.833;
    static double c_strt = 0.7;
    static double c_end = 0.0;

    @Override
    protected double[] getRGB0(double val, double min, double max) {
        double[] rgb = new double[3];
        this.getRGB0(rgb, val, min, max);
        return rgb;
    }

    @Override
    protected void getRGB0(double[] rgb, double val, double min, double max) {
        double hue = c_strt - (c_strt - c_end) * (val - min) / (max - min);
        if (hue >= 0.0 && hue < 0.23) {
            rgb[0] = 255.0;
            rgb[1] = 255.0 * (hue - 0.0) / 0.23;
            rgb[2] = 0.0;
        } else if (hue >= 0.23 && hue < 0.333) {
            rgb[0] = 255.0 * (0.333 - hue) / 0.10300000000000001;
            rgb[1] = 255.0;
            rgb[2] = 0.0;
        } else if (hue >= 0.333 && hue < 0.43) {
            rgb[0] = 0.0;
            rgb[1] = 255.0;
            rgb[2] = 255.0 * (hue - 0.333) / 0.09699999999999998;
        } else if (hue >= 0.43 && hue < 0.667) {
            rgb[0] = 0.0;
            rgb[1] = 255.0 * (0.667 - hue) / 0.23700000000000004;
            rgb[2] = 255.0;
        } else if (hue >= 0.667 && hue < 0.833) {
            rgb[0] = 0.0;
            rgb[1] = 0.0;
            rgb[2] = 255.0 * (0.833 - hue) / 0.16599999999999993;
        } else {
            rgb[0] = 0.0;
            rgb[1] = 0.0;
            rgb[2] = 0.0;
        }
    }
}

