/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class RMAFilenameFilter
extends FileFilter
implements FilenameFilter {
    Hashtable _extensions = new Hashtable(5);
    String _description = "";
    boolean _acceptDirectories = true;

    public RMAFilenameFilter() {
    }

    public RMAFilenameFilter(String extension, String description) {
        this();
        this.addExtension(extension);
        this.setDescription(description);
    }

    public RMAFilenameFilter(String ... extensions) {
        this(extensions, (String)null);
    }

    public RMAFilenameFilter(String[] extensions, String description) {
        this();
        this._extensions = new Hashtable(extensions.length);
        for (int i = extensions.length - 1; i >= 0; --i) {
            this.addExtension(extensions[i]);
        }
        this.setDescription(description);
    }

    public void setAcceptDirectories(boolean b) {
        this._acceptDirectories = b;
    }

    public String toString() {
        if (this._description != null) {
            return this._description;
        }
        return "";
    }

    @Override
    public boolean accept(File dir, String name) {
        if (dir == null || name == null) {
            return false;
        }
        String sDir = dir.getAbsolutePath();
        String filePath = sDir + File.separator + name;
        return this.accept(new File(filePath));
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory() && this._acceptDirectories) {
                return true;
            }
            String extension = RMAFilenameFilter.getExtension(f);
            if (this._extensions.isEmpty() || extension != null && this._extensions.get(extension) != null) {
                return true;
            }
        }
        return false;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void addExtension(String ext) {
        if (this._extensions == null) {
            this._extensions = new Hashtable(5);
        }
        String s = ext.toLowerCase();
        this._extensions.put(s, s);
    }

    public String[] getExtensions() {
        String[] strarray = new String[this._extensions.size()];
        Enumeration e = this._extensions.keys();
        int ii = 0;
        while (e.hasMoreElements()) {
            strarray[ii] = e.nextElement().toString();
            ++ii;
        }
        return strarray;
    }

    public static String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void removeExtension(String ext) {
        if (ext != null) {
            this._extensions.remove(ext.toLowerCase());
        }
    }

    public void removeAllExtensions() {
        this._extensions.clear();
        this.setDescription("");
    }
}

