/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import com.google.common.flogger.FluentLogger;
import hec.data.ParamDouble;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import rma.swing.RmaColor;
import rma.util.RMAConst;

public final class RMAIO {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String ID_SEPARATOR = "-";
    public static final String separator = "/";
    private static int _osType = -1;
    private static int _javaVersion = -1;
    private static String[] _versionStamp = new String[2];
    private static final double[] POW_10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7};
    static final String _padding = "00000000000000000000";
    static final String _dot = ".";
    public static char[] invalidFileNameChars = new char[]{' ', '?', '\\', '/', '*', '\"', '<', '>', '|', '/', '&', ';', '\'', '`', '[', ']', '(', ')', ':', '%', '!', '~'};
    public static String[] intervalNames = new String[]{"SECOND", "MINUTE", "HOUR", "DAY", "WEEK", "MONTH", "YEAR", "DECADE"};
    public static int[] intervalValues = new int[]{1, 60, 3600, 86400, 604800, 2592000, 31557600, 315576000};

    private RMAIO() {
    }

    public static String getRGBString(Color c2) {
        return RmaColor.getRGBString(c2);
    }

    public static String getIPUrl(String inputUrl) {
        if (inputUrl == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(inputUrl);
        }
        catch (URISyntaxException se) {
            System.out.println("getIPUrl: URI Syntax Error on " + inputUrl + " Error:" + se);
            System.out.println("getIPUrl: returning " + inputUrl);
            return inputUrl;
        }
        String host = uri.getHost();
        try {
            InetAddress iaddr = InetAddress.getByName(host);
            String hostAddress = iaddr.getHostAddress();
            String newUrl = "//" + hostAddress + ":" + uri.getPort() + uri.getPath();
            return newUrl;
        }
        catch (Exception e) {
            System.out.println("getIPUrl: Error getting InetAddress for " + host + " Error:" + e);
            System.out.println("getIPUrl: returning " + inputUrl);
            return inputUrl;
        }
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        String valueTrim = value.trim();
        if (valueTrim.equalsIgnoreCase("true") || valueTrim.equalsIgnoreCase("t") || valueTrim.equalsIgnoreCase("on") || valueTrim.equalsIgnoreCase("1") || valueTrim.equalsIgnoreCase("yes")) {
            return true;
        }
        if (valueTrim.equalsIgnoreCase("false") || valueTrim.equalsIgnoreCase("f") || valueTrim.equalsIgnoreCase("off") || valueTrim.equalsIgnoreCase("0") || valueTrim.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultValue;
    }

    public static Color parseRGBString(String rgbStr) {
        return RmaColor.parseRGBString(rgbStr);
    }

    public static Color parseColorString(String colorString) {
        return RmaColor.parseColorString(colorString);
    }

    public static String color2String(Color c2) {
        return RmaColor.color2String(c2);
    }

    public static String getRelativePath(String basePath, String fullPath) {
        return RMAIO.getRelativePath(basePath, fullPath, false, false);
    }

    public static String getRelativePath(String basePath, String fullPath, boolean useDotDot, boolean useDotSlash) {
        String oldFullPath;
        block21: {
            StringBuffer sbBasePath;
            StringBuffer sbFullPath;
            block20: {
                if (basePath == null || basePath.length() == 0) {
                    return fullPath;
                }
                if (fullPath == null || fullPath.length() == 0) {
                    return fullPath;
                }
                if (!RMAIO.isFullPath(fullPath)) {
                    return fullPath;
                }
                oldFullPath = fullPath;
                sbFullPath = new StringBuffer(fullPath.replace('\\', '/'));
                sbBasePath = new StringBuffer(basePath.replace('\\', '/'));
                if (sbBasePath.charAt(sbBasePath.length() - 1) != '/') {
                    sbBasePath.append(separator);
                }
                boolean baseIsWindows = false;
                boolean fullIsWindows = false;
                if (sbFullPath.length() > 1 && (sbFullPath.charAt(1) == ':' || sbFullPath.charAt(0) == '/' && sbFullPath.charAt(1) == '/')) {
                    sbFullPath.setCharAt(0, Character.toUpperCase(sbFullPath.charAt(0)));
                    fullIsWindows = true;
                }
                if (sbBasePath.length() > 1 && (sbBasePath.charAt(1) == ':' || sbBasePath.charAt(0) == '/' && sbBasePath.charAt(1) == '/')) {
                    sbBasePath.setCharAt(0, Character.toUpperCase(sbBasePath.charAt(0)));
                    baseIsWindows = true;
                }
                if (!fullIsWindows || !baseIsWindows) break block20;
                String bpLower = sbBasePath.toString().toLowerCase();
                StringBuffer sbBasePathLower = new StringBuffer(bpLower);
                String fpLower = sbFullPath.toString().toLowerCase();
                StringBuffer sbFullPathLower = new StringBuffer(fpLower);
                if (sbFullPathLower.charAt(0) != sbBasePathLower.charAt(0)) {
                    return oldFullPath;
                }
                if (sbFullPathLower.indexOf(sbBasePathLower.toString()) == 0) {
                    if (sbBasePath.charAt(sbBasePath.length() - 1) == '/') {
                        sbBasePath.deleteCharAt(sbBasePath.length() - 1);
                    }
                    sbFullPath.delete(0, sbBasePath.length() + 1);
                    if (useDotSlash && sbFullPath.indexOf(separator) >= 0) {
                        sbFullPath.insert(0, "./");
                    }
                    return sbFullPath.toString();
                }
                if (!useDotDot) break block21;
                int i = 0;
                StringBuffer sbRelativePath = new StringBuffer("../");
                if (sbBasePathLower.charAt(sbBasePathLower.length() - 1) == '/') {
                    sbBasePathLower.deleteCharAt(sbBasePathLower.length() - 1);
                }
                while (i < 100) {
                    sbBasePathLower.setLength(sbBasePathLower.lastIndexOf(separator));
                    if (sbFullPathLower.indexOf(sbBasePathLower.toString()) == 0) {
                        sbFullPath.delete(0, sbBasePathLower.length() + 1);
                        sbRelativePath.append(sbFullPath.toString());
                        return sbRelativePath.toString();
                    }
                    sbRelativePath.append("../");
                    ++i;
                }
                break block21;
            }
            if (sbFullPath.indexOf(sbBasePath.toString()) == 0) {
                if (sbBasePath.charAt(sbBasePath.length() - 1) == '/') {
                    sbBasePath.deleteCharAt(sbBasePath.length() - 1);
                }
                sbFullPath.delete(0, sbBasePath.length() + 1);
                if (useDotSlash && sbFullPath.indexOf(separator) >= 0) {
                    sbFullPath.insert(0, "./");
                }
                return sbFullPath.toString();
            }
            if (useDotDot) {
                int i = 0;
                StringBuffer sbRelativePath = new StringBuffer("../");
                if (sbBasePath.charAt(sbBasePath.length() - 1) == '/') {
                    sbBasePath.deleteCharAt(sbBasePath.length() - 1);
                }
                while (i < 100 && -1 < sbBasePath.lastIndexOf(separator)) {
                    sbBasePath.setLength(sbBasePath.lastIndexOf(separator));
                    if (sbFullPath.indexOf(sbBasePath.toString()) == 0) {
                        sbFullPath.delete(0, sbBasePath.length() + 1);
                        sbRelativePath.append(sbFullPath.toString());
                        return sbRelativePath.toString();
                    }
                    sbRelativePath.append("../");
                    ++i;
                }
            }
        }
        return oldFullPath;
    }

    public static boolean isRelativePathTo(String basePath, String fullPath) {
        if (fullPath == null) {
            return false;
        }
        String s = RMAIO.getRelativePath(basePath, fullPath);
        if (System.getProperty("os.name").startsWith("Windows")) {
            return !fullPath.equalsIgnoreCase(s);
        }
        return !fullPath.equals(s);
    }

    public static String getType(String line, String delim) {
        int idx = line.indexOf(delim);
        if (idx > -1) {
            return line.substring(0, idx).trim();
        }
        return line.trim();
    }

    public static String getParam(String line, String delim) {
        return RMAIO.getParam(line, delim, true);
    }

    public static String getParam(String line, String delim, boolean trim) {
        String param = "";
        int idx = line.indexOf(delim);
        if (idx > -1) {
            int len = delim.length();
            param = line.substring(idx + len);
            if (trim) {
                param = param.trim();
            }
            if (param.isEmpty()) {
                param = "";
            }
        }
        return param;
    }

    public static int parseInt(String str, int defaultVal) {
        int val = RMAIO.parseInt(str);
        if (val == Integer.MIN_VALUE) {
            val = defaultVal;
        }
        return val;
    }

    public static int parseInt(String str) {
        int val;
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = RMAIO.removeChar(str, ',');
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    public static long parseLong(String str, long defaultVal) {
        long val = RMAIO.parseLong(str);
        if (val == Long.MIN_VALUE) {
            val = defaultVal;
        }
        return val;
    }

    public static long parseLong(String str) {
        long val;
        if (str == null) {
            return Long.MIN_VALUE;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = RMAIO.removeChar(str, ',');
        }
        try {
            val = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            val = Long.MIN_VALUE;
        }
        return val;
    }

    public static float parseFloat(Object obj, float def) {
        if (obj == null) {
            return def;
        }
        return RMAIO.parseFloat(obj.toString(), def);
    }

    public static float parseFloat(String flt, float def) {
        if (flt == null) {
            return def;
        }
        float value = RMAIO.parseFloat(flt);
        if (value == Float.NEGATIVE_INFINITY) {
            return def;
        }
        return value;
    }

    public static float parseFloat(String str) {
        float val;
        if (str == null) {
            return Float.NEGATIVE_INFINITY;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = RMAIO.removeChar(str, ',');
        }
        try {
            val = Float.valueOf(str).floatValue();
        }
        catch (NumberFormatException e) {
            val = Float.NEGATIVE_INFINITY;
        }
        return val;
    }

    public static double parseDouble(String str, double def) {
        double val;
        if (str == null) {
            return def;
        }
        String tmp = str;
        if (tmp.length() == 0) {
            return def;
        }
        int idx = tmp.indexOf(68);
        if (idx >= 0) {
            tmp = tmp.replace('D', 'E');
        }
        if ((idx = tmp.indexOf(100)) >= 0) {
            tmp = tmp.replace('d', 'E');
        }
        if ((idx = tmp.indexOf(44)) >= 0) {
            tmp = RMAIO.removeChar(tmp, ',');
        }
        str = tmp;
        try {
            val = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            val = def;
        }
        return val;
    }

    public static double parseDouble(String str) {
        return RMAIO.parseDouble(str, Double.NEGATIVE_INFINITY);
    }

    public static String toString(int val) {
        if (val != Integer.MIN_VALUE) {
            return Integer.toString(val);
        }
        return "UNDEF_INT";
    }

    public static String toString(float val) {
        if (val != Float.NEGATIVE_INFINITY) {
            return Float.toString(val);
        }
        return "UNDEF_FLOAT";
    }

    public static String toString(double val) {
        if (val != Double.NEGATIVE_INFINITY) {
            return Double.toString(val);
        }
        return "UNDEF_DOUBLE";
    }

    public static String toTable(double val) {
        if (RMAConst.isUndefinedValue(val)) {
            return "";
        }
        return Double.toString(val);
    }

    public static String toTable(int val) {
        if (val != Integer.MIN_VALUE) {
            return Integer.toString(val);
        }
        return "";
    }

    public static String toTable(float val) {
        if (val != Float.NEGATIVE_INFINITY && !Float.isNaN(val)) {
            return Float.toString(val);
        }
        return "";
    }

    public static Object toTableObj(Double val) {
        if (RMAConst.isUndefinedValue(val)) {
            return "";
        }
        return val;
    }

    public static Object toTableObj(Integer val) {
        if (val == Integer.MIN_VALUE) {
            return "";
        }
        return val;
    }

    public static Object toTableObj(Float val) {
        if (val.floatValue() != Float.NEGATIVE_INFINITY && !Float.isNaN(val.floatValue())) {
            return val;
        }
        return "";
    }

    public static void fout(BufferedWriter out, String txt) {
        try {
            out.write(txt, 0, txt.length());
            out.newLine();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static StringBuffer sprintf(int bufSize, Object inputStr) {
        StringBuffer strBuf = new StringBuffer();
        if (inputStr == null) {
            return strBuf;
        }
        int strLength = inputStr.toString().length();
        strBuf.insert(0, inputStr.toString());
        for (int i = 0; i < bufSize - strLength; ++i) {
            strBuf.insert(i, " ");
        }
        strBuf.setLength(bufSize);
        return strBuf;
    }

    public static StringBuffer sprintf(int bufSize, int num) {
        StringBuffer strBuf = RMAIO.sprintf(bufSize, new Integer(num));
        return strBuf;
    }

    public static StringBuffer sprintf(int bufSize, double num) {
        StringBuffer strBuf = RMAIO.sprintf(bufSize, new Double(num));
        return strBuf;
    }

    public static void copyHashToVector(Hashtable ht, Vector vec) {
        if (ht == null || vec == null || ht.isEmpty()) {
            return;
        }
        Enumeration e = ht.keys();
        vec.removeAllElements();
        for (int i = 0; i < ht.size(); ++i) {
            Object obj = ht.get(e.nextElement());
            vec.addElement(obj);
        }
    }

    public static double parseDouble(Object dbl) {
        return RMAIO.parseDouble(dbl, Double.NEGATIVE_INFINITY);
    }

    public static double parseDouble(Object dbl, double def) {
        if (dbl == null) {
            return def;
        }
        if (dbl instanceof ParamDouble) {
            return RMAIO.parseDouble((ParamDouble)dbl, def);
        }
        return RMAIO.parseDouble(dbl.toString(), def);
    }

    public static double parseDouble(ParamDouble dbl) {
        return RMAIO.parseDouble(dbl, Double.NEGATIVE_INFINITY);
    }

    public static double parseDouble(ParamDouble dbl, double def) {
        if (dbl == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return dbl.getValue();
    }

    public static long parseLong(Object longvalue) {
        if (longvalue == null) {
            return Long.MIN_VALUE;
        }
        return RMAIO.parseLong(longvalue.toString());
    }

    public static int parseInt(Object integer) {
        if (integer == null) {
            return Integer.MIN_VALUE;
        }
        return RMAIO.parseInt(integer.toString());
    }

    public static float parseFloat(Object flt) {
        if (flt == null) {
            return Float.NEGATIVE_INFINITY;
        }
        return RMAIO.parseFloat(flt.toString());
    }

    public static double round(double dbl, int precision) {
        double floorValue;
        if (RMAConst.isUndefinedValue(dbl)) {
            return dbl;
        }
        double pow = precision >= 0 && precision < POW_10.length ? POW_10[precision] : Math.pow(10.0, precision);
        double expValue = dbl * pow;
        if (expValue - (floorValue = Math.floor(expValue)) > 0.5) {
            floorValue += 1.0;
        }
        double roundValue = floorValue / pow;
        return roundValue;
    }

    public static String setPrecision(double dbl, int precision) {
        if (precision == 0) {
            return Integer.toString((int)dbl);
        }
        Object format = "##00.";
        for (int i = 0; i < precision; ++i) {
            format = (String)format + "0";
        }
        StringBuffer buff2 = new StringBuffer();
        DecimalFormat df = new DecimalFormat();
        StringBuffer buf = df.format(dbl, buff2, new FieldPosition(precision));
        df.applyLocalizedPattern((String)format);
        return buf.toString();
    }

    public static String setPrecision2(double dbl, int precision) {
        if (RMAConst.isUndefinedValue(dbl) || Double.isNaN(dbl) || dbl == Double.POSITIVE_INFINITY) {
            return "";
        }
        double tens = Math.pow(10.0, precision);
        double scaled = Math.rint(dbl * tens);
        if (RMAConst.isUndefinedValue(dbl = scaled / tens) || Double.isNaN(dbl) || dbl == Double.POSITIVE_INFINITY) {
            return "";
        }
        Object txt = Double.toString(dbl);
        int idx = ((String)txt).indexOf(_dot);
        int length = ((String)txt).length();
        int curprec = length - (idx + 1);
        if (idx == -1) {
            curprec = 0;
        }
        if (((String)txt).indexOf("E") > 0 || ((String)txt).indexOf("e") > 0) {
            return txt;
        }
        if (curprec < precision) {
            int len;
            if (curprec == 0) {
                txt = (String)txt + _dot;
            }
            if ((len = precision - curprec) >= _padding.length()) {
                len = _padding.length() - 1;
            }
            txt = (String)txt + _padding.substring(0, len);
        } else if (curprec > precision) {
            if (precision == 0) {
                txt = ((String)txt).substring(0, idx);
            } else {
                int end = length - (curprec - precision);
                if (end < 0) {
                    end = 0;
                }
                txt = ((String)txt).substring(0, end);
            }
        }
        if (precision == 0 && ((String)txt).equals("-0")) {
            txt = "0";
        }
        return txt;
    }

    public static String setPrecision3(double dbl) {
        int precision = RMAIO.findPrecision(dbl);
        String s = RMAIO.setPrecision2(dbl, precision);
        return RMAIO.removeTrailingChars(s, '0');
    }

    public static int findPrecision(double val) {
        String s = String.valueOf(val);
        int idx = s.indexOf("E");
        int precision = 0;
        if (idx > -1) {
            s = s.substring(idx + 1);
            precision = Math.abs(RMAIO.parseInt(s));
            return precision;
        }
        String value = Double.toString(val);
        int decimal = value.indexOf(_dot);
        precision = decimal >= 0 ? value.trim().length() - decimal - 1 : 0;
        if (precision > 10) {
            if (decimal >= 0) {
                int len = value.length();
                boolean foundNonZero = false;
                int nineCount = 0;
                for (int i = decimal + 1; i < len; ++i) {
                    char ch = value.charAt(i);
                    if (foundNonZero && ch == '0') {
                        precision = i - decimal - 1;
                        break;
                    }
                    if (ch == '9') {
                        if (++nineCount < 4) continue;
                        precision = i - decimal;
                        precision -= nineCount;
                        break;
                    }
                    if (ch == '0') continue;
                    foundNonZero = true;
                    nineCount = 0;
                }
                if (precision > 7) {
                    precision = 5;
                }
            } else {
                precision = 5;
            }
        }
        return precision;
    }

    public static boolean compareArrays(double[] array1, double[] array2, double precision) {
        if (array1 != null && array2 != null) {
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (RMAIO.compareTo(array1[i], array2[i], precision) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static int compareTo(double val, double compareTo, double precision) {
        double diff = compareTo - val;
        if (Math.abs(diff) <= precision) {
            return 0;
        }
        if (val > compareTo) {
            return 1;
        }
        return -1;
    }

    public static long parseDate(String date) {
        return RMAIO.parseDate(date, null);
    }

    public static long parseDate(String date, TimeZone tz) {
        String tmp;
        if (date == null) {
            return Long.MIN_VALUE;
        }
        Object strBegin = RMAIO.getType(date, " ");
        Object strEnd = RMAIO.getParam(date, " ");
        int idx = ((String)strBegin).indexOf(":");
        if (idx >= 0) {
            tmp = ((String)strBegin).substring(0, idx) + ((String)strBegin).substring(idx + 1);
            strBegin = tmp;
        }
        if ((idx = ((String)strEnd).indexOf(":")) >= 0) {
            tmp = ((String)strEnd).substring(0, idx) + ((String)strEnd).substring(idx + 1);
            strEnd = tmp;
        }
        int HHmm = RMAIO.parseInt((String)strBegin);
        Object strHHmm = strBegin;
        Object ddMMMyyyy = strEnd;
        if (HHmm == Integer.MIN_VALUE) {
            HHmm = RMAIO.parseInt((String)strEnd);
            strHHmm = strEnd;
            ddMMMyyyy = strBegin;
            if (HHmm == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
        }
        StringBuffer format = new StringBuffer();
        int len = ((String)strHHmm).length() - 2;
        for (int jj = 0; jj < len; ++jj) {
            format.append("H");
        }
        format.append("mm dd");
        for (int ii = 0; ii < ((String)ddMMMyyyy).length(); ++ii) {
            if (!Character.isLetter(((String)ddMMMyyyy).charAt(ii))) continue;
            format.append("M");
        }
        format.append("yyyy");
        String strFormat = format.toString();
        SimpleDateFormat dateFormat = new SimpleDateFormat(strFormat);
        if (tz != null) {
            dateFormat.setTimeZone(tz);
        }
        String strDate = (String)strHHmm + " " + (String)ddMMMyyyy;
        long time = Long.MIN_VALUE;
        try {
            Date javaDate = dateFormat.parse(strDate);
            time = javaDate.getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return time;
    }

    public static String formatDate(long time, String format) {
        TimeZone timezone = null;
        return RMAIO.formatDate(time, format, timezone);
    }

    public static String formatDate(long time, TimeZone timezone) {
        return RMAIO.formatDate(time, "HHmm ddMMMyyyy", timezone);
    }

    public static String formatDate(long time, String format, String strTimezone) {
        TimeZone timezone = TimeZone.getTimeZone(strTimezone);
        return RMAIO.formatDate(time, format, timezone);
    }

    public static String formatDate(long time, String format, TimeZone timezone) {
        if (time == Long.MIN_VALUE) {
            return "UNDEFINED";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        if (timezone != null) {
            dateFormat.setTimeZone(timezone);
        }
        String str = dateFormat.format(new Date(time));
        return str;
    }

    public static String formatDate(long time) {
        return RMAIO.formatDate(time, "HHmm ddMMMyyyy");
    }

    public static String trimToFilename(String filepath) {
        String name = filepath;
        int ii = name.lastIndexOf(separator);
        if (ii > 0) {
            name = name.substring(ii + 1);
        }
        return name;
    }

    public static String substring(String string, String subString, boolean pre) {
        if (string == null || subString == null) {
            return "";
        }
        int idx = string.indexOf(subString);
        if (idx == -1) {
            return "";
        }
        if (pre) {
            return string.substring(0, idx);
        }
        return string.substring(idx + subString.length());
    }

    public static StringBuffer fillString(int bufSize, char c2) {
        StringBuffer strBuf = new StringBuffer(bufSize);
        for (int i = 0; i < bufSize; ++i) {
            strBuf.append(c2);
        }
        return strBuf;
    }

    public static StringBuffer center(int bufSize, String inputStr) {
        return RMAIO.center(bufSize, inputStr, ' ');
    }

    public static StringBuffer center(int bufSize, String inputStr, char fill) {
        StringBuffer strBuf = new StringBuffer();
        if (inputStr == null) {
            return strBuf;
        }
        int strLength = inputStr.toString().length();
        strBuf.insert(0, inputStr.toString());
        for (int i = 0; i < (bufSize - strLength) / 2; ++i) {
            strBuf.insert(0, fill);
            strBuf.append(fill);
        }
        if (strBuf.length() < bufSize) {
            strBuf.insert(0, fill);
        }
        strBuf.setLength(bufSize);
        return strBuf;
    }

    public static StringBuffer rightJustify2(int bufsize, String inputStr) {
        StringBuffer strBuf = new StringBuffer();
        if (inputStr == null) {
            for (int i = 0; i < bufsize; ++i) {
                strBuf.append(" ");
            }
            return strBuf;
        }
        int strLength = inputStr.length();
        strBuf.insert(0, inputStr);
        int i = 0;
        while (strBuf.length() < bufsize) {
            strBuf.append(" ");
            ++i;
        }
        return strBuf;
    }

    public static StringBuffer rightJustify(int bufsize, String inputStr) {
        StringBuffer strBuf = new StringBuffer();
        if (inputStr == null) {
            return strBuf;
        }
        int strLength = inputStr.toString().length();
        strBuf.insert(0, inputStr.toString());
        for (int i = 0; i < (bufsize - strLength) / 2; ++i) {
            strBuf.append(" ");
        }
        strBuf.setLength(bufsize);
        return strBuf;
    }

    public static StringBuffer leftJustify(int bufsize, String inputStr) {
        return RMAIO.leftJustify(bufsize, inputStr, ' ');
    }

    public static StringBuffer leftJustify(int bufsize, String inputStr, char fill) {
        StringBuffer strBuf = new StringBuffer(bufsize);
        if (inputStr == null) {
            return strBuf;
        }
        strBuf.append(inputStr);
        for (int i = strBuf.length(); i < bufsize; ++i) {
            strBuf.insert(0, fill);
        }
        return strBuf;
    }

    public static String subtractUndef(double param1, double param2, int precission) {
        if (RMAConst.isUndefinedValue(param1) || RMAConst.isUndefinedValue(param2)) {
            return "NA";
        }
        double result = param1 - param2;
        return RMAIO.setPrecision2(result, precission);
    }

    public static String getSystemHomeDirectory() {
        String systemHome = System.getProperty("CWMS_HOME");
        if (systemHome == null) {
            systemHome = System.getProperty("$CWMS_HOME");
        }
        return systemHome;
    }

    public static String getPropertyFilePath(String filename) {
        String tmp = System.getProperty(filename + ".path");
        if (tmp == null) {
            tmp = System.getProperty("properties.path");
            if (tmp != null) {
                return tmp + separator + filename;
            }
            tmp = System.getProperty("CWMS_HOME");
            if (tmp == null) {
                tmp = System.getProperty("$CWMS_HOME");
            }
            if (tmp != null) {
                return tmp + "/config/properties/" + filename;
            }
            if (tmp == null && (tmp = System.getProperty("user.home")) != null) {
                return tmp + "/properties/" + filename;
            }
        } else {
            return tmp;
        }
        return filename;
    }

    public static int getJavaVersion() {
        if (_javaVersion != -1) {
            return _javaVersion;
        }
        String jVer = System.getProperty("java.version");
        System.out.println("Java Version is " + jVer);
        String s = System.getProperty("os.arch");
        if (s.indexOf("64") > 0) {
            ((FluentLogger.Api)LOGGER.atConfig()).log("64-bit Version");
        } else {
            ((FluentLogger.Api)LOGGER.atConfig()).log(s + " Version");
        }
        if (jVer.indexOf("1.8") >= 0) {
            _javaVersion = 6;
        } else if (jVer.startsWith("9.")) {
            _javaVersion = 9;
        } else if (jVer.startsWith("10.")) {
            _javaVersion = 10;
        } else if (jVer.startsWith("11.")) {
            _javaVersion = 11;
        } else if (jVer.startsWith("12.")) {
            _javaVersion = 12;
        } else if (jVer.startsWith("13.")) {
            _javaVersion = 13;
        } else if (jVer.startsWith("14.")) {
            _javaVersion = 14;
        } else if (jVer.startsWith("15.")) {
            _javaVersion = 15;
        } else if (jVer.startsWith("16.")) {
            _javaVersion = 16;
        } else if (jVer.startsWith("17.")) {
            _javaVersion = 17;
        } else if (jVer.startsWith("18.")) {
            _javaVersion = 18;
        } else if (jVer.startsWith("19.")) {
            _javaVersion = 19;
        } else if (jVer.startsWith("20.")) {
            _javaVersion = 20;
        } else if (jVer.startsWith("21.")) {
            _javaVersion = 21;
        } else if (jVer.startsWith("22.")) {
            _javaVersion = 22;
        } else {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).atMostEvery(10, TimeUnit.MINUTES)).log("getJavaVersion: unknown version type " + jVer);
            return -1;
        }
        return _javaVersion;
    }

    public static int getOSType() {
        if (_osType != -1) {
            return _osType;
        }
        String osName = System.getProperty("os.name");
        ((FluentLogger.Api)LOGGER.at(Level.FINE).every(100)).log("OS Name is " + osName);
        if (osName.equalsIgnoreCase("Windows NT") || osName.equals("Windows 2000") || osName.equalsIgnoreCase("Windows XP")) {
            _osType = 0;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            _osType = 2;
        } else if (osName.startsWith("Windows")) {
            _osType = 1;
        } else if (osName.contains("Linux")) {
            _osType = 3;
        } else {
            ((FluentLogger.Api)LOGGER.at(Level.INFO).every(100)).log("getOSType: unknown os type " + osName);
            return -1;
        }
        return _osType;
    }

    public static void postInfo(Component parent, String msg) {
        if (msg == null) {
            return;
        }
        JOptionPane.showConfirmDialog(parent, msg, "Information", -1, 1);
    }

    public static void postError(Component parent, String msg) {
        RMAIO.postError(parent, msg, "Error!");
    }

    public static void postError(Component parent, String msg, String title) {
        if (msg == null) {
            return;
        }
        JOptionPane.showConfirmDialog(parent, msg, title, -1, 0);
    }

    public static void postWarning(Component parent, String msg) {
        if (msg == null) {
            return;
        }
        RMAIO.postWarning(parent, msg, "Warning!");
    }

    public static void postWarning(Component parent, String msg, String title) {
        if (msg == null) {
            return;
        }
        JOptionPane.showConfirmDialog(parent, msg, title, -1, 2);
    }

    public static int postYesNoWarning(Component parent, String msg) {
        return RMAIO.postYesNoWarning(parent, msg, "Warning!");
    }

    public static int postYesNoWarning(Component parent, String msg, String title) {
        if (msg == null) {
            return 0;
        }
        if (title == null) {
            return 0;
        }
        return JOptionPane.showConfirmDialog(parent, msg, title, 0, 2);
    }

    public static int postYesNoMessage(Component parent, String msg, String title) {
        if (msg == null) {
            return 0;
        }
        if (title == null) {
            return 0;
        }
        return JOptionPane.showConfirmDialog(parent, msg, title, 0, 1);
    }

    public static int postYesNoCancelWarning(Component parent, String msg) {
        return RMAIO.postYesNoCancelWarning(parent, msg, "Warning!");
    }

    public static int postYesNoCancelWarning(Component parent, String msg, String title) {
        if (msg == null) {
            return 2;
        }
        if (title == null) {
            return 2;
        }
        return JOptionPane.showConfirmDialog(parent, msg, title, 1, 2);
    }

    public static int postOkCancelWarning(Component parent, String msg) {
        return RMAIO.postOkCancelWarning(parent, msg, "Warning!");
    }

    public static int postOkCancelWarning(Component parent, String msg, String title) {
        if (msg == null) {
            return 2;
        }
        return JOptionPane.showConfirmDialog(parent, msg, title, 2, 2);
    }

    public static String parsePathName(String pathName) {
        return RMAIO.parsePath(pathName, System::getProperty);
    }

    public static String parsePathEnvVars(String pathName) {
        return RMAIO.parsePath(pathName, System::getenv);
    }

    private static String parsePath(String pathName, Function<String, String> substitute) {
        String prop;
        if (pathName == null) {
            return pathName;
        }
        int idx = pathName.indexOf(36);
        if (idx < 0) {
            return pathName;
        }
        int idx2 = (pathName = pathName.replace("\\", separator)).indexOf(separator.charAt(0), idx + 1);
        if (idx2 < 0) {
            idx2 = pathName.length() - 1;
        }
        if ((prop = pathName.substring(idx, idx2)) == null || prop.length() < 1) {
            System.out.println("No env defined for " + prop);
            return pathName;
        }
        String path = substitute.apply(prop);
        if (path == null) {
            prop = pathName.substring(idx + 1, idx2);
            if (prop == null || prop.length() < 1) {
                System.out.println("No env defined for " + prop);
                return pathName;
            }
            path = substitute.apply(prop);
        }
        if (path == null) {
            return pathName;
        }
        StringBuffer newFileName = new StringBuffer(pathName.substring(0, idx));
        newFileName.append(path);
        RMAIO.trimSeparators(newFileName);
        newFileName.append(pathName.substring(idx2));
        return newFileName.toString();
    }

    public static void trimSeparators(StringBuffer sb) {
        int idx = sb.toString().indexOf("//");
        if (idx != -1) {
            sb.deleteCharAt(idx);
            RMAIO.trimSeparators(sb);
        }
    }

    public static String userNameFromUserId(String userId) {
        if (userId == null || userId.length() < 1) {
            return userId;
        }
        int idx = userId.indexOf(ID_SEPARATOR);
        if (idx > -1) {
            return userId.substring(0, idx);
        }
        return userId;
    }

    public static String userNameToFileName(String userName) {
        if (userName == null || userName.length() < 1) {
            return userName;
        }
        StringBuffer temp = new StringBuffer(userName);
        int len = invalidFileNameChars.length;
        block0: for (int i = 0; i < temp.length(); ++i) {
            char c2 = temp.charAt(i);
            for (int j = 0; j < len; ++j) {
                if (c2 != invalidFileNameChars[j]) continue;
                temp.setCharAt(i, '_');
                continue block0;
            }
        }
        return temp.toString();
    }

    public static String replace(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = ((String)str).indexOf(oldChars);
        while (pos > -1) {
            String firstPart = ((String)str).substring(0, pos);
            String lastPart = ((String)str).substring(pos + oldChars.length(), ((String)str).length());
            str = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = ((String)str).indexOf(oldChars, lastPos);
        }
        return str;
    }

    public static String removeNonPrintable(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(s);
        for (int i = buf.length() - 1; i >= 0; --i) {
            if (!Character.isISOControl(buf.charAt(i))) continue;
            buf.deleteCharAt(i);
        }
        return buf.toString();
    }

    public static String removeChar(String s, char c2) {
        if (s == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length());
        buf.setLength(s.length());
        int current = 0;
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur != c2) {
                buf.setCharAt(current++, cur);
                continue;
            }
            ++cnt;
        }
        buf.setLength(buf.length() - cnt);
        return buf.toString();
    }

    public static String removeTrailingChars(String s, char c2) {
        int ii;
        if (s == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s);
        for (ii = s.length() - 1; ii >= 0; --ii) {
            char cur = s.charAt(ii);
            if (cur == c2) continue;
            ++ii;
            break;
        }
        buf.setLength(ii);
        return buf.toString();
    }

    public static int countCharacters(String s, char charToCount) {
        if (s == null) {
            return 0;
        }
        int idx = s.indexOf(charToCount);
        if (idx == -1) {
            return 0;
        }
        int cnt = 1;
        if (++idx >= s.length()) {
            return cnt;
        }
        while ((idx = s.indexOf(charToCount, idx)) > -1) {
            ++cnt;
            if (++idx < s.length()) continue;
            return cnt;
        }
        return cnt;
    }

    public static String trimTrailing(String s, char trailingChar) {
        return RMAIO.trim(s, trailingChar, true);
    }

    public static String trim(String s, char trimChar) {
        return RMAIO.trim(s, trimChar, false);
    }

    public static String trim(String s, char trailingChar, boolean onlyTrailing) {
        if (s == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s);
        for (int i = buf.length() - 1; i >= 0; --i) {
            if (buf.charAt(i) == trailingChar) {
                buf.deleteCharAt(i);
                continue;
            }
            if (onlyTrailing) break;
        }
        return buf.toString();
    }

    public static String removeCharAt(String s, int pos) {
        StringBuffer buf = new StringBuffer(s.length() - 1);
        buf.append(s.substring(0, pos)).append(s.substring(pos + 1));
        return buf.toString();
    }

    public static int getNumChars(String s, char c2) {
        int cnt = 0;
        if (s == null || s.length() < 1) {
            return cnt;
        }
        int idx = -1;
        while ((idx = s.indexOf(c2, idx + 1)) > -1) {
            ++cnt;
        }
        return cnt;
    }

    public static Vector parseStringWithQuotes(String line) {
        int count;
        Vector<String> parts = new Vector<String>();
        int begPos = -1;
        boolean quotes = false;
        for (count = 0; count < line.length(); ++count) {
            char c2 = line.charAt(count);
            if (c2 == ' ') {
                if (begPos == -1) continue;
                if (quotes) {
                    parts.add(RMAIO.removeChar(line.substring(begPos, count), '\"'));
                } else {
                    parts.add(line.substring(begPos, count));
                }
                begPos = -1;
                continue;
            }
            if (c2 == ',') {
                if (begPos == -1) {
                    parts.add("");
                    continue;
                }
                if (quotes) {
                    parts.add(RMAIO.removeChar(line.substring(begPos, count), '\"'));
                } else {
                    parts.add(line.substring(begPos, count));
                }
                begPos = -1;
                continue;
            }
            if (c2 == '\"') {
                int k = line.substring(count + 1).indexOf(34);
                count = k > 0 ? (count += k + 1) : line.length();
                quotes = true;
                continue;
            }
            if (begPos != -1) continue;
            begPos = count;
        }
        if (begPos != -1) {
            if (quotes) {
                parts.add(RMAIO.removeChar(line.substring(begPos, count), '\"'));
            } else {
                parts.add(line.substring(begPos, count));
            }
        }
        return parts;
    }

    public static String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env != null) {
            if (env.containsKey("COMPUTERNAME")) {
                return env.get("COMPUTERNAME");
            }
            if (env.containsKey("HOSTNAME")) {
                return env.get("HOSTNAME");
            }
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException ex) {
            System.out.println("Hostname can not be resolved");
            return "Unknown";
        }
    }

    public static int parseIntervalName(String intvName) {
        int digitFirst = -1;
        int digitLast = -1;
        int letterFirst = -1;
        int letterLast = -1;
        int letterLength = -1;
        int number = -1;
        String intervalName = intvName.toUpperCase();
        if (intervalName != null && intervalName.length() > 0) {
            for (int i = 0; i < intervalName.length(); ++i) {
                if (Character.isDigit(intervalName.charAt(i))) {
                    if (digitFirst == -1) {
                        digitFirst = i;
                    }
                    digitLast = i;
                    continue;
                }
                if (!Character.isLetter(intervalName.charAt(i))) continue;
                if (letterFirst == -1) {
                    letterFirst = i;
                }
                letterLast = i;
            }
            if (digitFirst > -1) {
                try {
                    number = Integer.parseInt(intervalName.substring(digitFirst, digitLast + 1));
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }
            if (letterFirst > -1) {
                letterLength = letterLast - letterFirst + 1;
                String intvStr = intervalName.substring(letterFirst, letterLast + 1);
                for (int j = 0; j < intervalNames.length; ++j) {
                    letterLength = intvStr.length();
                    if (letterLength > intervalNames[j].length()) {
                        letterLength = intervalNames[j].length();
                    }
                    if (!intvStr.substring(0, letterLength).equalsIgnoreCase(intervalNames[j].substring(0, letterLength))) continue;
                    return intervalValues[j] * number;
                }
            }
        }
        return 0;
    }

    public static void endianSwap(short[] array) {
        if (RMAIO.getOSType() == 2) {
            return;
        }
        if (array == null || array.length < 1) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            short s = array[i];
            short t = array[i];
            array[i] = (short)(s << 8 & 0xFF00 | t >> 8 & 0xFF);
        }
    }

    public static String makeAbsolutePath(String basePath, String relPath) {
        if (relPath == null || relPath.equals("")) {
            return relPath;
        }
        if (RMAIO.isFullPath(relPath)) {
            return relPath;
        }
        relPath = relPath.replace('\\', '/');
        basePath = basePath.replace('\\', '/');
        String absPath = basePath + (relPath.charAt(0) == separator.charAt(0) ? "" : separator) + relPath;
        return absPath;
    }

    public static boolean isFullPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return true;
        }
        String tempPath = path.trim();
        if (tempPath.length() == 1) {
            if (tempPath.equals(_dot)) {
                return false;
            }
            return tempPath.equals(separator);
        }
        return (path = path.replace('\\', '/')).substring(0, 1).equals(separator) || path.charAt(1) == ':' && path.length() > 2 && path.substring(2, 3).equals(separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCheckSum(File file) {
        if (file == null) {
            return -1L;
        }
        CRC32 crc = new CRC32();
        FileInputStream crcFin = null;
        try {
            crcFin = new FileInputStream(file);
        }
        catch (Exception e) {
            System.out.println("getCheckSum: Exception on " + file.getPath() + " Error:" + e);
            return -1L;
        }
        byte[] rgb = new byte[1024];
        try {
            int n;
            while ((n = crcFin.read(rgb)) > -1) {
                crc.update(rgb, 0, n);
            }
        }
        catch (IOException ioe) {
            System.out.println("getCheckSum: error reading " + file.getPath() + " Error:" + ioe);
            long l = -1L;
            return l;
        }
        finally {
            try {
                crcFin.close();
            }
            catch (IOException iOException) {}
        }
        return crc.getValue();
    }

    public static double arrayMin(double[] array) {
        double min = Double.MAX_VALUE;
        if (array == null) {
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double arrayMax(double[] array) {
        double max = Double.NEGATIVE_INFINITY;
        if (array == null) {
            return Double.NEGATIVE_INFINITY;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
        }
        return max;
    }

    public static int arrayMin(int[] array) {
        int min = Integer.MAX_VALUE;
        if (array == null) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static int arrayMax(int[] array) {
        int max = Integer.MIN_VALUE;
        if (array == null) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static int indexOf(int[] array, int key) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static String concatPath(String path, String newPart) {
        if (path == null || newPart == null) {
            return path;
        }
        if (!path.endsWith("\\") && !path.endsWith(separator)) {
            String slash = separator;
            if (path.indexOf("\\") > -1) {
                slash = "\\";
            }
            path = path.concat(slash);
        }
        if (newPart.startsWith("\\") || newPart.startsWith(separator)) {
            newPart = newPart.substring(1);
        }
        path = path.concat(newPart);
        return path;
    }

    public static String getFileNameNoExtension(String path) {
        if (path == null) {
            return path;
        }
        int index = (path = RMAIO.getFileFromPath(path)).lastIndexOf(_dot);
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getPathNoExtension(String path) {
        if (path == null) {
            return path;
        }
        int index = path.lastIndexOf(_dot);
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getFileFromPath(String path) {
        if (path == null) {
            return path;
        }
        int index = (path = path.replace('\\', '/')).lastIndexOf(separator);
        if (index < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String getDirectoryFromPath(String path) {
        if (path == null) {
            return path;
        }
        int index = (path = path.replace('\\', separator.charAt(0))).lastIndexOf(separator);
        if (index < 0) {
            return path;
        }
        if (index == path.length() - 1) {
            String shortPath = path.substring(0, index);
            return RMAIO.getDirectoryFromPath(shortPath);
        }
        return path.substring(0, index);
    }

    public static String getFirstDirectoryPart(String path) {
        String firstDirectoryPart = null;
        if (path != null) {
            int idx1 = (path = path.replace('\\', separator.charAt(0))).indexOf(separator.charAt(0));
            if (idx1 == -1) {
                firstDirectoryPart = path;
            } else if (RMAIO.isFullPath(path)) {
                int idx2 = path.indexOf(separator.charAt(0), idx1 + 1);
                if (idx2 == -1) {
                    idx2 = path.length();
                }
                firstDirectoryPart = path.substring(idx1 + 1, idx2);
            } else {
                firstDirectoryPart = path.substring(0, idx1);
            }
        }
        return firstDirectoryPart;
    }

    public static String getFileExtension(String path) {
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(_dot);
        if (index < 0) {
            return "";
        }
        return path.substring(index);
    }

    public static String removeFileExtension(String path) {
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(_dot);
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public static String getHostFromUrl(String url) {
        boolean prependRmi = true;
        return RMAIO.getHostFromUrl(url, prependRmi);
    }

    public static String getHostFromUrl(String url, boolean prependRmi) {
        int idx = url.indexOf("//");
        if (idx != -1) {
            url = url.substring(idx + 2);
        }
        idx = url.indexOf(separator);
        StringBuffer server = new StringBuffer();
        if (idx >= 1) {
            String hostPossiblePort = url.substring(0, idx);
            String port = null;
            String host = null;
            int colonIdx = hostPossiblePort.indexOf(":");
            if (colonIdx != -1) {
                host = hostPossiblePort.substring(0, colonIdx);
                if (host.length() == 0 || host.equals("localhost")) {
                    try {
                        host = System.getProperty("java.rmi.server.hostname", InetAddress.getLocalHost().getHostAddress());
                    }
                    catch (Exception e) {
                        host = null;
                    }
                    if (host == null) {
                        host = "localhost";
                    }
                }
                port = hostPossiblePort.substring(colonIdx + 1);
            }
            if (prependRmi) {
                server.append("rmi:");
            }
            server.append("//");
            server.append(host);
            server.append(":");
            server.append(port);
        }
        if (server.length() == 0) {
            if (prependRmi) {
                server.append("rmi:");
            }
            server.append("//");
            String host = null;
            try {
                host = System.getProperty("java.rmi.server.hostname", InetAddress.getLocalHost().getHostAddress());
            }
            catch (Exception e) {
                host = "localhost";
            }
            server.append(host);
        }
        return server.toString();
    }

    public static boolean pathsEqual(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null && path2 != null || path1 != null && path2 == null) {
            return false;
        }
        if (path1 == path2 || path1.equals(path2)) {
            return true;
        }
        return RMAIO.getOSType() != 2 && (path1 = path1.replace('\\', '/')).equalsIgnoreCase(path2 = path2.replace('\\', '/'));
    }

    public static String getFilePathFromUrl(String url) {
        return RMAIO.getFilePathFromUrl(url, true);
    }

    public static String getFilePathFromUrl(String url, boolean parseEnvironmentVariable) {
        int idx = url.indexOf("//");
        if (idx != -1) {
            url = url.substring(idx + 2);
        }
        if ((idx = url.indexOf(separator)) >= 1) {
            url = url.substring(idx);
        }
        if (parseEnvironmentVariable) {
            url = RMAIO.parsePathName(url);
        } else if (url.indexOf("/$") == 0) {
            url = url.substring(1);
        }
        return url;
    }

    public static String[] getVersionStamp() {
        InputStream is;
        if (_versionStamp[0] == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream("hec/versionStamp")) != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                RMAIO._versionStamp[0] = reader.readLine();
                RMAIO._versionStamp[1] = reader.readLine();
                System.out.println("Version stamp is " + _versionStamp[0] + " date " + _versionStamp[1]);
            }
            catch (IOException ioe) {
                System.out.println("Error reading versionStamp file " + ioe);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Error closing reader " + ex);
                    }
                }
            }
        }
        return (String[])_versionStamp.clone();
    }

    public static Properties getAppVersionProperties(Class clientAppClass) {
        if (clientAppClass == null) {
            return null;
        }
        Package pkg = clientAppClass.getPackage();
        String pkgName = pkg.getName().replace('.', '/');
        String versionFile = pkgName + "/version.properties";
        InputStream in = clientAppClass.getClassLoader().getResourceAsStream(versionFile);
        if (in == null) {
            System.out.println("getAppVersionProperties: failed to find " + versionFile);
            return null;
        }
        Properties appVersionProperties = new Properties();
        try {
            appVersionProperties.load(in);
        }
        catch (IOException ioe) {
            System.out.println("getAppVerionProperties: Error loading " + versionFile + ioe);
        }
        return appVersionProperties;
    }

    public static InputStream getJarVersionsFile(Class<? extends Object> clientAppClass) {
        if (clientAppClass == null) {
            return null;
        }
        Package pkg = clientAppClass.getPackage();
        String pkgName = pkg.getName().replace('.', '/');
        String versionFile = pkgName + "/jarVersions.list";
        InputStream in = clientAppClass.getClassLoader().getResourceAsStream(versionFile);
        return in;
    }

    public static String getBuildMonthYear() {
        RMAIO.getVersionStamp();
        if (_versionStamp[1] == null) {
            return "unknown";
        }
        int idx = _versionStamp[1].indexOf(_dot);
        if (idx == -1) {
            return "unknown";
        }
        String year = _versionStamp[1].substring(0, idx);
        int idx2 = _versionStamp[1].indexOf(_dot, idx + 1);
        if (idx2 == -1) {
            return year;
        }
        String month = _versionStamp[1].substring(idx + 1, idx2);
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(2, RMAIO.parseInt(month) - 1);
        Date dt = gc.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MMMMMMMMM");
        month = sdf.format(dt);
        return month + " " + year;
    }

    public static String getStackTraceString(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public static String toHtmlString(String s) {
        return RMAIO.toHtmlString(s, -1);
    }

    public static String toHtmlString(String s, int maxLineLength) {
        if (s == null) {
            return "";
        }
        StringTokenizer tokenizer = new StringTokenizer(s, "\n");
        StringBuffer buffer = new StringBuffer(s.length() + 12 + tokenizer.countTokens() * 4);
        buffer.append("<html>");
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append("<br>");
        }
        buffer.append("</html>");
        if (maxLineLength > 0) {
            tokenizer = new StringTokenizer(buffer.toString(), " ");
            buffer.setLength(0);
            int curLength = 0;
            while (tokenizer.hasMoreTokens()) {
                String s2 = tokenizer.nextToken();
                if (s2.startsWith("<html>") || s2.startsWith("<br>") || s2.startsWith("</html>")) {
                    buffer.append(s2 + " ");
                    continue;
                }
                if ((curLength += s2.length()) >= maxLineLength) {
                    buffer.append("<br>");
                    curLength = 0;
                }
                buffer.append(s2);
                buffer.append(" ");
            }
        }
        return buffer.toString();
    }

    public static void writeMultiLineString(BufferedWriter writer, String tag, String data) throws IOException {
        if (writer == null || tag == null || data == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(data, "\n");
        while (tokenizer.hasMoreTokens()) {
            writer.write(tag + tokenizer.nextToken());
            writer.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean localFileCopy(String srcFilename, String dstFilename) {
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            try {
                srcChannel = new FileInputStream(srcFilename).getChannel();
            }
            catch (IOException e) {
                System.out.println("Exception opening source file " + srcFilename + " Error:" + e);
                boolean bl = false;
                try {
                    if (srcChannel != null) {
                        srcChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (dstChannel != null) {
                        dstChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            try {
                dstChannel = new FileOutputStream(dstFilename).getChannel();
            }
            catch (IOException e) {
                System.out.println("Exception opening source file " + dstFilename + " Error:" + e);
                boolean bl = false;
                try {
                    if (srcChannel != null) {
                        srcChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (dstChannel != null) {
                        dstChannel.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            long size = srcChannel.size();
            long copyCnt = ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, size);
            boolean bl = copyCnt == size;
            return bl;
        }
        finally {
            try {
                if (srcChannel != null) {
                    srcChannel.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (dstChannel != null) {
                    dstChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String[] getEnvArray() {
        Map<String, String> env = null;
        try {
            env = System.getenv();
        }
        catch (Exception e) {
            System.out.println("getEnvArray:exception on getenv()" + e);
            String[] envArray = new String[]{"HOME=" + System.getProperty("user.home"), "USERNAME=" + System.getProperty("user.name")};
            return envArray;
        }
        String[] envArray = new String[env.size()];
        Set<String> keySet = env.keySet();
        Iterator<String> keys = keySet.iterator();
        int idx = 0;
        while (keys.hasNext()) {
            String key = keys.next();
            String value = env.get(key);
            envArray[idx++] = key + "=" + value;
        }
        return envArray;
    }

    public static String listToString(List list, String separator) {
        if (list == null) {
            return "";
        }
        String sep = separator == null ? "\n" : separator;
        int size = list.size();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (obj != null) {
                buf.append(obj.toString());
            }
            buf.append(sep);
        }
        return buf.toString();
    }

    public static String getShortenedPathname(String pathname, int maxLength) {
        char FILE_SEPARATOR = separator.charAt(0);
        int pathnameLen = pathname.length();
        pathname = pathname.replace('\\', FILE_SEPARATOR);
        if (pathnameLen <= maxLength) {
            return pathname;
        }
        if (pathname.indexOf(separator) == pathname.lastIndexOf(separator)) {
            return pathname;
        }
        int abbreviatedPrefixLen = 6;
        int maxPathnameLen = maxLength - 6;
        int firstFileSeparatorIndex = 0;
        for (int i = pathnameLen - 1; i >= pathnameLen - maxPathnameLen; --i) {
            if (pathname.charAt(i) != FILE_SEPARATOR) continue;
            firstFileSeparatorIndex = i;
        }
        if (firstFileSeparatorIndex > 0) {
            return pathname.substring(0, 3) + ".." + pathname.substring(firstFileSeparatorIndex, pathnameLen);
        }
        return pathname.substring(0, 3) + "../.." + pathname.substring(pathnameLen - maxPathnameLen, pathnameLen);
    }

    public static String copyFileFromResourcesToTemp(String resourcePath) {
        String resource = resourcePath;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        String DEST_FILE = RMAIO.getFileFromPath(resource);
        String resourceFileName = RMAIO.getFileNameNoExtension(DEST_FILE);
        String DEST_DIR = tempDirectory + separator + resourceFileName;
        return RMAIO.copyFileFromResourcesToDirectory(resourcePath, DEST_DIR);
    }

    public static String copyFileFromResourcesToDirectory(String resourcePath, String destinationDir) {
        try {
            boolean wasCreated;
            String resource = resourcePath;
            String DEST_FILE = RMAIO.getFileFromPath(resource);
            String DEST_DIR = destinationDir;
            File f = new File(DEST_DIR + File.separator);
            if (!f.exists() && !(wasCreated = f.mkdirs())) {
                System.out.println("Failed to create directory: " + DEST_DIR + File.separator);
            }
            String DEST = DEST_DIR + File.separator + DEST_FILE;
            InputStream iStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            int numBytesRead = 0;
            BufferedInputStream bufIn = new BufferedInputStream(iStream);
            FileOutputStream fStream = new FileOutputStream(DEST);
            BufferedOutputStream bufOut = new BufferedOutputStream(fStream);
            byte[] byteArray = new byte[100];
            numBytesRead = bufIn.read(byteArray);
            while (numBytesRead != -1) {
                bufOut.write(byteArray, 0, numBytesRead);
                numBytesRead = bufIn.read(byteArray);
            }
            bufOut.flush();
            bufOut.close();
            bufIn.close();
            return DEST;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public static String cleanMappedDrivePath(String path) {
        String uncPath;
        if (path == null || path.isEmpty() || path.length() < 2) {
            return path;
        }
        if (path.charAt(1) != ':') {
            return path;
        }
        String drive = path.substring(0, 2);
        if (drive.equals(uncPath = RMAIO.getUncPath(drive))) {
            return path;
        }
        path = path.substring(2);
        String fullUncPath = RMAIO.concatPath(uncPath, path);
        return fullUncPath;
    }

    public static String getUncPath(String drive) {
        Process process;
        Runtime runTime = Runtime.getRuntime();
        try {
            process = runTime.exec("net use");
        }
        catch (IOException e) {
            e.printStackTrace();
            return drive;
        }
        InputStream inStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        String[] components = null;
        try {
            while (null != (line = bufferedReader.readLine())) {
                components = line.split("\\s+");
                if (components.length <= 2 || !components[1].equalsIgnoreCase(drive)) continue;
                String path = components[2];
                if (components.length > 2) {
                    for (int i = 3; i < components.length; ++i) {
                        path = path.concat(" ");
                        path = path.concat(components[i]);
                    }
                    String wmn = "Microsoft Windows Network";
                    if (path.endsWith(wmn)) {
                        int len = path.length() - wmn.length();
                        path = path.substring(0, len);
                    }
                }
                return path.trim();
            }
        }
        catch (IOException ioe) {
            System.out.println("getUncPath:IOException " + ioe);
        }
        return drive;
    }
}

