/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import rma.util.Compare;
import rma.util.NaturalOrderComparator;

public class RMASort {
    public static final boolean ASCENDING = true;
    public static final boolean DECENDING = false;
    static Hashtable compareHash = new Hashtable();

    public static void quickSort(int index, List rows) {
        RMASort.quickSort(index, rows, true);
    }

    public static void quickSort(int index, List rows, boolean ascending) {
        if (rows.size() < 1) {
            return;
        }
        if (index < 0 || index >= ((List)rows.get(0)).size()) {
            return;
        }
        int s = -1;
        for (int ii = 0; ii < rows.size(); ++ii) {
            List vec = (List)rows.get(ii);
            if (s == -1) {
                s = vec.size();
                continue;
            }
            if (s == vec.size()) continue;
            System.out.println("Can not sort where the row size is not the same for all rows");
            return;
        }
        boolean sorted = true;
        Compare compare = null;
        for (int ii = 1; ii < rows.size(); ++ii) {
            if (compare == null && (compare = (Compare)compareHash.get(((List)rows.get(ii)).get(index).getClass())) == null) {
                compare = (Compare)compareHash.get(Object.class);
            }
            if (compare.compare(((List)rows.get(ii - 1)).get(index), ((List)rows.get(ii)).get(index), ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, rows.size() - 1, index, rows, compare, ascending);
        }
    }

    public static void quickSort(List vec) {
        RMASort.quickSort(vec, true, null);
    }

    public static void quickSort(List vec, boolean ascending) {
        RMASort.quickSort(vec, ascending, null);
    }

    public static void quickSort(List vec, boolean ascending, Compare compare) {
        Object[] objArray = new Object[vec.size()];
        vec.toArray(objArray);
        RMASort.quickSort(objArray, ascending, compare);
        vec.clear();
        for (int ii = 0; ii < objArray.length; ++ii) {
            vec.add(objArray[ii]);
        }
    }

    public static void quickSort(Object[] objArray) {
        RMASort.quickSort(objArray, true, null);
    }

    public static void quickSort(Object[] objArray, boolean ascending) {
        RMASort.quickSort(objArray, ascending, null);
    }

    public static void quickSort(Object[] objArray, boolean ascending, Compare compare) {
        if (objArray == null || objArray.length < 1) {
            return;
        }
        Class<?> c2 = objArray[0].getClass();
        RMASort.quickSort(c2, objArray, ascending, compare);
    }

    public static void quickSort(Class c2, Object[] objArray) {
        RMASort.quickSort(c2, objArray, true, null);
    }

    public static void quickSort(Class c2, Object[] objArray, boolean ascending) {
        RMASort.quickSort(c2, objArray, ascending, null);
    }

    public static void quickSort(Class c2, Object[] objArray, boolean ascending, Compare compare) {
        if (objArray == null || objArray.length < 2) {
            return;
        }
        if (compare == null) {
            compare = (Compare)compareHash.get(c2);
        }
        if (compare == null) {
            compare = (Compare)compareHash.get(Object.class);
        }
        boolean sorted = true;
        for (int ii = 1; ii < objArray.length; ++ii) {
            if (compare.compare(objArray[ii - 1], objArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, objArray.length - 1, objArray, compare, ascending);
        }
    }

    public static void quickSort(Double[] dblArray) {
        RMASort.quickSort(dblArray, true);
    }

    public static void quickSort(Double[] dblArray, boolean ascending) {
        RMASort.quickSort(Double.class, (Object[])dblArray, ascending);
    }

    public static void multipleColumnSort(int[] columnsIndex, List rows, boolean ascending) {
        if (columnsIndex == null || columnsIndex.length == 0 || rows == null || rows.size() == 0) {
            return;
        }
        RMASort.multipleColumnSort0(columnsIndex, 0, rows.size() - 1, rows, ascending);
    }

    protected static void multipleColumnSort0(int[] columnsIndex, int start, int stop, List rows, boolean ascending) {
        if (columnsIndex == null || columnsIndex.length == 0 || rows == null || rows.size() == 0) {
            return;
        }
        Compare compare = null;
        compare = (Compare)compareHash.get(((List)rows.get(0)).get(columnsIndex[0]).getClass());
        if (compare == null) {
            compare = (Compare)compareHash.get(Object.class);
        }
        RMASort.quickSort0(start, stop, columnsIndex[0], rows, compare, ascending);
        if (columnsIndex.length == 1) {
            return;
        }
        int blockIndex = start;
        int startIndex = start;
        for (int i = start + 1; i <= stop + 1; ++i) {
            if (i < rows.size() && compare.compare(((List)rows.get(i - 1)).get(columnsIndex[0]), ((List)rows.get(i)).get(columnsIndex[0]), ascending) == 0) {
                ++blockIndex;
                continue;
            }
            int[] columns = new int[columnsIndex.length - 1];
            RMASort.arrayCopy(columnsIndex, 1, columns, 0, columns.length);
            RMASort.multipleColumnSort0(columns, startIndex, blockIndex, rows, ascending);
            startIndex = ++blockIndex;
        }
    }

    private static void arrayCopy(int[] src, int srcStart, int[] dest, int destStart, int length) {
        if (srcStart < 0 || srcStart >= src.length) {
            return;
        }
        if (destStart < 0 || destStart >= dest.length) {
            return;
        }
        if (length + destStart > dest.length) {
            return;
        }
        if (length + srcStart > src.length) {
            return;
        }
        int i = srcStart;
        for (int j = destStart; j < length; ++j) {
            dest[j] = src[i];
            ++i;
        }
    }

    public static void mergeSort(List keys, List values) {
        RMASort.mergeSort((Compare)new ObjectCompare(), keys, values);
    }

    public static void mergeSort(Compare comparitor, List keys, List values) {
        Comparable[] keysArray = new Comparable[keys.size()];
        keys.toArray(keysArray);
        Object[] valuesArray = values.toArray();
        RMASort.mergeSort(comparitor, keysArray, valuesArray);
        keys.clear();
        values.clear();
        keys.addAll(Arrays.asList(keysArray));
        values.addAll(Arrays.asList(valuesArray));
    }

    public static void mergeSort(Comparable[] keys, Object[] values) {
        RMASort.mergeSort((Compare)new ObjectCompare(), keys, values);
    }

    public static void mergeSort(Compare comparitor, Comparable[] keys, Object[] values) {
        Comparable[] keyAux = (Comparable[])keys.clone();
        Object[] valuesAux = null;
        if (values != null) {
            valuesAux = (Object[])values.clone();
        }
        RMASort.mergeSort(comparitor, keyAux, keys, valuesAux, values, 0, keys.length);
    }

    private static void mergeSort(Compare comparitor, Comparable[] src, Comparable[] dest, Object[] srcValues, Object[] destValues, int low, int high) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && comparitor.compare(dest[j - 1], dest[j], true) > 0; --j) {
                    RMASort.swap(dest, destValues, j, j - 1);
                }
            }
            return;
        }
        int mid = (low + high) / 2;
        RMASort.mergeSort(comparitor, dest, src, destValues, srcValues, low, mid);
        RMASort.mergeSort(comparitor, dest, src, destValues, srcValues, mid, high);
        if (comparitor.compare(src[mid - 1], src[mid], true) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            if (srcValues != null) {
                System.arraycopy(srcValues, low, destValues, low, length);
            }
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            if (q >= high || p < mid && comparitor.compare(src[p], src[q], true) <= 0) {
                dest[i] = src[p];
                if (destValues != null) {
                    destValues[i] = srcValues[p];
                }
                ++p;
                continue;
            }
            dest[i] = src[q];
            if (destValues != null) {
                destValues[i] = srcValues[q];
            }
            ++q;
        }
    }

    private static void swap(Object[] x, Object[] values, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
        if (values != null) {
            t = values[a];
            values[a] = values[b];
            values[b] = t;
        }
    }

    public static void quickSort(List keys, List objVec) {
        RMASort.quickSort(keys, objVec, true);
    }

    public static void quickSort(List keys, List objVec, boolean ascending) {
        if (keys.size() != objVec.size()) {
            System.out.println("Can not sort where the number of keys != number of elements");
            return;
        }
        Object[] keyArray = new Object[keys.size()];
        keys.toArray(keyArray);
        Object[] objArray = new Object[objVec.size()];
        objVec.toArray(objArray);
        RMASort.quickSort(keyArray, objArray, ascending);
        keys.clear();
        objVec.clear();
        for (int ii = 0; ii < keyArray.length; ++ii) {
            keys.add(keyArray[ii]);
            objVec.add(objArray[ii]);
        }
    }

    public static void quickSort(Object[] keyArray, Object[] objArray) {
        RMASort.quickSort(keyArray, objArray, true);
    }

    public static void quickSort(Object[] keyArray, Object[] objArray, boolean ascending) {
        boolean sorted = true;
        Compare compare = null;
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (compare == null && (compare = (Compare)compareHash.get(keyArray[ii].getClass())) == null) {
                compare = (Compare)compareHash.get(Object.class);
            }
            if (compare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, compare, ascending);
        }
    }

    public static void quickSort(double[] keyArray, Object[] objArray) {
        RMASort.quickSort(keyArray, objArray, true);
    }

    public static void quickSort(double[] keyArray, Object[] objArray, boolean ascending) {
        boolean sorted = true;
        DoubleCompare dblcompare = (DoubleCompare)compareHash.get(Double.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (dblcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, dblcompare, ascending);
        }
    }

    public static void quickSort(double[] keyArray, Object[] objArray, int[] objArray2, boolean ascending) {
        boolean sorted = true;
        DoubleCompare dblcompare = (DoubleCompare)compareHash.get(Double.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (dblcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, objArray2, dblcompare, ascending);
        }
    }

    public static void quickSort(double[] keyArray, double[] objArray, boolean ascending) {
        boolean sorted = true;
        DoubleCompare dblcompare = (DoubleCompare)compareHash.get(Double.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (dblcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, dblcompare, ascending);
        }
    }

    public static void quickSort(double[] keyArray, int[] objArray, boolean ascending) {
        boolean sorted = true;
        DoubleCompare dblcompare = (DoubleCompare)compareHash.get(Double.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (dblcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, dblcompare, ascending);
        }
    }

    public static void quickSort(int[] keyArray, int[] objArray, boolean ascending) {
        boolean sorted = true;
        IntegerCompare intcompare = (IntegerCompare)compareHash.get(Integer.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (intcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, intcompare, ascending);
        }
    }

    public static void quickSort(int[] keyArray, Object[] objArray) {
        RMASort.quickSort(keyArray, objArray, true);
    }

    public static void quickSort(int[] keyArray, Object[] objArray, boolean ascending) {
        boolean sorted = true;
        IntegerCompare intcompare = (IntegerCompare)compareHash.get(Integer.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (intcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, intcompare, ascending);
        }
    }

    public static void quickSort(float[] keyArray, Object[] objArray, boolean ascending) {
        boolean sorted = true;
        FloatCompare floatcompare = (FloatCompare)compareHash.get(Float.class);
        for (int ii = 1; ii < keyArray.length; ++ii) {
            if (floatcompare.compare(keyArray[ii - 1], keyArray[ii], ascending) <= 0) continue;
            sorted = false;
            break;
        }
        if (!sorted) {
            RMASort.quickSort0(0, keyArray.length - 1, keyArray, objArray, floatcompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, int index, List rows, Compare compare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, index, rows, compare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, index, rows, compare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, index, rows, compare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, Object[] objArray, Compare compare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, objArray, compare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, objArray, compare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, objArray, compare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, double[] keyArray, Object[] objArray, DoubleCompare dblCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, dblCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, double[] keyArray, Object[] objArray, int[] objArray2, DoubleCompare dblCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, objArray2, dblCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, objArray2, dblCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, objArray2, dblCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, double[] keyArray, double[] objArray, DoubleCompare dblCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, dblCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, double[] keyArray, int[] objArray, DoubleCompare dblCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, dblCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, int[] keyArray, int[] objArray, IntegerCompare dblCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, dblCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, dblCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, int[] keyArray, Object[] objArray, IntegerCompare intCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, intCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, intCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, intCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, float[] keyArray, Object[] objArray, FloatCompare floatCompare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, floatCompare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, floatCompare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, floatCompare, ascending);
        }
    }

    protected static void quickSort0(int first, int last, Object[] keyArray, Object[] objArray, Compare compare, boolean ascending) {
        if (first < last) {
            int splitPoint = first;
            splitPoint = RMASort.split(first, last, splitPoint, keyArray, objArray, compare, ascending);
            RMASort.quickSort0(first, splitPoint - 1, keyArray, objArray, compare, ascending);
            RMASort.quickSort0(splitPoint + 1, last, keyArray, objArray, compare, ascending);
        }
    }

    private static int split(int first, int last, int splitPoint, int index, List rows, Compare compare, boolean ascending) {
        Object x = ((List)rows.get(first)).get(index);
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (compare.compare(x, ((List)rows.get(ii)).get(index), ascending) < 0) continue;
            RMASort.interchange(++splitPoint, ii, index, rows);
        }
        RMASort.interchange(first, splitPoint, index, rows);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, Object[] objArray, Compare compare, boolean ascending) {
        Object x = objArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (compare.compare(x, objArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, objArray);
        }
        RMASort.interchange(first, splitPoint, objArray);
        return splitPoint;
    }

    private static void interchange(int a, int b, int index, List rows) {
        Object oa = rows.get(a);
        Object ob = rows.get(b);
        rows.remove(a);
        rows.add(a, ob);
        rows.remove(b);
        rows.add(b, oa);
    }

    private static void interchange(int a, int b, Object[] objArray) {
        Object temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static int split(int first, int last, int splitPoint, Object[] keyArray, Object[] objArray, Compare compare, boolean ascending) {
        Object x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (compare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, double[] keyArray, Object[] objArray, DoubleCompare dblCompare, boolean ascending) {
        double x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (dblCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, double[] keyArray, Object[] objArray, int[] objArray2, DoubleCompare dblCompare, boolean ascending) {
        double x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (dblCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray, objArray2);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray, objArray2);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, double[] keyArray, double[] objArray, DoubleCompare dblCompare, boolean ascending) {
        double x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (dblCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, double[] keyArray, int[] objArray, DoubleCompare dblCompare, boolean ascending) {
        double x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (dblCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, int[] keyArray, int[] objArray, IntegerCompare dblCompare, boolean ascending) {
        int x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (dblCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, int[] keyArray, Object[] objArray, IntegerCompare intCompare, boolean ascending) {
        int x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (intCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static int split(int first, int last, int splitPoint, float[] keyArray, Object[] objArray, FloatCompare floatCompare, boolean ascending) {
        float x = keyArray[first];
        splitPoint = first;
        for (int ii = first + 1; ii <= last; ++ii) {
            if (floatCompare.compare(x, keyArray[ii], ascending) <= 0) continue;
            RMASort.interchange(++splitPoint, ii, keyArray, objArray);
        }
        RMASort.interchange(first, splitPoint, keyArray, objArray);
        return splitPoint;
    }

    private static void interchange(int a, int b, Object[] keyArray, Object[] objArray) {
        Object temp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = temp;
        temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, double[] keyArray, Object[] objArray) {
        double dtemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = dtemp;
        Object temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, double[] keyArray, Object[] objArray, int[] objArray2) {
        double dtemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = dtemp;
        Object temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
        int tmp = objArray2[a];
        objArray2[a] = objArray2[b];
        objArray2[b] = tmp;
    }

    private static void interchange(int a, int b, double[] keyArray, double[] objArray) {
        double dtemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = dtemp;
        double temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, double[] keyArray, int[] objArray) {
        double dtemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = dtemp;
        int temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, int[] keyArray, int[] objArray) {
        int dtemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = dtemp;
        int temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, int[] keyArray, Object[] objArray) {
        int itemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = itemp;
        Object temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    private static void interchange(int a, int b, float[] keyArray, Object[] objArray) {
        float itemp = keyArray[a];
        keyArray[a] = keyArray[b];
        keyArray[b] = itemp;
        Object temp = objArray[a];
        objArray[a] = objArray[b];
        objArray[b] = temp;
    }

    public static void main(String[] args) {
        int ii;
        int size = 10;
        ArrayList<String> sortmeKeys = new ArrayList<String>(size);
        ArrayList<String> sortmeValues = new ArrayList<String>(size);
        Random rand = new Random();
        for (ii = 0; ii < size; ++ii) {
            Integer I = new Integer(Math.abs(rand.nextInt()));
            sortmeKeys.add(I.toString());
            sortmeValues.add(I.toString());
        }
        RMASort.mergeSort(sortmeKeys, sortmeValues);
        for (ii = 0; ii < sortmeKeys.size(); ++ii) {
            System.out.println(sortmeKeys.get(ii) + ",\t " + sortmeValues.get(ii));
        }
        System.out.println("=================================================================");
        RMASort.mergeSort((Compare)new NaturalOrderComparator(), sortmeKeys, sortmeValues);
        for (ii = 0; ii < sortmeKeys.size(); ++ii) {
            System.out.println(sortmeKeys.get(ii) + ",\t " + sortmeValues.get(ii));
        }
    }

    static {
        Compare c2 = new DoubleCompare();
        compareHash.put(c2.comparesFor, c2);
        c2 = new ObjectCompare();
        compareHash.put(c2.comparesFor, c2);
        c2 = new IntegerCompare();
        compareHash.put(c2.comparesFor, c2);
        c2 = new FloatCompare();
        compareHash.put(c2.comparesFor, c2);
    }

    public static class ObjectCompare
    extends Compare {
        public ObjectCompare() {
            this.comparesFor = Object.class;
        }

        @Override
        public int compare(Object a, Object b, boolean ascending) {
            int mod = 1;
            if (!ascending) {
                mod = -1;
            }
            int num = a.toString().compareTo(b.toString());
            return mod * num;
        }
    }

    public static class DoubleCompare
    extends Compare {
        public DoubleCompare() {
            this.comparesFor = Double.class;
        }

        @Override
        public int compare(Object a, Object b, boolean ascending) {
            if (!(a instanceof Double) || !(b instanceof Double)) {
                return -2;
            }
            double da = (Double)a;
            double db = (Double)b;
            return this.compare(da, db, ascending);
        }

        public int compare(double da, double db, boolean ascending) {
            int mod = 1;
            if (!ascending) {
                mod = -1;
            }
            if (da < db) {
                return mod * -1;
            }
            if (da == db) {
                return 0;
            }
            if (da > db) {
                return mod * 1;
            }
            return -2;
        }
    }

    public static class IntegerCompare
    extends Compare {
        public IntegerCompare() {
            this.comparesFor = Integer.class;
        }

        @Override
        public int compare(Object a, Object b, boolean ascending) {
            if (!(a instanceof Integer) || !(b instanceof Integer)) {
                return -2;
            }
            int ia = (Integer)a;
            int ib = (Integer)b;
            return this.compare(ia, ib, ascending);
        }

        public int compare(int ia, int ib, boolean ascending) {
            int mod = 1;
            if (!ascending) {
                mod = -1;
            }
            if (ia < ib) {
                return mod * -1;
            }
            if (ia == ib) {
                return 0;
            }
            if (ia > ib) {
                return mod * 1;
            }
            return -2;
        }
    }

    public static class FloatCompare
    extends Compare {
        public FloatCompare() {
            this.comparesFor = Float.class;
        }

        @Override
        public int compare(Object a, Object b, boolean ascending) {
            if (!(a instanceof Float) || !(b instanceof Float)) {
                return -2;
            }
            float ia = ((Float)a).floatValue();
            float ib = ((Float)b).floatValue();
            return this.compare(ia, ib, ascending);
        }

        public int compare(float ia, float ib, boolean ascending) {
            int mod = 1;
            if (!ascending) {
                mod = -1;
            }
            if (ia < ib) {
                return mod * -1;
            }
            if (ia == ib) {
                return 0;
            }
            if (ia > ib) {
                return mod * 1;
            }
            return -2;
        }
    }
}

