/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import rma.lang.Modifiable;
import rma.swing.JDialogHelp;
import rma.swing.RmaJObjectCheckBoxMenuItem;
import rma.swing.colorchooser.DefaultHSBChooserPanel;
import rma.swing.colorchooser.DefaultRGBAChooserPanel;
import rma.swing.colorchooser.DefaultSwatchChooserPanel;

public class RMAUtil {
    public static String CURRENT_DIRECTORY = null;
    private static boolean _libLoaded = false;

    public static Color colorChooser(Component parent, Color defaultColor) {
        return RMAUtil.colorChooser(parent, defaultColor, null);
    }

    public static Color colorChooser(Component parent, Color defaultColor, String chooserTitle) {
        Color newColor = null;
        JColorChooser chooser = new JColorChooser(defaultColor != null ? defaultColor : Color.white);
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        for (int i = 0; i < panels.length; ++i) {
            chooser.removeChooserPanel(panels[i]);
        }
        chooser.addChooserPanel(new DefaultSwatchChooserPanel());
        chooser.addChooserPanel(new DefaultHSBChooserPanel());
        DefaultRGBAChooserPanel panel = new DefaultRGBAChooserPanel();
        if (defaultColor != null) {
            panel.setAlpha(defaultColor.getAlpha());
        }
        chooser.addChooserPanel(panel);
        chooser.getSelectionModel().setSelectedColor(defaultColor);
        JDialog dialog = JColorChooser.createDialog(parent, chooserTitle != null ? chooserTitle : "Color Chooser", true, chooser, null, null);
        dialog.setVisible(true);
        newColor = chooser.getColor();
        if (newColor == null) {
            return defaultColor;
        }
        return newColor;
    }

    public static File fileOpen(Frame parent, String title, String startPath, String startFile) {
        File file = null;
        FileDialog dialog = new FileDialog(parent, title, 0);
        if (startPath == null) {
            startPath = CURRENT_DIRECTORY;
        }
        dialog.setDirectory(startPath);
        dialog.setFile(startFile);
        dialog.setVisible(true);
        String filename = dialog.getFile();
        CURRENT_DIRECTORY = dialog.getDirectory();
        if (filename != null) {
            file = new File(CURRENT_DIRECTORY + filename);
        }
        return file;
    }

    public static File fileSave(Frame parent, String title, String startPath, String startFile) {
        File file = null;
        FileDialog dialog = new FileDialog(parent, title, 1);
        if (startPath == null) {
            startPath = CURRENT_DIRECTORY;
        }
        dialog.setDirectory(startPath);
        dialog.setFile(startFile);
        dialog.setVisible(true);
        String filename = dialog.getFile();
        CURRENT_DIRECTORY = dialog.getDirectory();
        if (filename != null) {
            file = new File(CURRENT_DIRECTORY + filename);
        }
        return file;
    }

    public static void showAbout(Frame parent, String title, String about, ImageIcon image) {
        if (image != null) {
            JOptionPane.showMessageDialog(parent, about, title, -1, image);
            parent.repaint();
        } else {
            JOptionPane.showMessageDialog(parent, about, title, -1);
            parent.repaint();
        }
    }

    public static void showHelp(Frame parent, String title, String url) {
        JDialogHelp dialog = new JDialogHelp(parent, title, url);
        dialog.setVisible(true);
    }

    public static boolean substringMatch(Object data, Object matchTo) {
        String matchToStr = matchTo.toString().trim();
        return matchToStr.equals("") || data != null && data.toString().startsWith(matchToStr);
    }

    public static void setParentModified(Component comp) {
        if (comp == null) {
            return;
        }
        Container parent = comp.getParent();
        if (parent != null) {
            if (parent instanceof Modifiable) {
                ((Modifiable)((Object)parent)).setModified(true);
                return;
            }
            RMAUtil.setParentModified(parent);
        }
    }

    public static boolean isChildrenModified(Container comp) {
        Component[] comps = comp.getComponents();
        if (comps == null || comps.length < 1) {
            return false;
        }
        for (int i = 0; i < comps.length; ++i) {
            boolean modified;
            if (comps[i] instanceof Modifiable && (modified = ((Modifiable)((Object)comps[i])).isModified())) {
                return true;
            }
            if (!(comps[i] instanceof Container) || !RMAUtil.isChildrenModified((Container)comps[i])) continue;
            return true;
        }
        return false;
    }

    public static void setChildrenUnmodified(Container comp) {
        Component[] comps = comp.getComponents();
        if (comps == null || comps.length < 1) {
            return;
        }
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Modifiable) {
                ((Modifiable)((Object)comps[i])).setModified(false);
                continue;
            }
            if (!(comps[i] instanceof Container)) continue;
            RMAUtil.setChildrenUnmodified((Container)comps[i]);
        }
    }

    public static AbstractButton findButtonFromText(Class buttonClass, String buttonText, Container container) {
        Component[] comps = container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            AbstractButton abutton;
            if (!(comps[i] instanceof AbstractButton ? (abutton = (AbstractButton)comps[i]).getClass().isAssignableFrom(buttonClass) && buttonText.equals(abutton.getText()) : comps[i] instanceof Container && (abutton = RMAUtil.findButtonFromText(buttonClass, buttonText, (Container)comps[i])) != null)) continue;
            return abutton;
        }
        return null;
    }

    private static native int getHwnd(String var0);

    public static int getHwnd(Window win) {
        if (!_libLoaded) {
            RMAUtil.loadLib();
        }
        String title = null;
        if (win instanceof Dialog) {
            title = ((Dialog)win).getTitle();
        } else if (win instanceof Frame) {
            title = ((Frame)win).getTitle();
        } else {
            return -1;
        }
        if (title != null) {
            int hwnd = RMAUtil.getHwnd(title);
            return hwnd;
        }
        System.out.println("Failed to find get hwnd for " + title);
        return -1;
    }

    private static native void setWindowAlwaysOnTop(int var0, boolean var1);

    public static void setWindowAlwaysOnTop(Window win, boolean flag) {
        win.setAlwaysOnTop(flag);
    }

    private static void loadLib() {
        try {
            System.loadLibrary("rmaUtil");
            _libLoaded = true;
        }
        catch (Throwable t) {
            System.out.println("loadLib: Failed to load library rmaUtil " + t);
            System.out.println("loadLib: library path " + System.getProperty("java.library.path"));
        }
    }

    public static void setWindowMinimized(Window win) {
        if (win instanceof JFrame) {
            ((JFrame)win).setExtendedState(1);
            return;
        }
        if (!_libLoaded) {
            RMAUtil.loadLib();
        }
        if (win == null) {
            return;
        }
        int hwnd = RMAUtil.getHwnd(win);
        if (hwnd < 0) {
            System.out.println("failed to find window pointer");
            return;
        }
        RMAUtil.setWindowMinimized(hwnd);
    }

    private static native void setWindowMinimized(int var0);

    public static void setWindowMaximized(Window win) {
        if (win instanceof JFrame) {
            ((JFrame)win).setExtendedState(6);
            return;
        }
        if (!_libLoaded) {
            RMAUtil.loadLib();
        }
        if (win == null) {
            return;
        }
        int hwnd = RMAUtil.getHwnd(win);
        if (hwnd < 0) {
            System.out.println("failed to find window pointer");
            return;
        }
        RMAUtil.setWindowMaximized(hwnd);
    }

    private static native void setWindowMaximized(int var0);

    public static String getFontString(Font f) {
        if (f == null) {
            return "";
        }
        String strStyle = f.isBold() ? (f.isItalic() ? "BOLDITALIC" : "BOLD") : (f.isItalic() ? "ITALIC" : "PLAIN");
        return f.getFamily() + "-" + strStyle + "-" + f.getSize();
    }

    public static Window getWindow(JMenuItem menuItem) {
        Component parent = menuItem.getParent();
        Window window = SwingUtilities.getWindowAncestor(parent);
        while (window == null && (parent = parent instanceof JPopupMenu ? ((JPopupMenu)parent).getInvoker() : parent.getParent()) != null) {
            window = SwingUtilities.getWindowAncestor(parent);
        }
        return window;
    }

    public static Component getComponentByAction(Container container, Class actionClass) {
        Action menuAction;
        Component comp = null;
        Action title = null;
        if (container instanceof JMenuItem && (menuAction = ((JMenuItem)container).getAction()) != null && menuAction.getClass() == actionClass) {
            title = menuAction;
        }
        if (title != null) {
            return container;
        }
        if (container instanceof JMenu) {
            for (Component component : ((JMenu)container).getMenuComponents()) {
                Action menuAction2;
                if (component instanceof JMenuItem && (menuAction2 = ((JMenuItem)component).getAction()) != null && menuAction2.getClass() == actionClass) {
                    title = menuAction2;
                }
                if (title != null) {
                    return component;
                }
                if (!(component instanceof Container) || (comp = RMAUtil.getComponentByAction((Container)component, actionClass)) == null) continue;
                return comp;
            }
        } else {
            for (Component component : container.getComponents()) {
                Action menuAction3;
                if (component instanceof JMenuItem && (menuAction3 = ((JMenuItem)component).getAction()) != null && menuAction3.getClass() == actionClass) {
                    title = menuAction3;
                }
                if (title != null) {
                    return component;
                }
                if (!(component instanceof Container) || (comp = RMAUtil.getComponentByAction((Container)component, actionClass)) == null) continue;
                return comp;
            }
        }
        return comp;
    }

    public static RmaJObjectCheckBoxMenuItem getComponentByObject(Container container, RmaJObjectCheckBoxMenuItem item) {
        RmaJObjectCheckBoxMenuItem comp = null;
        if (container instanceof RmaJObjectCheckBoxMenuItem && ((RmaJObjectCheckBoxMenuItem)container).getObject() == item.getObject()) {
            return (RmaJObjectCheckBoxMenuItem)container;
        }
        if (container instanceof JMenu) {
            for (Component component : ((JMenu)container).getMenuComponents()) {
                if (component instanceof RmaJObjectCheckBoxMenuItem) {
                    if (((RmaJObjectCheckBoxMenuItem)component).getObject() != item.getObject()) continue;
                    return (RmaJObjectCheckBoxMenuItem)component;
                }
                if (!(component instanceof Container) || (comp = RMAUtil.getComponentByObject((Container)component, item)) == null) continue;
                return comp;
            }
        } else {
            for (Component component : container.getComponents()) {
                if (component instanceof RmaJObjectCheckBoxMenuItem) {
                    if (((RmaJObjectCheckBoxMenuItem)component).getObject() != item.getObject()) continue;
                    return (RmaJObjectCheckBoxMenuItem)component;
                }
                if (!(component instanceof Container) || (comp = RMAUtil.getComponentByObject((Container)component, item)) == null) continue;
                return comp;
            }
        }
        return comp;
    }
}

