/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import rma.util.AbstractTimeInterval;
import rma.util.IllegalTimeIntervalLengthException;
import rma.util.IllegalTimeIntervalTypeException;

public class RelativeTimeInterval
extends AbstractTimeInterval {
    public RelativeTimeInterval() {
    }

    public RelativeTimeInterval(TimeZone tz, String timeInterval, int length) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        super(tz, timeInterval, length);
    }

    public RelativeTimeInterval(String timeInterval, int length) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        super(timeInterval, length);
    }

    public RelativeTimeInterval(String lengthAndInterval) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        super(lengthAndInterval);
    }

    @Override
    public long getNextInterval(long currentTime) {
        return this.calculateInterval(currentTime, true);
    }

    @Override
    public long getPreviousInterval(long currentTime) {
        return this.calculateInterval(currentTime, false);
    }

    private long calculateInterval(long currentTime, boolean positive) {
        if (this._timeInterval == null) {
            return Long.MIN_VALUE;
        }
        long nextTime = currentTime;
        if (this._timeInterval.equalsIgnoreCase("mi") || this._timeInterval.equalsIgnoreCase("hr")) {
            long interval = this.getInterval();
            long baseInterval = this.getInterval(1);
            nextTime = positive ? (nextTime += interval) : (nextTime -= interval);
            nextTime /= baseInterval;
            nextTime *= baseInterval;
        } else {
            GregorianCalendar gc = new GregorianCalendar();
            if (this.tz != null) {
                gc.setTimeZone(this.tz);
            }
            int year = gc.get(1);
            int day = gc.get(5);
            int month = gc.get(2);
            gc.clear();
            if (this._timeInterval.equalsIgnoreCase("dy")) {
                gc.set(year, month, day);
                if (positive) {
                    gc.add(5, this._length);
                } else {
                    gc.add(5, -1 * this._length);
                }
                nextTime = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("wk")) {
                gc.set(year, month, day);
                if (positive) {
                    gc.add(5, 7 * this._length);
                } else {
                    gc.add(5, -7 * this._length);
                }
                nextTime = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("mo")) {
                gc.set(year, month, 1);
                if (positive) {
                    gc.add(2, this._length);
                } else {
                    gc.add(2, -1 * this._length);
                }
                nextTime = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("yr")) {
                gc.set(year, 0, 1);
                if (positive) {
                    gc.add(1, this._length);
                } else {
                    gc.add(1, -1 * this._length);
                }
                nextTime = gc.getTime().getTime();
            }
        }
        return nextTime;
    }
}

