/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Color;
import java.awt.Window;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.XMLUtilities;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import rma.swing.RmaColor;
import rma.util.RMAIO;

public class RmaBaseXmlUtilities {
    private static final Logger LOGGER = Logger.getLogger(RmaBaseXmlUtilities.class.getName());
    private static final String CAUSED_BY = "Caused by: ";
    private static final String DESCRIPTION = "Description";
    private static final int DEFAULT_STEP = 10;
    public static final String INT_ARRAY_NODE_NAME = "intArray";
    public static final String DOUBLE_ARRAY_NODE_NAME = "doubleArray";
    public static final String STRING_ARRAY_NODE_NAME = "stringArray";
    public static final String FLOAT_ARRAY_NODE_NAME = "floatArray";
    public static final String TWO_D_DOUBLE_ARRAY_NODE_NAME = "twoDdoubleArray";
    public static final String WORLD_PT_NODE = "WorldPt";
    public static final String WORLD_LINE_NODE = "WorldLine";
    public static final String WORLD_REGION_NODE = "WorldRegion";
    public static final String LOCAL_RECT_NODE = "LocalRect";
    public static final String WORLD_RECT_NODE = "WorldRect";
    public static final String WORLD_REGION_CLOCKWISE = "Clockwise";
    public static final String WORLD_REGION_SELF_INTERSECTING = "SelfIntersecting";
    public static final String NUM_POINTS_ATTR = "NumPts";
    public static final String LENGTH_ATTRIBUTE = "Length";
    public static final String STEP_ATTRIBUTE = "Step";
    public static final String RANGE_ATTRIBUTE = "Range";
    public static final String DATA_ATTRIBUTE = "Data";
    public static final String NAME_ATTRIBUTE = "Name";
    public static final String INDEX_ATTRIBUTE = "Index";

    public static void addXMLSchemaNamespaceDeclaration(Element elem) {
        if (elem == null) {
            return;
        }
        elem.addNamespaceDeclaration(Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
    }

    public static void addXSLTLocation(Document doc, String xsltLocation) {
        if (doc == null || xsltLocation == null) {
            return;
        }
        Element root = doc.getRootElement();
        if (root != null) {
            root = doc.detachRootElement();
        }
        ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", xsltLocation);
        pi.setPseudoAttribute("type", "text/xsl");
        pi.setPseudoAttribute("href", xsltLocation);
        doc.addContent((Content)pi);
        if (root != null) {
            doc.setRootElement(root);
        }
    }

    public static void addXSDLocation(Element elem, String schemaLocation) {
        if (elem == null || schemaLocation == null) {
            return;
        }
        elem.addNamespaceDeclaration(Namespace.getNamespace((String)"noNamespaceSchemaLocation", (String)schemaLocation));
    }

    public static boolean createArrayElements(Element base, int[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, int[] array, int step) {
        int length = 0;
        if (array != null) {
            length = array.length;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element(INT_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        if (base == null || array == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("I");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static boolean createArrayElements(Element base, double[][] array) {
        if (base == null || array == null) {
            return false;
        }
        Element arrayElem = new Element(TWO_D_DOUBLE_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int row = 0; row < array.length; ++row) {
            double[] arrayRow = array[row];
            if (arrayRow == null) {
                arrayRow = new double[]{};
            }
            int step = RmaBaseXmlUtilities.getStepSize(arrayRow);
            Element childRow = new Element("doubleRow");
            childRow.setAttribute("row", String.valueOf(row));
            childRow.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(arrayRow.length));
            childRow.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
            arrayElem.addContent((Content)childRow);
            for (int i = 0; i < arrayRow.length; i += step) {
                Element child = new Element("D");
                childRow.addContent((Content)child);
                int endRange = Math.min(i + (step - 1), arrayRow.length);
                child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
                j = i;
                for (cnt = 0; cnt < step && j < arrayRow.length; ++cnt, ++j) {
                    buffer.append(arrayRow[j]);
                    buffer.append(",");
                }
                if (buffer.length() > 0) {
                    buffer.setLength(buffer.length() - 1);
                }
                child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
                buffer.setLength(0);
            }
        }
        return true;
    }

    public static boolean createArrayElements(Element base, double[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, double[] array, int step) {
        int length = 0;
        if (array != null) {
            length = array.length;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element(DOUBLE_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        if (base == null || array == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("D");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static boolean createArrayElements(Element base, float[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, float[] array, int step) {
        if (base == null || array == null) {
            return false;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element(FLOAT_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("F");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static boolean createArrayElements(Element base, byte[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, byte[] array, int step) {
        if (base == null || array == null) {
            return false;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element("byteArray");
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("B");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static boolean createArrayElements(Element base, char[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, char[] array, int step) {
        if (base == null || array == null) {
            return false;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element("charArray");
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("C");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static boolean createArrayElements(Element base, String[] array) {
        return RmaBaseXmlUtilities.createArrayElements(base, array, RmaBaseXmlUtilities.getStepSize(array));
    }

    public static boolean createArrayElements(Element base, String[] array, int step) {
        if (base == null || array == null) {
            return false;
        }
        if (step < 0) {
            step = RmaBaseXmlUtilities.getStepSize(array);
        }
        Element arrayElem = new Element(STRING_ARRAY_NODE_NAME);
        base.addContent((Content)arrayElem);
        arrayElem.setAttribute(LENGTH_ATTRIBUTE, String.valueOf(array.length));
        arrayElem.setAttribute(STEP_ATTRIBUTE, String.valueOf(step));
        StringBuffer buffer = new StringBuffer();
        int j = 0;
        int cnt = 0;
        for (int i = 0; i < array.length; i += step) {
            Element child = new Element("String");
            arrayElem.addContent((Content)child);
            int endRange = Math.min(i + (step - 1), array.length);
            child.setAttribute(RANGE_ATTRIBUTE, String.valueOf(i + "-" + endRange));
            j = i;
            for (cnt = 0; cnt < step && j < array.length; ++cnt, ++j) {
                buffer.append(array[j]);
                buffer.append(",");
            }
            if (buffer.length() > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            child.setAttribute(DATA_ATTRIBUTE, buffer.substring(0));
            buffer.setLength(0);
        }
        return true;
    }

    public static double[] getDoubleArrayElements(Element elem) {
        if (elem == null) {
            return null;
        }
        Element arrayElem = RmaBaseXmlUtilities.getArrayElement(elem, DOUBLE_ARRAY_NODE_NAME);
        if (arrayElem == null) {
            return null;
        }
        int length = RmaBaseXmlUtilities.getArrayLength(arrayElem);
        double[] values = new double[length];
        List children = arrayElem.getChildren();
        int idx = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String data = RmaBaseXmlUtilities.getArrayData(child);
            StringTokenizer tokenizer = new StringTokenizer(data, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                values[idx++] = RMAIO.parseDouble(token);
            }
        }
        return values;
    }

    public static int[] getIntArrayElements(Element elem) {
        if (elem == null) {
            return null;
        }
        Element arrayElem = RmaBaseXmlUtilities.getArrayElement(elem, INT_ARRAY_NODE_NAME);
        if (arrayElem == null) {
            return null;
        }
        int length = RmaBaseXmlUtilities.getArrayLength(arrayElem);
        int[] values = new int[length];
        List children = arrayElem.getChildren();
        int idx = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String data = RmaBaseXmlUtilities.getArrayData(child);
            StringTokenizer tokenizer = new StringTokenizer(data, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                values[idx++] = RMAIO.parseInt(token);
            }
        }
        return values;
    }

    public static float[] getFloatArrayElements(Element elem) {
        if (elem == null) {
            return null;
        }
        Element arrayElem = RmaBaseXmlUtilities.getArrayElement(elem, FLOAT_ARRAY_NODE_NAME);
        if (arrayElem == null) {
            return null;
        }
        int length = RmaBaseXmlUtilities.getArrayLength(arrayElem);
        float[] values = new float[length];
        List children = arrayElem.getChildren();
        int idx = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String data = RmaBaseXmlUtilities.getArrayData(child);
            StringTokenizer tokenizer = new StringTokenizer(data, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                values[idx++] = RMAIO.parseFloat(token);
            }
        }
        return values;
    }

    public static String[] getStringArrayElements(Element elem) {
        if (elem == null) {
            return null;
        }
        Element arrayElem = RmaBaseXmlUtilities.getArrayElement(elem, STRING_ARRAY_NODE_NAME);
        if (arrayElem == null) {
            return null;
        }
        int length = RmaBaseXmlUtilities.getArrayLength(arrayElem);
        String[] values = new String[length];
        List children = arrayElem.getChildren();
        int idx = 0;
        for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            String data = RmaBaseXmlUtilities.getArrayData(child);
            StringTokenizer tokenizer = new StringTokenizer(data, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("null".equals(token)) {
                    values[idx++] = null;
                    continue;
                }
                values[idx++] = token;
            }
        }
        return values;
    }

    private static Element getArrayElement(Element elem, String elemName) {
        if (!elemName.equals(elem.getName())) {
            return elem.getChild(elemName);
        }
        return elem;
    }

    protected static int getStepSize(Object array) {
        int length;
        Field lenField;
        if (array == null) {
            return 10;
        }
        if (!array.getClass().isArray()) {
            return 10;
        }
        try {
            lenField = array.getClass().getDeclaredField("length");
        }
        catch (NoSuchFieldException | SecurityException e1) {
            return 10;
        }
        if (lenField == null) {
            return 10;
        }
        try {
            length = lenField.getInt(array);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return 10;
        }
        if (length <= 10) {
            return 10;
        }
        if ((double)length <= 12.0) {
            return length;
        }
        if (length > 1000) {
            return 20;
        }
        return 10;
    }

    private static int getArrayLength(Element arrayElem) {
        if (arrayElem == null) {
            return 0;
        }
        Attribute lengthAttr = arrayElem.getAttribute(LENGTH_ATTRIBUTE);
        try {
            return lengthAttr.getIntValue();
        }
        catch (DataConversionException e) {
            LOGGER.log(Level.WARNING, "getArrayLength:DataConversionException getting array length {0}", e.getMessage());
            LOGGER.log(Level.FINE, CAUSED_BY, e);
            return 0;
        }
    }

    private static String getArrayData(Element arrayElem) {
        if (arrayElem == null) {
            return "";
        }
        return arrayElem.getAttributeValue(DATA_ATTRIBUTE);
    }

    protected static boolean displayArrays(Document doc) {
        Element root = doc.getRootElement();
        if (root == null) {
            LOGGER.log(Level.INFO, "displayArrays: no root found");
            return false;
        }
        double[] data = RmaBaseXmlUtilities.getDoubleArrayElements(root);
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                LOGGER.log(Level.INFO, "displayArrays:data[{0}]={1}", new Object[]{i, data[i]});
            }
        }
        return true;
    }

    public static void saveDescription(Element parent, String desc) {
        if (desc == null) {
            return;
        }
        Element descElem = new Element(DESCRIPTION);
        parent.addContent((Content)descElem);
        StringTokenizer tokenizer = new StringTokenizer(desc, "\n");
        int idx = 0;
        while (tokenizer.hasMoreTokens()) {
            Element child = new Element("desc");
            child.setAttribute("cnt", String.valueOf(idx++));
            child.setAttribute("value", tokenizer.nextToken());
            descElem.addContent((Content)child);
        }
    }

    public static String getDescription(Element descElem) {
        if (descElem == null) {
            return null;
        }
        if (!DESCRIPTION.equals(descElem.getName())) {
            descElem = descElem.getChild(DESCRIPTION);
        }
        if (descElem == null) {
            return null;
        }
        List children = descElem.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String desc = child.getAttributeValue("value");
            if (desc == null) continue;
            buffer.append(desc);
            if (i >= size - 1) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static int getAttributeValueAsInt(Element elem, String attributeName, int defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return attr.getIntValue();
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    public static short getAttributeValueAsShort(Element elem, String attributeName, short defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return (short)attr.getIntValue();
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    public static long getAttributeValueAsLong(Element elem, String attributeName, long defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return attr.getLongValue();
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    public static void setAttributeValueAsLong(Element elem, String attributeName, long value) {
        if (elem == null || attributeName == null) {
            return;
        }
        String strValue = Long.toString(value);
        elem.setAttribute(attributeName, strValue);
    }

    public static float getAttributeValueAsFloat(Element elem, String attributeName, float defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return attr.getFloatValue();
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    public static double getAttributeValueAsDouble(Element elem, String attributeName, double defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        try {
            return attr.getDoubleValue();
        }
        catch (DataConversionException e) {
            return defaultValue;
        }
    }

    public static void setAttributeValueAsDouble(Element elem, String attributeName, double value) {
        if (elem == null || attributeName == null) {
            return;
        }
        String strValue = Double.toString(value);
        elem.setAttribute(attributeName, strValue);
    }

    public static boolean getAttributeValueAsBoolean(Element elem, String attributeName, boolean defaultValue) {
        if (elem == null || attributeName == null) {
            return defaultValue;
        }
        Attribute attr = elem.getAttribute(attributeName);
        if (attr == null) {
            return defaultValue;
        }
        String value = attr.getValue();
        return RMAIO.parseBoolean(value, defaultValue);
    }

    public static void saveColor(Element elem, String attributeName, Color color) {
        if (elem == null || attributeName == null || color == null) {
            return;
        }
        elem.setAttribute(attributeName, RMAIO.color2String(color));
    }

    public static Color loadColor(Element elem, String attributeName, Color defaultColor) {
        if (elem == null || attributeName == null) {
            return defaultColor;
        }
        String colorName = elem.getAttributeValue(attributeName);
        if (colorName == null) {
            return defaultColor;
        }
        return RMAIO.parseColorString(colorName);
    }

    public static Document loadDocument(Reader reader) {
        Document doc = null;
        if (reader != null) {
            try {
                SAXBuilder builder = new SAXBuilder();
                doc = builder.build(reader);
            }
            catch (JDOMException e) {
                LOGGER.log(Level.WARNING, "loadDocument:JDOMException occurred reading XML file. Error: {0}", e.getMessage());
                LOGGER.log(Level.FINE, CAUSED_BY, e);
            }
            catch (NullPointerException e) {
                LOGGER.log(Level.WARNING, "loadDocument:NullPointerException occurred reading XLM file. Error: {0}", e.getMessage());
                LOGGER.log(Level.FINE, CAUSED_BY, e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "loadDocument:IOException occurred reading XML File. Error: {0}", e.getMessage());
                LOGGER.log(Level.FINE, CAUSED_BY, e);
            }
        } else {
            LOGGER.log(Level.WARNING, "loadDocument: No XLM file given. reader is null.");
        }
        return doc;
    }

    public static void addAttributes(Element elem, Map attributes) {
        if (elem == null || attributes == null) {
            return;
        }
        Set set = attributes.entrySet();
        for (Map.Entry entry : set) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            elem.setAttribute(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public static Map attributeListToMap(List attributes) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (attributes == null) {
            return map;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Object obj = attributes.get(i);
            if (!(obj instanceof Attribute)) continue;
            Attribute attr = (Attribute)obj;
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    public static void saveWindowSizeAndLocation(Element node, Window w) {
        if (node == null || w == null) {
            return;
        }
        node.setAttribute("X", String.valueOf(w.getX()));
        node.setAttribute("Y", String.valueOf(w.getY()));
        node.setAttribute("Height", String.valueOf(w.getHeight()));
        node.setAttribute("Width", String.valueOf(w.getWidth()));
    }

    public static void setWindowSizeAndLocation(Element node, Window window) {
        if (node == null || window == null) {
            return;
        }
        int x = RmaBaseXmlUtilities.getAttributeValueAsInt(node, "X", window.getX());
        int y = RmaBaseXmlUtilities.getAttributeValueAsInt(node, "Y", window.getY());
        int h = RmaBaseXmlUtilities.getAttributeValueAsInt(node, "Height", window.getHeight());
        int w = RmaBaseXmlUtilities.getAttributeValueAsInt(node, "Width", window.getWidth());
        window.setSize(w, h);
        window.setLocation(x, y);
        window.invalidate();
        window.validate();
        window.repaint();
    }

    public static String getChildElementAsString(Element parent, String childElementName, String defaultValue) {
        return RmaBaseXmlUtilities.getChildElementAsString(parent, childElementName, false, defaultValue);
    }

    public static String getChildElementAsString(Element parent, String childElementName, boolean trim, String defaultValue) {
        if (parent == null || childElementName == null) {
            return defaultValue;
        }
        Element child = parent.getChild(childElementName);
        return RmaBaseXmlUtilities.getContentAsString(child, trim, defaultValue);
    }

    public static boolean getChildElementAsBoolean(Element parent, String childElementName, boolean defaultValue) {
        if (parent == null || childElementName == null) {
            return defaultValue;
        }
        Element child = parent.getChild(childElementName);
        return RmaBaseXmlUtilities.getContentAsBoolean(child, defaultValue);
    }

    public static String getContentAsString(Element elem, String defaultValue) {
        return RmaBaseXmlUtilities.getContentAsString(elem, false, defaultValue);
    }

    public static String getContentAsString(Element elem, boolean trim, String defaultValue) {
        if (elem == null) {
            return defaultValue;
        }
        String text = trim ? elem.getTextTrim() : elem.getText();
        if (text == null || text.length() < 1) {
            return defaultValue;
        }
        return text;
    }

    public static boolean getContentAsBoolean(Element elem, boolean defaultValue) {
        if (elem == null) {
            return defaultValue;
        }
        String text = elem.getText();
        return RMAIO.parseBoolean(text, defaultValue);
    }

    public static void setChildElementAsInt(Element parent, String childElementName, int value) {
        if (parent == null || childElementName == null) {
            return;
        }
        Element child = RmaBaseXmlUtilities.getOrCreateChild(parent, childElementName);
        String text = Integer.toString(value);
        child.setText(text);
    }

    public static double getChildElementAsDouble(Element parent, String childElementName, double defaultValue) {
        if (parent == null || childElementName == null) {
            return defaultValue;
        }
        Element child = parent.getChild(childElementName);
        return RmaBaseXmlUtilities.getContentAsDouble(child, defaultValue);
    }

    public static Color getChildElementAsColor(Element parent, String childElementName, Color defaultColor) {
        if (parent == null || childElementName == null) {
            return defaultColor;
        }
        Element child = parent.getChild(childElementName);
        if (child == null) {
            return defaultColor;
        }
        String colorText = child.getText();
        if (colorText == null || colorText.length() < 1) {
            return defaultColor;
        }
        return RmaColor.parseColorString(colorText);
    }

    public static void setChildElementAsColor(Element parent, String childElementName, Color color) {
        if (parent == null || childElementName == null || color == null) {
            return;
        }
        Element child = RmaBaseXmlUtilities.getOrCreateChild(parent, childElementName);
        String colorText = RmaColor.color2String(color);
        if (colorText == null) {
            return;
        }
        child.setText(colorText);
    }

    public static double getContentAsDouble(Element elem, double defaultValue) {
        if (elem == null) {
            return defaultValue;
        }
        String text = elem.getText();
        if (text == null || text.length() < 1) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void setChildElementAsDouble(Element parent, String childElementName, double value) {
        if (parent == null || childElementName == null) {
            return;
        }
        Element child = RmaBaseXmlUtilities.getOrCreateChild(parent, childElementName);
        String text = Double.toString(value);
        child.setText(text);
    }

    public static int getContentAsInt(Element elem, int defaultValue) {
        if (elem == null) {
            return defaultValue;
        }
        String text = elem.getTextTrim();
        if (text == null || text.length() < 1) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getContentAsLong(Element elem, long defaultValue) {
        if (elem == null) {
            return defaultValue;
        }
        String text = elem.getText();
        if (text == null || text.length() < 1) {
            return defaultValue;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int getChildElementAsInt(Element parent, String childElementName, int defaultValue) {
        if (parent == null || childElementName == null) {
            return defaultValue;
        }
        Element child = parent.getChild(childElementName);
        return RmaBaseXmlUtilities.getContentAsInt(child, defaultValue);
    }

    public static long getChildElementAsLong(Element parent, String childElementName, long defaultValue) {
        if (parent == null || childElementName == null) {
            return defaultValue;
        }
        Element child = parent.getChild(childElementName);
        return RmaBaseXmlUtilities.getContentAsLong(child, defaultValue);
    }

    @Deprecated
    public static Element getOrCreateChild(Element parent, String childElementName) {
        return XMLUtilities.getOrCreateChild((Element)parent, (String)childElementName);
    }

    public static String getChildElementAttribute(Element parent, String childElementName, String attribute) {
        if (parent == null || childElementName == null) {
            return null;
        }
        Element namedElement = parent.getChild(childElementName);
        if (namedElement == null) {
            return null;
        }
        return namedElement.getAttributeValue(attribute);
    }

    public static void setChildElementAttribute(Element parent, String childElementName, String attribute, String value) {
        if (parent == null || childElementName == null) {
            return;
        }
        Element child = RmaBaseXmlUtilities.getOrCreateChild(parent, childElementName);
        child.setAttribute(attribute, value);
    }

    public static Element buildElement(Reader reader) throws JDOMException, IOException {
        Element element = null;
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(reader);
        element = doc.getRootElement();
        return element;
    }

    public static Element buildElement(String xml) throws JDOMException, IOException {
        Element element = null;
        SAXBuilder builder = new SAXBuilder();
        StringReader stringReader = new StringReader(xml);
        Document doc = builder.build((Reader)stringReader);
        stringReader.close();
        element = doc.getRootElement();
        return element;
    }

    public static String toXmlString(Element element) throws IOException {
        return RmaBaseXmlUtilities.toXmlString(element, null);
    }

    public static String toXmlString(Element element, Format format) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        if (format != null) {
            outputter.setFormat(format);
        }
        StringWriter sw = new StringWriter();
        outputter.output(element, (Writer)sw);
        sw.flush();
        String xmlData = sw.getBuffer().toString();
        sw.close();
        return xmlData;
    }

    public static Element saveChildElement(Element parent, String childName, double textValue) {
        if (parent == null || childName == null || childName.isEmpty()) {
            return null;
        }
        Element child = new Element(childName);
        child.setText(String.valueOf(textValue));
        parent.addContent((Content)child);
        return child;
    }

    public static Element saveChildElement(Element parent, String childName, int textValue) {
        if (parent == null || childName == null || childName.isEmpty()) {
            return null;
        }
        Element child = new Element(childName);
        child.setText(String.valueOf(textValue));
        parent.addContent((Content)child);
        return child;
    }

    public static Element saveChildElement(Element parent, String childName, String textValue) {
        if (parent == null || childName == null || childName.isEmpty()) {
            return null;
        }
        Element child = new Element(childName);
        child.setText(textValue);
        parent.addContent((Content)child);
        return child;
    }

    public static Element saveChildElement(Element parent, String childName, boolean boolValue) {
        if (parent == null || childName == null || childName.isEmpty()) {
            return null;
        }
        Element child = new Element(childName);
        child.setText(String.valueOf(boolValue));
        parent.addContent((Content)child);
        return child;
    }
}

