/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;

public class RmaSymbol {
    protected SymbolShape[] _shapeArray = new SymbolShape[]{new SymbolSquare(), new SymbolCircle(), new SymbolTriangle1(), new SymbolTriangle2(), new SymbolDiamond(), new SymbolX(), new SymbolPlus(), new SymbolLine1(), new SymbolLine2(), new SymbolLine3(), new SymbolLine4(), new SymbolAsterisk(), new SymbolHourGlass()};
    protected static final RmaSymbol _theSymbol = new RmaSymbol();
    protected SymbolType[] _typeArray = new SymbolType[]{new SymbolType(this._shapeArray[0], null, true), new SymbolType(this._shapeArray[1], null, true), new SymbolType(this._shapeArray[2], null, true), new SymbolType(this._shapeArray[3], null, true), new SymbolType(this._shapeArray[4], null, true), new SymbolType(this._shapeArray[12], null, true), new SymbolType(this._shapeArray[0], null, false), new SymbolType(this._shapeArray[1], null, false), new SymbolType(this._shapeArray[2], null, false), new SymbolType(this._shapeArray[3], null, false), new SymbolType(this._shapeArray[4], null, false), new SymbolType(this._shapeArray[12], null, false), new SymbolType(this._shapeArray[0], this._shapeArray[6], false), new SymbolType(this._shapeArray[1], this._shapeArray[6], false), new SymbolType(this._shapeArray[2], this._shapeArray[9], false), new SymbolType(this._shapeArray[3], this._shapeArray[9], false), new SymbolType(this._shapeArray[4], this._shapeArray[6], false), new SymbolType(this._shapeArray[0], this._shapeArray[5], false), new SymbolType(this._shapeArray[1], this._shapeArray[5], false), new SymbolType(this._shapeArray[2], this._shapeArray[5], false), new SymbolType(this._shapeArray[3], this._shapeArray[5], false), new SymbolType(this._shapeArray[4], this._shapeArray[9], false), new SymbolType(this._shapeArray[0], this._shapeArray[7], false), new SymbolType(this._shapeArray[0], this._shapeArray[8], false), new SymbolType(this._shapeArray[0], this._shapeArray[10], false), new SymbolType(this._shapeArray[0], this._shapeArray[9], false), new SymbolType(this._shapeArray[4], this._shapeArray[10], false), new SymbolType(null, this._shapeArray[5], false), new SymbolType(null, this._shapeArray[6], false), new SymbolType(null, this._shapeArray[7], false), new SymbolType(null, this._shapeArray[8], false), new SymbolType(null, this._shapeArray[9], false), new SymbolType(null, this._shapeArray[10], false), new SymbolType(null, this._shapeArray[11], false)};
    protected int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
    protected int PRINTER_SCALE = Toolkit.getDefaultToolkit().getScreenResolution();
    public final int NUM_SYMBOL_TYPES = this._typeArray.length;
    public static final int SYMBOL_ASTRICK = 33;
    public static final int SYMBOL_BACKSLASH = 29;
    public static final int SYMBOL_CIRCLE = 1;
    public static final int SYMBOL_CIRCLE_OPEN = 7;
    public static final int SYMBOL_CIRCLE_PLUS = 13;
    public static final int SYMBOL_CIRCLE_X = 18;
    public static final int SYMBOL_DIAMOND = 4;
    public static final int SYMBOL_DIAMOND_HASH = 21;
    public static final int SYMBOL_DIAMOND_OPEN = 10;
    public static final int SYMBOL_DIAMOND_PIPE = 26;
    public static final int SYMBOL_DIAMOND_PLUS = 16;
    public static final int SYMBOL_FORWARDSLASH = 30;
    public static final int SYMBOL_HASH = 31;
    public static final int SYMBOL_HOURGLASS = 5;
    public static final int SYMBOL_HOURGLASS_OPEN = 11;
    public static final int SYMBOL_PIPE = 32;
    public static final int SYMBOL_PLUS = 28;
    public static final int SYMBOL_SQUARE = 0;
    public static final int SYMBOL_SQUARE_BACKSLASH = 22;
    public static final int SYMBOL_SQUARE_FORWARDSLASH = 23;
    public static final int SYMBOL_SQUARE_HASH = 25;
    public static final int SYMBOL_SQUARE_OPEN = 6;
    public static final int SYMBOL_SQUARE_PIPE = 24;
    public static final int SYMBOL_SQUARE_PLUS = 12;
    public static final int SYMBOL_SQUARE_X = 17;
    public static final int SYMBOL_TRIANGLE1 = 2;
    public static final int SYMBOL_TRIANGLE1_HASH = 14;
    public static final int SYMBOL_TRIANGLE1_OPEN = 8;
    public static final int SYMBOL_TRIANGLE1_X = 19;
    public static final int SYMBOL_TRIANGLE2 = 3;
    public static final int SYMBOL_TRIANGLE2_HASH = 15;
    public static final int SYMBOL_TRIANGLE2_OPEN = 9;
    public static final int SYMBOL_TRIANGLE2_X = 20;
    public static final int SYMBOL_X = 27;
    protected static final String[] symbolNames = new String[]{"SQUARE", "CIRCLE", "TRIANGLE", "TRIANGLE2", "DIAMOND", "HOURGLASS", "OPEN SQUARE", "OPEN CIRCLE", "OPEN TRIANGLE", "OPEN TRIANGLE2", "OPEN DIAMOND", "OPEN HOURGLASS", "PLUS SQUARE", "PLUS CIRCLE", "HASH TRIANGLE", "HASH TRIANGLE2", "PLUS DIAMOND", "X SQUARE", "X CIRCLE", "X TRIANGLE", "X TRIANGLE2", "HASH DIAMOND", "BACKSLASH SQUARE", "FORWARDSLASH SQUARE", "PIPE SQUARE", "HASH SQUARE", "PIPE DIAMOND", "X", "PLUS", "BACKSLASH", "FORWARDSLASH", "HASH", "PIPE", "ASTERISK"};
    protected static int[] xcoord = new int[8];
    protected static int[] ycoord = new int[8];

    public static void draw(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size, float lineWidth) {
        int mtype = Math.abs(type % RmaSymbol._theSymbol.NUM_SYMBOL_TYPES);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(lineWidth));
        RmaSymbol._theSymbol._typeArray[mtype].draw(g2, x, y, size, lineclr, fillclr);
    }

    public static void draw(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size) {
        RmaSymbol.draw(g, x, y, type, lineclr, fillclr, size, 1.0f);
    }

    public static void draw2(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size, int resolution, float lineWidth) {
        RmaSymbol._theSymbol.resolution = resolution;
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(lineWidth));
        RmaSymbol._theSymbol._typeArray[type].draw(g2, x, y, size, lineclr, fillclr);
    }

    public static void draw2(Graphics g, int x, int y, int type, Color lineclr, Color fillclr, float size, int resolution) {
        RmaSymbol.draw2(g, x, y, type, lineclr, fillclr, size, resolution, 1.0f);
    }

    public static String getSymbolName(int type) {
        if (type < 0 || type >= symbolNames.length) {
            return null;
        }
        return symbolNames[type];
    }

    public static int getSymbolType(String name) {
        int type = Integer.MIN_VALUE;
        String _name = name.toUpperCase();
        for (int i = 0; i < symbolNames.length; ++i) {
            if (!_name.equals(symbolNames[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    public static int numSymbols() {
        return RmaSymbol._theSymbol.NUM_SYMBOL_TYPES;
    }

    protected class SymbolShape {
        protected SymbolShape() {
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
        }

        public void setResolution(int resolution) {
            resolution = 1;
        }
    }

    protected class SymbolSquare
    extends SymbolShape {
        protected SymbolSquare() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (fc != null) {
                g.setColor(fc);
                g.fillRect(x0, y0, (int)size, (int)size);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawRect(x0, y0, (int)size, (int)size);
            }
        }
    }

    protected class SymbolCircle
    extends SymbolShape {
        protected SymbolCircle() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (fc != null) {
                g.setColor(fc);
                g.fillOval(x0, y0, (int)size + 1, (int)size + 1);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawOval(x0, y0, (int)size, (int)size);
            }
        }
    }

    protected class SymbolTriangle1
    extends SymbolShape {
        protected SymbolTriangle1() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            RmaSymbol.xcoord[0] = x;
            RmaSymbol.xcoord[1] = x - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[2] = xcoord[1] + (int)size;
            RmaSymbol.ycoord[0] = y - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[1] = ycoord[0] + (int)size;
            RmaSymbol.ycoord[2] = ycoord[1];
            if (fc != null) {
                g.setColor(fc);
                g.fillPolygon(xcoord, ycoord, 3);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawPolygon(xcoord, ycoord, 3);
            }
        }
    }

    protected class SymbolTriangle2
    extends SymbolShape {
        protected SymbolTriangle2() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            RmaSymbol.xcoord[0] = x;
            RmaSymbol.xcoord[1] = x + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[2] = xcoord[1] - (int)size;
            RmaSymbol.ycoord[0] = y + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[1] = y - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[2] = ycoord[1];
            if (fc != null) {
                g.setColor(fc);
                g.fillPolygon(xcoord, ycoord, 3);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawPolygon(xcoord, ycoord, 3);
            }
        }
    }

    protected class SymbolDiamond
    extends SymbolShape {
        protected SymbolDiamond() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            RmaSymbol.xcoord[0] = x;
            RmaSymbol.xcoord[2] = x;
            RmaSymbol.ycoord[0] = y - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[2] = ycoord[0] + (int)size;
            RmaSymbol.xcoord[1] = x - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[3] = xcoord[1] + (int)size;
            RmaSymbol.ycoord[1] = y;
            RmaSymbol.ycoord[3] = y;
            if (fc != null) {
                g.setColor(fc);
                g.fillPolygon(xcoord, ycoord, 4);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawPolygon(xcoord, ycoord, 4);
            }
        }
    }

    protected class SymbolX
    extends SymbolShape {
        protected SymbolX() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x0, y0, x0 + (int)size, y0 + (int)size);
                g.drawLine(x0 + (int)size, y0, x0, y0 + (int)size);
            }
        }
    }

    protected class SymbolPlus
    extends SymbolShape {
        protected SymbolPlus() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x0, y, x0 + (int)size, y);
                g.drawLine(x, y0, x, y0 + (int)size);
            }
        }
    }

    protected class SymbolLine1
    extends SymbolShape {
        protected SymbolLine1() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x0, y0, x0 + (int)size, y0 + (int)size);
            }
        }
    }

    protected class SymbolLine2
    extends SymbolShape {
        protected SymbolLine2() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x0 + (int)size, y0, x0, y0 + (int)size);
            }
        }
    }

    protected class SymbolLine3
    extends SymbolShape {
        protected SymbolLine3() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int x0 = x - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x0, y, x0 + (int)size, y);
            }
        }
    }

    protected class SymbolLine4
    extends SymbolShape {
        protected SymbolLine4() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            int y0 = y - (int)((double)(size / 2.0f) + 0.5);
            if (lc != null) {
                g.setColor(lc);
                g.drawLine(x, y0, x, y0 + (int)size);
            }
        }
    }

    protected class SymbolAsterisk
    extends SymbolShape {
        protected SymbolAsterisk() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            SymbolX sx = new SymbolX();
            SymbolPlus sp = new SymbolPlus();
            sx.draw(g, x, y, size, lc, fc);
            sp.draw(g, x, y, size, lc, fc);
        }
    }

    protected class SymbolHourGlass
    extends SymbolShape {
        protected SymbolHourGlass() {
        }

        @Override
        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            size = size * (float)RmaSymbol.this.resolution / (float)RmaSymbol.this.PRINTER_SCALE;
            RmaSymbol.xcoord[0] = x - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[0] = y - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[1] = x + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[1] = y - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[2] = x - (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[2] = y + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[3] = x + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.ycoord[3] = y + (int)((double)(size / 2.0f) + 0.5);
            RmaSymbol.xcoord[4] = xcoord[0];
            RmaSymbol.ycoord[4] = ycoord[0];
            if (fc != null) {
                g.setColor(fc);
                g.fillPolygon(xcoord, ycoord, 5);
            }
            if (lc != null) {
                g.setColor(lc);
                g.drawPolygon(xcoord, ycoord, 5);
            }
        }
    }

    protected class SymbolType {
        SymbolShape _outlineAndFillShape = null;
        SymbolShape _lineShape = null;
        boolean _fill = false;

        SymbolType(SymbolShape ofshape, SymbolShape lshape, boolean fill) {
            this._outlineAndFillShape = ofshape;
            this._lineShape = lshape;
            this._fill = fill;
        }

        public void draw(Graphics g, int x, int y, float size, Color lc, Color fc) {
            if (!this._fill) {
                fc = null;
            }
            if (this._outlineAndFillShape != null) {
                this._outlineAndFillShape.draw(g, x, y, size, lc, fc);
            }
            if (this._lineShape != null) {
                this._lineShape.draw(g, x, y, size, lc, fc);
            }
        }
    }
}

