/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import rma.util.JTreeContentHandler;
import rma.util.JTreeErrorHandler;

public class SAXTreeViewer
extends JFrame {
    private String vendorParserClass = "javax.xml.parsers.SAXParser";
    private JTextArea _rawFileTxt;
    private JTabbedPane _tabbedPane;
    private JTextField _filenameTxt;
    private JTree jTree;
    DefaultTreeModel defaultTreeModel;

    public SAXTreeViewer() {
        super("XML Viewer");
        this.setDefaultCloseOperation(3);
        this.setSize(600, 450);
    }

    private void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel("File:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)label, gbc);
        this._filenameTxt = new JTextField();
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)this._filenameTxt, gbc);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SAXTreeViewer.this.browse();
            }
        });
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        panel.add((Component)button, gbc);
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)panel, gbc);
        this._rawFileTxt = new JTextArea();
        this._rawFileTxt.setEditable(false);
        this.jTree = new JTree();
        this._tabbedPane.addTab("XML", new JScrollPane(this.jTree));
        this._tabbedPane.addTab("Raw", new JScrollPane(this._rawFileTxt));
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this._tabbedPane, gbc);
    }

    private void browse() {
        JFileChooser chooser = new JFileChooser(this._filenameTxt.getText());
        if (chooser.showOpenDialog(this) == 0) {
            File f = chooser.getSelectedFile();
            if (f == null) {
                return;
            }
            try {
                this.init(f.getAbsolutePath());
            }
            catch (Exception e) {
                System.out.println("browse:Error loading file " + f.getAbsolutePath() + " Error:" + e);
            }
        }
    }

    public void init(String xmlURI) throws IOException, SAXException {
        this._filenameTxt.setText(xmlURI);
        DefaultMutableTreeNode base = new DefaultMutableTreeNode("XML Document: " + xmlURI);
        this.defaultTreeModel = new DefaultTreeModel(base);
        this.jTree.setModel(this.defaultTreeModel);
        this.buildTree(this.defaultTreeModel, base, xmlURI);
        BufferedReader reader = new BufferedReader(new FileReader(xmlURI));
        this._rawFileTxt.read(reader, null);
        reader.close();
        this.jTree.expandRow(0);
        this.jTree.expandRow(1);
    }

    public void buildTree(DefaultTreeModel treeModel, DefaultMutableTreeNode base, String xmlURI) throws IOException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser reader = null;
        try {
            reader = factory.newSAXParser();
        }
        catch (Exception e) {
            System.out.println("Failed to create parser " + e);
            return;
        }
        JTreeContentHandler jTreeContentHandler = new JTreeContentHandler(treeModel, base);
        JTreeErrorHandler jTreeErrorHandler = new JTreeErrorHandler();
        reader.parse(new File(xmlURI), (DefaultHandler)jTreeContentHandler);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: java javaxml2.SAXTreeViewer [XML Document URI]");
                System.exit(0);
            }
            SAXTreeViewer viewer = new SAXTreeViewer();
            viewer.buildComponents();
            viewer.init(args[0]);
            viewer.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

