/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import hec.io.AsciiSerializable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import rma.util.ShortArrayEnumerator;

public class ShortArray
implements Cloneable,
Serializable,
AsciiSerializable {
    protected short[] _elementData;
    protected int _elementCount;
    protected int _capacityIncrement;
    private static final long serialVersionUID = -2767605614048989439L;

    public ShortArray(int initialCapacity, int capacityIncrement) {
        this._elementData = new short[initialCapacity];
        this._capacityIncrement = capacityIncrement;
    }

    public ShortArray(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ShortArray() {
        this(10);
    }

    public ShortArray(short[] array) {
        this(array.length);
        System.arraycopy(array, 0, this._elementData, 0, array.length);
        this._elementCount = array.length;
    }

    public boolean addAll(short[] array) {
        int numNew = array.length;
        this.ensureCapacityHelper(this._elementCount + numNew);
        for (int i = 0; i < numNew; ++i) {
            this._elementData[this._elementCount++] = array[i];
        }
        return numNew != 0;
    }

    public boolean addAll(ShortArray sa) {
        int numNew = sa.size();
        this.ensureCapacityHelper(this._elementCount + numNew);
        for (int i = 0; i < numNew; ++i) {
            this._elementData[this._elementCount++] = sa.get(i);
        }
        return numNew != 0;
    }

    public short[] toArray() {
        short[] array = new short[this._elementCount];
        System.arraycopy(this._elementData, 0, array, 0, this._elementCount);
        return array;
    }

    public final void copyInto(short[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = this._elementData[i];
        }
    }

    public final void copyInto(Short[] anArray) {
        int i = this._elementCount;
        while (i-- > 0) {
            anArray[i] = new Short(this._elementData[i]);
        }
    }

    public final void trimToSize() {
        int oldCapacity = this._elementData.length;
        if (this._elementCount < oldCapacity) {
            short[] oldData = this._elementData;
            this._elementData = new short[this._elementCount];
            System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
        }
    }

    public final void ensureCapacity(int minCapacity) {
        if (minCapacity > this._elementData.length) {
            this.ensureCapacityHelper(minCapacity);
        }
    }

    private void ensureCapacityHelper(int minCapacity) {
        int newCapacity;
        int oldCapacity = this._elementData.length;
        short[] oldData = this._elementData;
        int n = newCapacity = this._capacityIncrement > 0 ? oldCapacity + this._capacityIncrement : oldCapacity * 2;
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this._elementData = new short[newCapacity];
        System.arraycopy(oldData, 0, this._elementData, 0, this._elementCount);
    }

    public final void setSize(int newSize) {
        if (newSize > this._elementCount && newSize > this._elementData.length) {
            this.ensureCapacityHelper(newSize);
        } else {
            for (int i = newSize; i < this._elementCount; ++i) {
                this._elementData[i] = Short.MIN_VALUE;
            }
        }
        this._elementCount = newSize;
    }

    public final int capacity() {
        return this._elementData.length;
    }

    public final int size() {
        return this._elementCount;
    }

    public final boolean isEmpty() {
        return this._elementCount == 0;
    }

    private final ShortArrayEnumerator elements() {
        return new ShortArrayEnumerator(this);
    }

    public final boolean contains(short elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(short elem) {
        return this.indexOf(elem, 0);
    }

    public final int indexOf(short elem, int index) {
        for (int i = index; i < this._elementCount; ++i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public final int lastIndexOf(short elem) {
        return this.lastIndexOf(elem, this._elementCount - 1);
    }

    public final int lastIndexOf(short elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this._elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public short get(int index) {
        return this.elementAt(index);
    }

    public final short elementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        try {
            return this._elementData[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final short firstElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[0];
    }

    public final short lastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this._elementData[this._elementCount - 1];
    }

    public final short removeLastElement() {
        if (this._elementCount == 0) {
            throw new NoSuchElementException();
        }
        short rv = this._elementData[this._elementCount - 1];
        --this._elementCount;
        return rv;
    }

    public final void setElementAt(short obj, int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        this._elementData[index] = obj;
    }

    public final void removeElementAt(int index) {
        if (index >= this._elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this._elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this._elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this._elementData, index + 1, this._elementData, index, j);
        }
        --this._elementCount;
        this._elementData[this._elementCount] = Short.MIN_VALUE;
    }

    public final void insertElementAt(short obj, int index) {
        int newcount = this._elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this._elementCount);
        }
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        System.arraycopy(this._elementData, index, this._elementData, index + 1, this._elementCount - index);
        this._elementData[index] = obj;
        ++this._elementCount;
    }

    public void add(short obj) {
        this.addElement(obj);
    }

    public final void addElement(short obj) {
        int newcount = this._elementCount + 1;
        if (newcount > this._elementData.length) {
            this.ensureCapacityHelper(newcount);
        }
        this._elementData[this._elementCount++] = obj;
    }

    public boolean remove(short obj) {
        return this.removeElement(obj);
    }

    public int removeAll(short[] objs) {
        int removed = 0;
        if (objs == null) {
            return 0;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!this.remove(objs[i])) continue;
            ++removed;
        }
        return removed;
    }

    public final boolean removeElement(short obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public void clear() {
        this.removeAllElements();
    }

    public final void removeAllElements() {
        for (int i = 0; i < this._elementCount; ++i) {
            this._elementData[i] = Short.MIN_VALUE;
        }
        this._elementCount = 0;
    }

    public Object clone() {
        try {
            ShortArray v = (ShortArray)super.clone();
            v._elementData = new short[this._elementCount];
            System.arraycopy(this._elementData, 0, v._elementData, 0, this._elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public long elementTotal() {
        ShortArrayEnumerator e = this.elements();
        int total = 0;
        while (e.hasMoreElements()) {
            total += e.nextElement();
        }
        return total;
    }

    public final String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        ShortArrayEnumerator e = this.elements();
        buf.append("[");
        for (int i = 0; i <= max; ++i) {
            short l = e.nextElement();
            String s = l == Short.MIN_VALUE ? "" : Short.toString(l);
            buf.append(s);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

