/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private Map<SoftKey<K>, V> hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    private void processQueue() {
        SoftKey wk;
        while ((wk = (SoftKey)this.queue.poll()) != null) {
            this.hash.remove(wk);
        }
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<SoftKey<K>, V>(initialCapacity, loadFactor);
    }

    public SoftHashMap(int initialCapacity) {
        this.hash = new HashMap<SoftKey<K>, V>(initialCapacity);
    }

    public SoftHashMap() {
        this.hash = new HashMap<SoftKey<K>, V>();
    }

    public SoftHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hash.containsKey(SoftKey.create(key));
    }

    @Override
    public V get(Object key) {
        return this.hash.get(SoftKey.create(key));
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        SoftKey<K> createdKey = SoftKey.create(key, this.queue);
        return this.hash.put(createdKey, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        return this.hash.remove(SoftKey.create(key));
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private static class SoftKey<T>
    extends SoftReference<T> {
        private int hash;

        private SoftKey(T k) {
            super(k);
            this.hash = k.hashCode();
        }

        private static <U> SoftKey<U> create(U k) {
            if (k == null) {
                return null;
            }
            return new SoftKey<U>(k);
        }

        private SoftKey(T k, ReferenceQueue<? super T> q) {
            super(k, q);
            this.hash = k.hashCode();
        }

        private static <T> SoftKey<T> create(T k, ReferenceQueue<? super T> q) {
            if (k == null) {
                return null;
            }
            return new SoftKey<T>(k, q);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SoftKey)) {
                return false;
            }
            Object t = this.get();
            Object u = ((SoftKey)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<SoftKey<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = SoftHashMap.this.hash.entrySet();
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                Iterator<Map.Entry<SoftKey<K>, V>> hashIterator;
                Map.Entry<SoftKey<K>, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        SoftKey wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object t = wk.get();
                            k = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            SoftHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            SoftKey wk = SoftKey.create(e.getKey());
            Object hv = SoftHashMap.this.hash.get(wk);
            if (hv == null ? ev == null && SoftHashMap.this.hash.containsKey(wk) : hv.equals(ev)) {
                SoftHashMap.this.hash.remove(wk);
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry ent : this.hashEntrySet) {
                Object v;
                SoftKey wk = ent.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> ent;
        private K key;

        Entry(Map.Entry<K, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.valEquals(this.key, e.getKey()) && Entry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }
}

