/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.RmaJFrame;
import rma.util.MemProgressBar;
import rma.util.MemoryMonitor;

public class StatusBarMemoryMonitor
extends JPanel {
    RmaJFrame _memMonitorFrame;
    private MemProgressBar membar = new MemProgressBar();
    private static StatusBarMemoryMonitor smm = new StatusBarMemoryMonitor();

    public StatusBarMemoryMonitor() {
        super(new GridBagLayout());
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.maxMemory();
        maxMem /= 1024L;
        this.membar.setToolTipText("<html>Memory used of memory allocated.<br> Total of " + (maxMem /= 1024L) + " MB. available");
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    StatusBarMemoryMonitor.this.memoryMonitor_Action();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    StatusBarMemoryMonitor.this.showPopup(e.getPoint());
                }
            }
        };
        this.addMouseListener(ma);
        this.membar.addMouseListener(ma);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.membar, gbc);
    }

    public MemProgressBar getMemBar() {
        return this.membar;
    }

    public static StatusBarMemoryMonitor getInstance() {
        return smm;
    }

    public void memoryMonitor_Action() {
        if (this._memMonitorFrame == null) {
            final MemoryMonitor demo = new MemoryMonitor();
            WindowAdapter l = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    demo.surf.stop();
                    StatusBarMemoryMonitor.this._memMonitorFrame = null;
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    demo.surf.start();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    demo.surf.stop();
                }
            };
            this._memMonitorFrame = new RmaJFrame("MemoryMonitor");
            this._memMonitorFrame.setSystemClosable(false);
            this._memMonitorFrame.addWindowListener(l);
            this._memMonitorFrame.getContentPane().add("Center", demo);
            this._memMonitorFrame.pack();
            this._memMonitorFrame.setSize(new Dimension(200, 200));
            this._memMonitorFrame.setVisible(true);
        } else if (this._memMonitorFrame.getState() == 1) {
            this._memMonitorFrame.setState(0);
        } else if (!this._memMonitorFrame.isVisible()) {
            this._memMonitorFrame.setVisible(true);
        } else {
            this._memMonitorFrame.toFront();
        }
    }

    private void showPopup(Point p) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(this.membar.isVisible() ? "hide" : "show");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBarMemoryMonitor.this.membar.setVisible(!StatusBarMemoryMonitor.this.membar.isVisible());
            }
        });
        menu.add(menuItem);
        menu.show(this, p.x, p.y);
    }
}

