/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import rma.util.AbstractTimeInterval;
import rma.util.IllegalTimeIntervalLengthException;
import rma.util.IllegalTimeIntervalTypeException;

public class TimeInterval
extends AbstractTimeInterval {
    public TimeInterval() {
    }

    public TimeInterval(String timeInterval, int length) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        super(timeInterval, length);
    }

    public TimeInterval(String lengthAndInterval) throws IllegalTimeIntervalLengthException, IllegalTimeIntervalTypeException {
        super(lengthAndInterval);
    }

    @Override
    public long getPreviousInterval(long currentTime) {
        throw new UnsupportedOperationException("getPreviousInterval(long currentTime) is not supported by rma.util.TimeInterval.");
    }

    @Override
    public long getNextInterval(long currentTime) {
        if (this._timeInterval == null) {
            return Long.MIN_VALUE;
        }
        Object filename = null;
        Object startDate = null;
        long nextTimeForNewFile = currentTime;
        if (this._timeInterval.equalsIgnoreCase("hr")) {
            long intervalsFromBase = currentTime / (3600000L * (long)this._length);
            nextTimeForNewFile = (intervalsFromBase + 1L) * 3600000L * (long)this._length;
        } else {
            GregorianCalendar gc = null;
            gc = this.localTime ? new GregorianCalendar() : new GregorianCalendar(TimeZone.getTimeZone("utc"));
            int day = 0;
            int month = 0;
            int year = 0;
            int dayOfWeek = -1;
            int minute = 0;
            int hour = 0;
            year = gc.get(1);
            if (this._timeInterval.equalsIgnoreCase("mi")) {
                minute = gc.get(12);
                int minuteLeft = minute % this._length;
                if ((minute = minute - minuteLeft + this._length) % 60 != minute) {
                    gc.add(11, 1);
                    minute -= 60;
                }
                hour = gc.get(11);
                day = gc.get(5);
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, day, hour, minute);
                nextTimeForNewFile = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("dy")) {
                day = gc.get(5);
                month = gc.get(2);
                gc.clear();
                gc.set(year, month, day);
                gc.add(5, this._length);
                nextTimeForNewFile = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("wk")) {
                day = gc.get(5);
                month = gc.get(2);
                dayOfWeek = gc.get(7);
                gc.clear();
                gc.set(year, month, day);
                gc.add(5, 7 * this._length);
                nextTimeForNewFile = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("mo")) {
                month = gc.get(2);
                year = gc.get(1);
                gc.clear();
                gc.set(year, month, 1);
                gc.add(2, this._length);
                nextTimeForNewFile = gc.getTime().getTime();
            } else if (this._timeInterval.equalsIgnoreCase("yr")) {
                gc.clear();
                gc.set(year, 0, 1);
                gc.add(1, this._length);
                nextTimeForNewFile = gc.getTime().getTime();
            }
        }
        Date nextDate = new Date();
        nextDate.setTime(nextTimeForNewFile);
        return nextDate.getTime();
    }
}

