/*
 * Decompiled with CFR 0.152.
 */
package rma.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import rma.util.RMAIO;

public class Timer
implements Serializable {
    protected String _process = null;
    protected String _name = "";
    protected long _start = 0L;
    protected long _stop = 0L;
    String _extra;
    static int BENCH_LOG = RMAIO.parseInt(System.getProperty("wcds.dbi.BenchLog", "0"));
    static String _logPath = System.getProperty("wcds.dbi.LogFilePath");
    static String _run = System.getProperty("wcds.dbi.BenchRunName");
    static String _iteration = System.getProperty("wcds.dbi.BenchRunIteration");
    static String _timeZone = null;
    static TimeZone tz = null;

    public Timer(String process, String name) {
        this.setProcess(process);
        this.setName(name);
        this.start();
    }

    public Timer(String name) {
        this.setName(name);
        this.start();
    }

    public Timer() {
        this.setName("Timer");
        this.start();
    }

    public void setName(String name) {
        if (name != null) {
            this._name = name + _run + _iteration;
        }
    }

    public void setProcess(String process) {
        this._process = process;
    }

    public String getProcess() {
        return this._process;
    }

    public String getName() {
        return this._name;
    }

    public void start() {
        Date date = Calendar.getInstance(tz).getTime();
        this._start = date.getTime();
    }

    public void stop() {
        Date date = Calendar.getInstance(tz).getTime();
        this._stop = date.getTime();
        this.log();
    }

    public long getStart() {
        return this._start;
    }

    public long getStop() {
        return this._stop;
    }

    public long getTime() {
        long time = this._stop - this._start;
        return time;
    }

    public int getSeconds() {
        int time = (int)this.getTime() / 1000;
        return time;
    }

    public int getMinutes() {
        int time = this.getSeconds() / 60;
        return time;
    }

    public int getHours() {
        int time = this.getMinutes() / 60;
        return time;
    }

    public int getDays() {
        int time = this.getHours() / 24;
        return time;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this._process != null) {
            int len = this._process.length();
            if (len > 3) {
                buf.append(this._process.substring(0, 3));
            } else {
                buf.append(this._process);
                while (buf.length() < 3) {
                    buf.append(" ");
                }
            }
        } else {
            buf.append("   ");
        }
        int len1 = this._name.length();
        if (len1 > 12) {
            buf.append(this._name.substring(0, 12));
        } else {
            buf.append(this._name);
            while (buf.length() < 15) {
                buf.append(" ");
            }
        }
        String format = "yyyyMMddHHmmssSSS";
        String startDate = RMAIO.formatDate(this._start, format, tz);
        buf.append(startDate);
        String stopDate = RMAIO.formatDate(this._stop, format, tz);
        buf.append(stopDate);
        String str = buf.toString();
        return str;
    }

    public void setDescription(String str) {
        this._extra = str;
    }

    public String getDescription() {
        return this._extra;
    }

    public void log(String extra) {
        if (BENCH_LOG < 1) {
            return;
        }
        if (_logPath == null) {
            return;
        }
        if (this._extra != null) {
            extra = this._extra;
        }
        StringBuffer logStringBuffer = new StringBuffer(this.toString());
        if (extra != null) {
            logStringBuffer.append(extra);
        }
        try {
            FileWriter fw = new FileWriter(_logPath, true);
            BufferedWriter logWriter = new BufferedWriter(fw);
            logWriter.write(logStringBuffer.toString());
            logWriter.newLine();
            logWriter.close();
        }
        catch (Exception e) {
            System.out.println("Error writing Log Output Stream to file  " + _logPath + "  " + e);
            e.printStackTrace();
        }
    }

    public void log() {
        this.log(null);
    }

    static {
        try {
            _timeZone = System.getProperty("wcds.dbi.BenchLogTimeZone", "UTC");
            tz = TimeZone.getTimeZone(_timeZone);
        }
        catch (Exception e) {
            System.out.println("Timer:static: error " + e);
        }
    }
}

